/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.provider;

import com.wego168.coweb.domain.ClassAndGrade;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.domain.Profession;
import com.wego168.coweb.service.ClassAndGradeService;
import com.wego168.coweb.service.ContactsService;
import com.wego168.coweb.service.ContactsSettingService;
import com.wego168.coweb.service.MyConfigService;
import com.wego168.coweb.service.ProfessionService;
import com.wego168.member.domain.MemberLevel;
import com.wego168.member.service.impl.MemberLevelService;
import com.wego168.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportProvider {
    @Autowired
    private MyConfigService myConfigService;
    @Autowired
    private ClassAndGradeService classAndGradeService;
    @Autowired
    private ProfessionService professionService;
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private ContactsSettingService contactsSettingService;
    @Autowired
    private MemberLevelService memberLevelService;
    private static final Logger logger = LoggerFactory.getLogger(ImportProvider.class);

    public Map<String, Object> importContactsByDefaultDataProcessing(List<Contacts> list) {
        Integer verifyType = 0;
        Map<String, String> classIdMap = this.classAndGradeService.getClassIdMap();
        Set<String> tradeSet = this.myConfigService.getTradeSet();
        Map<String, Profession> professionMap = this.professionService.getProfessionMap();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Serializable> errMap = new HashMap<String, Serializable>();
        LinkedHashMap<String, List<String>> errMsgMap = new LinkedHashMap<String, List<String>>();
        int i = 0;
        for (Contacts contacts : list) {
            String tagName;
            String trade;
            String classId;
            List<String> errMsgList = new ArrayList<String>();
            ++i;
            this.contactsSettingService.validateCowebCheck(contacts);
            String degreeName = contacts.getDegreeName();
            String departmentName = contacts.getDepartmentName();
            String professionName = contacts.getProfessionName();
            errMsgList = this.professionService.checkProfessionIsLegalByImport(degreeName, departmentName, professionName, errMsgList, professionMap);
            String year = contacts.getYear();
            String className = StringUtil.removeAllBlank((String)contacts.getClassName());
            String fullClassName = this.classAndGradeService.generateClassName(year, degreeName, departmentName, professionName, className);
            if (StringUtil.isBlank((String)fullClassName)) {
                errMsgList.add("\u73ed\u7ea7\u4e3a\u7a7a");
            }
            if (StringUtil.isBlank((String)(classId = classIdMap.get(fullClassName)))) {
                errMsgList.add("\u73ed\u7ea7 [" + fullClassName + "] \u4e0e\u540e\u53f0\u914d\u7f6e\u4e0d\u4e00\u81f4");
            } else {
                contacts.setClassId(classId);
            }
            if (tradeSet != null && StringUtils.isNotBlank((CharSequence)(trade = contacts.getTrade()))) {
                if (!tradeSet.contains(trade)) {
                    errMsgList.add("\u884c\u4e1a [" + trade + "] \u4e0e\u540e\u53f0\u914d\u7f6e\u4e0d\u4e00\u81f4");
                }
                contacts.setTrade(trade);
            }
            if (StringUtil.isNotBlank((String)(tagName = contacts.getTagName()))) {
                errMsgList.add("\u6700\u591a\u53ea\u80fd\u6709\u4e09\u4e2a\u6807\u7b7e");
            }
            if (StringUtil.isNotBlank((String)contacts.getMemberLevelName())) {
                MemberLevel memberLevel = this.memberLevelService.selectByName(contacts.getMemberLevelName());
                if (null == memberLevel) {
                    errMsgList.add(contacts.getMemberLevelName() + " \u7b49\u7ea7/\u5934\u8854\uff0c\u540d\u5b57\u6709\u8bef");
                }
                if (null == contacts.getEndMemberLevelJoinTime()) {
                    errMsgList.add("\u5230\u671f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (errMsgList.size() <= 0) continue;
            errMsgMap.put("\u7b2c" + i + "\u6761\u6570\u636e", errMsgList);
        }
        if (errMsgMap.size() > 0) {
            errMap.put("errMsgMap", errMsgMap);
            errMap.put("totalCount", Integer.valueOf(list.size()));
            errMap.put("errCount", Integer.valueOf(errMsgMap.size()));
            resultMap.put("errMap", errMap);
        } else {
            Integer importCount = this.contactsService.importData(list, verifyType);
            resultMap.put("importCount", importCount);
        }
        return resultMap;
    }

    public Map<String, Object> importClassByDefaultDataProcessing(List<ClassAndGrade> list) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<String> legalNameList = new ArrayList<String>();
        LinkedHashMap<String, List<String>> errMap = new LinkedHashMap<String, List<String>>();
        LinkedList<ClassAndGrade> importList = new LinkedList<ClassAndGrade>();
        HashSet<String> importClassNameSet = new HashSet<String>();
        Map<String, Profession> professionMap = this.professionService.getProfessionMap();
        Map<String, String> classIdMap = this.classAndGradeService.getClassIdMap();
        for (ClassAndGrade importClassAndGrade : list) {
            String className;
            List<String> errMsgList = new ArrayList<String>();
            String degreeName = StringUtil.removeAllBlank((String)importClassAndGrade.getDegreeName());
            String departmentName = StringUtil.removeAllBlank((String)importClassAndGrade.getDepartmentName());
            String professionName = StringUtil.removeAllBlank((String)importClassAndGrade.getProfessionName());
            String year = StringUtil.removeAllBlank((String)importClassAndGrade.getYear());
            String fullClassName = this.classAndGradeService.generateClassName(year, degreeName, departmentName, professionName, className = StringUtil.removeAllBlank((String)importClassAndGrade.getClassName()));
            if (importClassNameSet.contains(fullClassName) || !StringUtil.isBlank((String)classIdMap.get(fullClassName))) continue;
            if ((errMsgList = this.professionService.checkProfessionIsLegalByImport(degreeName, departmentName, professionName, errMsgList, professionMap)).size() > 0) {
                errMap.put(fullClassName, errMsgList);
            } else {
                this.classAndGradeService.initClassAndGradeByProfessionName(importClassAndGrade, professionMap, degreeName, departmentName, professionName, fullClassName);
                importList.add(importClassAndGrade);
                legalNameList.add(fullClassName);
            }
            importClassNameSet.add(fullClassName);
        }
        if (importList.size() > 0) {
            this.classAndGradeService.importData(importList);
        }
        resultMap.put("legalNameList", legalNameList);
        resultMap.put("errMap", errMap);
        return resultMap;
    }
}

