/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.provider;

import com.simple.mybatis.Bootmap;
import com.wego168.base.domain.Sign;
import com.wego168.base.domain.SignData;
import com.wego168.base.domain.SignParam;
import com.wego168.base.service.SignDataService;
import com.wego168.course.provider.CourseProvider;
import com.wego168.course.response.CourseResponseParam;
import com.wego168.course.service.CourseSignHandler;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.service.ContactsService;
import com.wego168.member.domain.Member;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.member.util.SessionUtil;
import com.wego168.util.StringUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class MyCourseProvider
implements CourseSignHandler {
    private static final Logger log = LoggerFactory.getLogger(MyCourseProvider.class);
    @Autowired
    private CourseProvider courseProvider;
    @Autowired
    private SignDataService signDataService;
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private MemberService memberService;

    @Transactional
    public CourseResponseParam sign(SignParam activitySign, HttpServletRequest request) {
        CourseResponseParam courseResponseParam = this.courseProvider.sign(activitySign, request);
        return courseResponseParam;
    }

    public void sign(Sign sign, Bootmap bootmap) {
        List signData = this.signDataService.selectNameMobileBySignId(sign.getId());
        Contacts contacts = new Contacts();
        for (SignData sd : signData) {
            if (StringUtil.equals((String)sd.getFieldName(), (String)"name")) {
                contacts.setName(sd.getValue());
            }
            if (StringUtil.equals((String)sd.getFieldName(), (String)"company")) {
                contacts.setCompany(sd.getValue());
            }
            if (StringUtil.equals((String)sd.getFieldName(), (String)"position")) {
                contacts.setPosition(sd.getValue());
            }
            contacts.setAppId(sd.getAppId());
        }
        Member member = this.memberService.selectById(SessionUtil.getMemberIdIfAbsentToThrow());
        if (StringUtil.isNotBlank((String)member.getMobilePhoneNumber())) {
            contacts.setPhone(member.getMobilePhoneNumber());
        }
        if (StringUtil.isNotBlank((String)contacts.getPhone())) {
            log.error("openId{}", (Object)SessionUtil.getOpenIdIfAbsentToThrow());
            this.contactsService.registerContacts(contacts, this.memberAccountService.selectByUsername(SessionUtil.getOpenIdIfAbsentToThrow()));
        }
    }
}

