/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.scheduler;

import com.simple.mybatis.JpaCriteria;
import com.wego168.base.advice.DateTimeUtil;
import com.wego168.base.domain.Comment;
import com.wego168.base.domain.SourceData;
import com.wego168.base.service.CommentService;
import com.wego168.bbs.domain.Information;
import com.wego168.bbs.domain.Report;
import com.wego168.bbs.enums.InformationTypeEnum;
import com.wego168.bbs.service.InformationService;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.enums.CommentSourceTypeEnum;
import com.wego168.coweb.enums.MiniprogarmTempleTypeEnum;
import com.wego168.coweb.service.ContactsService;
import com.wego168.coweb.service.DonateService;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.util.IntegerUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.wechat.api.IWechatAccessToken;
import com.wego168.wechat.api.IWechatSubscribeMessage;
import com.wego168.wx.component.WxMsgTemplateSender;
import com.wego168.wx.domain.WxApp;
import com.wego168.wx.enums.WxAppServiceTypeEnum;
import com.wego168.wx.model.WxMsgTemplateParamter;
import com.wego168.wx.service.WxAppService;
import com.wego168.wxpay.domain.Pay;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component(value="cowebTask")
public class Task {
    @Autowired
    private IWechatAccessToken wechatAccessTokenHelper;
    @Autowired
    private InformationService informationService;
    @Autowired
    private WxAppService wxAppService;
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private CommentService commentService;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private DonateService donateService;
    @Autowired
    private WxMsgTemplateSender wxMsgTemplateSender;
    @Autowired
    private IWechatSubscribeMessage wechatSubscribeMessage;
    private final Logger logger = LoggerFactory.getLogger(Task.class);

    @Scheduled(cron="0 * * * * ?")
    public void updateDonateStatus() {
        this.donateService.updateDonateStatus();
    }

    @Scheduled(cron="0 1 0 1 1 ?")
    public void updateMembershipStatus1() {
        this.contactsService.updateMembershipStatus();
    }

    @Scheduled(cron="0 0 1 1 1 ?")
    public void updateMembershipStatus2() {
        this.contactsService.updateMembershipStatus();
    }

    @Scheduled(cron="0 0 2 1 1 ?")
    public void updateMembershipStatus3() {
        this.contactsService.updateMembershipStatus();
    }

    @Scheduled(cron="0 0 3 1 1 ?")
    public void updateMembershipStatus4() {
        this.contactsService.updateMembershipStatus();
    }

    @Async
    public void sendRegisterTemple(String appId, String openId, String memberName) {
        Integer wxAppServiceType = WxAppServiceTypeEnum.MINI_PROGRAM.value();
        WxApp wxApp = this.wxAppService.selectByAppId(appId, wxAppServiceType.intValue());
        this.logger.error("REGISTER : " + wxApp.getWxAppId());
        Shift.throwsIfNull((Object)wxApp, (String)"\u672a\u6b63\u786e\u914d\u7f6ewxApp");
        String wxappId = wxApp.getWxAppId();
        String wxAppSecret = wxApp.getWxAppSecret();
        String accessToken = this.wechatAccessTokenHelper.getToken(wxappId, wxAppSecret, false);
        String time = DateTimeUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        WxMsgTemplateParamter paramter = WxMsgTemplateParamter.builder((String)appId, (String)"REGISTER", this.getSendAll(appId), (String)"");
        paramter.setAccessToken(accessToken);
        paramter.setServiceType(wxAppServiceType);
        paramter.set("name", (Object)memberName).set("time", (Object)time);
        this.wxMsgTemplateSender.sendTemplate(paramter);
    }

    @Async
    public void sendPublishTemple(String objId, String openId, String memberName, Integer templeType, String unAutoAuditedReason) {
        Information information = (Information)this.informationService.selectById((Object)objId);
        if (information != null) {
            Integer wxAppServiceType = WxAppServiceTypeEnum.MINI_PROGRAM.value();
            WxApp wxApp = this.wxAppService.selectByAppId(information.getAppId(), wxAppServiceType.intValue());
            this.logger.error("INFORMATION_PUBLISH_RESULT : " + wxApp.getWxAppId());
            Shift.throwsIfNull((Object)wxApp, (String)"\u672a\u6b63\u786e\u914d\u7f6ewxApp");
            String wxappId = wxApp.getWxAppId();
            String wxAppSecret = wxApp.getWxAppSecret();
            String accessToken = this.wechatAccessTokenHelper.getToken(wxappId, wxAppSecret, false);
            String url = "pagesCoWebs/information/relay-detail/index?id=" + information.getId() + "&sourceId=" + information.getSourceId();
            if (IntegerUtil.equals((Integer)InformationTypeEnum.TEXT.value(), (Integer)information.getType())) {
                url = "pagesCoWebs/information/detail/index?id=" + information.getId();
            }
            String time = DateTimeUtil.format((Date)information.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss");
            String remark = "";
            if (IntegerUtil.equals((Integer)templeType, (Integer)MiniprogarmTempleTypeEnum.PUBLISH_SUCCESS_WAIT.value())) {
                remark = "\u53d1\u5e03\u6210\u529f,\u7b49\u5f85\u7ba1\u7406\u5458\u5ba1\u6838";
            } else if (IntegerUtil.equals((Integer)templeType, (Integer)MiniprogarmTempleTypeEnum.PUBLISH_SUCCESS.value())) {
                remark = "\u60a8\u53d1\u5e03\u7684\u8d44\u8baf\u5df2\u901a\u8fc7\u5ba1\u6838";
            } else if (IntegerUtil.equals((Integer)templeType, (Integer)MiniprogarmTempleTypeEnum.PUBLISH_FAILED.value())) {
                remark = "\u60a8" + unAutoAuditedReason + ",\u7b49\u5f85\u7ba1\u7406\u5458\u5ba1\u6838";
            }
            String content = information.getContent();
            if (StringUtil.isNotBlank((String)content) && content.length() > 9) {
                content = content.substring(0, 9);
            }
            WxMsgTemplateParamter paramter = WxMsgTemplateParamter.builder((String)information.getAppId(), (String)"INFORMATION_PUBLISH_RESULT", Arrays.asList(openId), (String)url);
            paramter.setAccessToken(accessToken);
            paramter.setServiceType(wxAppServiceType);
            paramter.set("title", (Object)information.getTitle()).set("content", (Object)content).set("time", (Object)time).set("remark", (Object)remark);
            this.wxMsgTemplateSender.sendTemplate(paramter);
        }
    }

    @Async
    public void sendCommentTemple(String content, String appId, String memberId, String parentId, String sourceId, Integer sourceType) {
        MemberAccount targetMemberAccount;
        MemberAccount sourceMemberAccount;
        String url = "";
        String sourceMemberId = "";
        String targetMemberId = "";
        if (IntegerUtil.equals((Integer)sourceType, (Integer)CommentSourceTypeEnum.BBS_INFORMATION.value())) {
            Comment parentComment;
            Information information = (Information)this.informationService.selectById((Object)sourceId);
            sourceMemberId = information.getMemberId();
            if (StringUtil.isNotBlank((String)parentId) && (parentComment = this.commentService.selectById(parentId)) != null) {
                targetMemberId = parentComment.getMemberId();
            }
            url = "pagesCoWebs/information/detail/index?id=" + sourceId + "&sourceId=" + information.getSourceId();
        }
        if (IntegerUtil.equals((Integer)sourceType, (Integer)CommentSourceTypeEnum.ACTIVITY.value())) {
            url = "pagesCoWebs/activity/detail/index?id=" + sourceId;
        }
        Integer wxAppServiceType = WxAppServiceTypeEnum.MINI_PROGRAM.value();
        WxApp wxApp = this.wxAppService.selectByAppId(appId, wxAppServiceType.intValue());
        this.logger.error("COMMENT_SUCCESS ======> wxAppId : " + wxApp.getWxAppId());
        Shift.throwsIfNull((Object)wxApp, (String)"\u672a\u6b63\u786e\u914d\u7f6ewxApp");
        String wxappId = wxApp.getWxAppId();
        String wxAppSecret = wxApp.getWxAppSecret();
        String accessToken = this.wechatAccessTokenHelper.getToken(wxappId, wxAppSecret, false);
        String openId = this.memberAccountService.selectMiniProgramAccount(memberId).getUsername();
        String time = new SimpleDateFormat("yyyy-MM-dd HH:ss").format(new Date());
        String subContent = content.length() > 10 ? content.substring(0, 10) + "..." : content;
        WxMsgTemplateParamter paramter = WxMsgTemplateParamter.builder((String)appId, (String)"COMMENT_SUCCESS", Arrays.asList(openId), (String)url);
        paramter.setAccessToken(accessToken);
        paramter.setServiceType(wxAppServiceType);
        paramter.set("content", (Object)subContent).set("time", (Object)time);
        this.wxMsgTemplateSender.sendTemplate(paramter);
        if (this.isNeedSend(memberId, sourceMemberId, targetMemberId) && (sourceMemberAccount = (MemberAccount)this.memberAccountService.select(JpaCriteria.builder().eq("memberId", (Object)sourceMemberId).eq("appId", (Object)appId))) != null) {
            String sourceMemberOpenId = sourceMemberAccount.getUsername();
            this.logger.error("INFORMATION_BE_COMMENTED ======> wxAppId : " + wxApp.getWxAppId());
            WxMsgTemplateParamter sourceParamter = WxMsgTemplateParamter.builder((String)appId, (String)"INFORMATION_BE_COMMENTED", Arrays.asList(sourceMemberOpenId), (String)url);
            sourceParamter.setAccessToken(accessToken);
            sourceParamter.setServiceType(wxAppServiceType);
            sourceParamter.set("content", (Object)subContent).set("time", (Object)time);
            this.wxMsgTemplateSender.sendTemplate(sourceParamter);
        }
        if (!StringUtil.equals((String)targetMemberId, (String)memberId) && (targetMemberAccount = (MemberAccount)this.memberAccountService.select(JpaCriteria.builder().eq("memberId", (Object)targetMemberId).eq("appId", (Object)appId))) != null) {
            String targetMemberOpenId = targetMemberAccount.getUsername();
            this.logger.error("COMMENT_REPLY ======> wxAppId : " + wxApp.getWxAppId());
            WxMsgTemplateParamter targetParamter = WxMsgTemplateParamter.builder((String)appId, (String)"COMMENT_REPLY", Arrays.asList(targetMemberOpenId), (String)url);
            targetParamter.setAccessToken(accessToken);
            targetParamter.setServiceType(wxAppServiceType);
            targetParamter.set("content", (Object)subContent).set("time", (Object)time);
            this.wxMsgTemplateSender.sendTemplate(targetParamter);
        }
    }

    @Async
    public void sendInformationAuditTemple(Information information, String auditType, Boolean isAudit) {
        Integer wxAppServiceType = WxAppServiceTypeEnum.MINI_PROGRAM.value();
        String appId = information.getAppId();
        WxApp wxApp = this.wxAppService.selectByAppId(appId, wxAppServiceType.intValue());
        this.logger.error("AUDIT_RESULT ======> wxAppId : " + wxApp.getWxAppId());
        Shift.throwsIfNull((Object)wxApp, (String)"\u672a\u6b63\u786e\u914d\u7f6ewxApp");
        MemberAccount memberAccount = (MemberAccount)this.memberAccountService.select(JpaCriteria.builder().eq("memberId", (Object)information.getMemberId()).eq("appId", (Object)appId));
        if (memberAccount != null) {
            String content;
            String openId = memberAccount.getUsername();
            String wxappId = wxApp.getWxAppId();
            String wxAppSecret = wxApp.getWxAppSecret();
            String accessToken = this.wechatAccessTokenHelper.getToken(wxappId, wxAppSecret, false);
            String informationType = "";
            if (IntegerUtil.equals((Integer)information.getType(), (Integer)InformationTypeEnum.TEXT.value())) {
                informationType = InformationTypeEnum.TEXT.description();
            } else if (IntegerUtil.equals((Integer)information.getType(), (Integer)InformationTypeEnum.ACTIVITY.value())) {
                informationType = InformationTypeEnum.ACTIVITY.description();
            }
            auditType = informationType + "-" + auditType;
            String auditResult = "";
            auditResult = isAudit != false ? "\u5ba1\u6838\u901a\u8fc7" : "\u5ba1\u6838\u4e0d\u901a\u8fc7,\u8d44\u8baf\u5df2\u4e0b\u67b6";
            String time = DateTimeUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            String url = "pagesCoWebs/information/detail/index?id=" + information.getId() + "&sourceId=" + information.getSourceId();
            if (IntegerUtil.equals((Integer)information.getType(), (Integer)InformationTypeEnum.TEXT.value())) {
                url = "pagesCoWebs/information/detail/index?id=" + information.getId();
            }
            if (StringUtil.isNotBlank((String)(content = information.getContent())) && content.length() > 10) {
                content = content.substring(0, 10) + "...";
            }
            WxMsgTemplateParamter paramter = WxMsgTemplateParamter.builder((String)appId, (String)"AUDIT_RESULT", Arrays.asList(openId), (String)url);
            paramter.setAccessToken(accessToken);
            paramter.setServiceType(wxAppServiceType);
            paramter.set("title", (Object)information.getTitle()).set("auditResult", (Object)auditResult).set("content", (Object)content).set("time", (Object)time);
            this.wxMsgTemplateSender.sendTemplate(paramter);
        }
    }

    @Async
    public void sendInformationReportTemple(Information information, Report report) {
        Integer wxAppServiceType = WxAppServiceTypeEnum.MINI_PROGRAM.value();
        String appId = information.getAppId();
        WxApp wxApp = this.wxAppService.selectByAppId(appId, wxAppServiceType.intValue());
        this.logger.error("REPORT_DEAL ======> wxAppId : " + wxApp.getWxAppId());
        Shift.throwsIfNull((Object)wxApp, (String)"\u672a\u6b63\u786e\u914d\u7f6ewxApp");
        MemberAccount memberAccount = (MemberAccount)this.memberAccountService.select(JpaCriteria.builder().eq("memberId", (Object)information.getMemberId()).eq("appId", (Object)appId));
        if (memberAccount != null) {
            String openId = memberAccount.getUsername();
            String wxappId = wxApp.getWxAppId();
            String wxAppSecret = wxApp.getWxAppSecret();
            String accessToken = this.wechatAccessTokenHelper.getToken(wxappId, wxAppSecret, false);
            String reportReason = report.getReportReason();
            if (StringUtil.isBlank((String)reportReason)) {
                reportReason = report.getOtherReason();
            }
            String time = DateTimeUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            String result = "\u5df2\u88ab\u6682\u65f6\u4e0b\u67b6";
            String remark = "\u5982\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
            String url = "pagesCoWebs/information/detail/index?id=" + information.getId() + "&sourceId=" + information.getId();
            WxMsgTemplateParamter paramter = WxMsgTemplateParamter.builder((String)appId, (String)"REPORT_DEAL", Arrays.asList(openId), (String)url);
            paramter.setAccessToken(accessToken);
            paramter.setServiceType(wxAppServiceType);
            paramter.set("reportReason", (Object)reportReason).set("time", (Object)time).set("result", (Object)result).set("remark", (Object)remark);
            this.wechatSubscribeMessage.sendSubscribeMessage2(accessToken, openId, "REPORT_DEAL", url, (Map)paramter);
        }
    }

    @Async
    public void sendPayTemple(Pay pay, String payType, String url) {
        Integer wxAppServiceType = WxAppServiceTypeEnum.MINI_PROGRAM.value();
        String appId = pay.getAppId();
        WxApp wxApp = this.wxAppService.selectByAppId(appId, wxAppServiceType.intValue());
        this.logger.error("PAY_SUCCESS ======> wxAppId : " + wxApp.getWxAppId());
        Shift.throwsIfNull((Object)wxApp, (String)"\u672a\u6b63\u786e\u914d\u7f6ewxApp");
        MemberAccount memberAccount = (MemberAccount)this.memberAccountService.select(JpaCriteria.builder().eq("memberId", (Object)pay.getMemberId()).eq("appId", (Object)appId));
        if (memberAccount != null) {
            String openId = memberAccount.getUsername();
            String wxappId = wxApp.getWxAppId();
            String wxAppSecret = wxApp.getWxAppSecret();
            String accessToken = this.wechatAccessTokenHelper.getToken(wxappId, wxAppSecret, false);
            String amount = String.format("%.2f", (double)pay.getAmount().intValue() / 100.0) + "\u5143";
            String time = DateTimeUtil.format((Date)pay.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss");
            String payStatus = "\u5df2\u652f\u4ed8";
            WxMsgTemplateParamter paramter = WxMsgTemplateParamter.builder((String)appId, (String)"PAY_SUCCESS", Arrays.asList(openId), (String)url);
            paramter.setAccessToken(accessToken);
            paramter.setServiceType(wxAppServiceType);
            paramter.set("payType", (Object)payType).set("amount", (Object)amount).set("time", (Object)time).set("payStatus", (Object)payStatus);
            this.wechatSubscribeMessage.sendSubscribeMessage2(accessToken, openId, "PAY_SUCCESS", url, (Map)paramter);
        }
    }

    @Async
    public void sendInformationPraiseTemple(Information information, SourceData sourceData, String praiseMemberId) {
        if (information != null) {
            Integer wxAppServiceType = WxAppServiceTypeEnum.MINI_PROGRAM.value();
            String appId = information.getAppId();
            WxApp wxApp = this.wxAppService.selectByAppId(appId, wxAppServiceType.intValue());
            this.logger.error("INFORMATION_PRAISE ======> wxAppId : " + wxApp.getWxAppId());
            Shift.throwsIfNull((Object)wxApp, (String)"\u672a\u6b63\u786e\u914d\u7f6ewxApp");
            MemberAccount memberAccount = (MemberAccount)this.memberAccountService.select(JpaCriteria.builder().eq("memberId", (Object)information.getMemberId()).eq("appId", (Object)appId));
            if (memberAccount != null) {
                String openId = memberAccount.getUsername();
                String wxappId = wxApp.getWxAppId();
                String wxAppSecret = wxApp.getWxAppSecret();
                String accessToken = this.wechatAccessTokenHelper.getToken(wxappId, wxAppSecret, false);
                String title = information.getTitle();
                Integer praiseQuantity = sourceData.getPraiseQuantity();
                String time = DateTimeUtil.format((Date)sourceData.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss");
                String url = "pagesCoWebs/information/detail/index?id=" + information.getId() + "&sourceId=" + information.getSourceId();
                if (IntegerUtil.equals((Integer)information.getType(), (Integer)InformationTypeEnum.TEXT.value())) {
                    url = "pagesCoWebs/information/detail/index?id=" + information.getId();
                }
                title = title + "\u5171\u6709 " + praiseQuantity + " \u6b21\u70b9\u8d5e";
                WxMsgTemplateParamter paramter = WxMsgTemplateParamter.builder((String)appId, (String)"INFORMATION_PRAISE", Arrays.asList(openId), (String)url);
                paramter.setAccessToken(accessToken);
                paramter.setServiceType(wxAppServiceType);
                paramter.set("title", (Object)title).set("time", (Object)time);
                this.wxMsgTemplateSender.sendTemplate(paramter);
            }
        }
    }

    private List<String> getSendAll(String appId) {
        List contactsList = this.contactsService.selectList(JpaCriteria.builder().eq("appId", (Object)appId).eq("isBind", (Object)1));
        ArrayList<String> openIds = new ArrayList<String>();
        for (Contacts contacts : contactsList) {
            MemberAccount memberAccount = this.memberAccountService.selectMiniProgramAccount(contacts.getMemberId());
            Shift.throwsIfNull((Object)memberAccount, (String)("\u627e\u4e0d\u5230\u6821\u53cb\u5e93\u7ed1\u5b9a\u7684\u7528\u6237\u8d44\u6599" + contacts.getId()));
            openIds.add(memberAccount.getUsername());
        }
        return openIds;
    }

    private boolean isNeedSend(String memberId, String sourceMemberId, String targetMemberId) {
        return StringUtil.isBlank((String)targetMemberId) ? !StringUtil.equals((String)sourceMemberId, (String)memberId) : !StringUtil.equals((String)sourceMemberId, (String)memberId) && !StringUtil.equals((String)sourceMemberId, (String)targetMemberId);
    }
}

