/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.coweb.domain.BusinessCardCollection;
import com.wego168.coweb.domain.interfaces.CollectableBusinessCard;
import com.wego168.coweb.persistence.BusinessCardCollectionMapper;
import com.wego168.coweb.persistence.BusinessCardMapper;
import com.wego168.persistence.CrudMapper;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.service.CrudService;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BusinessCardCollectionService
extends CrudService<BusinessCardCollection> {
    @Autowired
    private BusinessCardMapper cardMapper;
    @Autowired
    private BusinessCardCollectionMapper mapper;
    @Autowired
    private SimpleRedisTemplate redisTemplate;

    public CrudMapper<BusinessCardCollection> getMapper() {
        return this.mapper;
    }

    public boolean collected(String businessCardId, String memberId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("businessCardId", (Object)businessCardId).eq("memberId", (Object)memberId);
        return this.mapper.selectCount(criteria) > 0;
    }

    @Transactional
    public void collect(String businessCardId, String memberId) {
        BusinessCardCollection collection = new BusinessCardCollection();
        collection.setBusinessCardId(businessCardId);
        collection.setCreateTime(new Date());
        collection.setMemberId(memberId);
        this.mapper.insert(collection);
        this.cardMapper.addCollectQuantity(businessCardId);
        this.cacheCollect(businessCardId, memberId);
    }

    @Transactional
    public void cancelCollect(String businessCardId, String memberId) {
        int rows = this.mapper.delete(JpaCriteria.builder().eq("businessCardId", (Object)businessCardId).eq("memberId", (Object)memberId));
        if (rows > 0) {
            this.cardMapper.minusCollectQuantity(businessCardId);
            this.removeCacheCollect(businessCardId, memberId);
        }
    }

    public void assembleCollect(List<? extends CollectableBusinessCard> list, String memberId) {
        if (Checker.listNotEmpty(list) && StringUtil.isNotBlank((String)memberId)) {
            Map<Object, Object> memberCollections = this.getMemberCollections(memberId);
            Iterator<? extends CollectableBusinessCard> iterator = list.iterator();
            while (iterator.hasNext()) {
                CollectableBusinessCard businessCard;
                String businessCardId = (businessCard = iterator.next()).getBusinessCardId();
                Object cache = memberCollections.get(businessCardId);
                businessCard.setCollected(cache != null);
            }
        }
    }

    public void assembleCollect(CollectableBusinessCard collectableBusinessCard, String memberId) {
        if (StringUtil.isNotBlank((String)memberId)) {
            String businessCardId;
            Map<Object, Object> memberCollections = this.getMemberCollections(memberId);
            Object cache = memberCollections.get(businessCardId = collectableBusinessCard.getBusinessCardId());
            collectableBusinessCard.setCollected(cache != null);
        }
    }

    private Map<Object, Object> getMemberCollections(String memberId) {
        String redisKey = "member-collect-business-card-" + memberId;
        return this.redisTemplate.getMap(redisKey);
    }

    private void cacheCollect(String businessCardId, String memberId) {
        String redisKey = "member-collect-business-card-" + memberId;
        String mapKey = businessCardId;
        this.redisTemplate.putMap(redisKey, mapKey, (Object)1);
    }

    private void removeCacheCollect(String businessCardId, String memberId) {
        String redisKey = "member-collect-business-card-" + memberId;
        String mapKey = businessCardId;
        this.redisTemplate.putMap(redisKey, mapKey, null);
    }
}

