/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.base.advice.FileUploadUtil;
import com.wego168.base.domain.FileServer;
import com.wego168.base.domain.Storable;
import com.wego168.base.service.FileServerService;
import com.wego168.base.service.StorableService;
import com.wego168.coweb.domain.BusinessCardQrcode;
import com.wego168.coweb.persistence.BusinessCardQrcodeMapper;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.CrudService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.Checker;
import com.wego168.util.SequenceUtil;
import com.wego168.wechat.impl.WechatAccessTokenHelper;
import com.wego168.wx.domain.WxApp;
import com.wego168.wx.enums.WxAppServiceTypeEnum;
import com.wego168.wx.service.WxAppService;
import com.wego168.wx.token.SmallProgramUtil;
import java.awt.image.BufferedImage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessCardQrcodeService
extends CrudService<BusinessCardQrcode> {
    @Autowired
    private BusinessCardQrcodeMapper mapper;
    @Autowired
    private FileServerService fileServerService;
    @Autowired
    private StorableService storableService;
    @Autowired
    private WxAppService wxAppService;
    @Autowired
    private WechatAccessTokenHelper wechatAccessTokenHelper;

    public CrudMapper<BusinessCardQrcode> getMapper() {
        return this.mapper;
    }

    public BusinessCardQrcode getOrCreate(String businessCardId, String pagePath, String appId) {
        BusinessCardQrcode qrcode = this.selectByBusinessCardId(businessCardId);
        if (qrcode == null) {
            qrcode = this.create(businessCardId, pagePath, appId);
        }
        this.storableService.assembleHost((Storable)qrcode);
        return qrcode;
    }

    public BusinessCardQrcode selectByScene(String scene) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("scene", (Object)scene);
        return (BusinessCardQrcode)((Object)this.mapper.select(criteria));
    }

    private BusinessCardQrcode create(String businessCardId, String pagePath, String appId) {
        BusinessCardQrcode qrcode = new BusinessCardQrcode();
        BaseDomainUtil.initBaseDomain((BaseDomain)qrcode, (String)appId);
        qrcode.setMiniProgramPagePath(pagePath);
        qrcode.setBusinessCardId(businessCardId);
        String scene = SequenceUtil.createUuid();
        qrcode.setScene(scene);
        FileServer fileServer = this.fileServerService.ensure();
        qrcode.setServerId(fileServer.getId());
        String fileName = scene + ".png";
        int serviceType = WxAppServiceTypeEnum.MINI_PROGRAM.value();
        WxApp miniProgram = this.wxAppService.ensureMiniProgramApp(appId, serviceType);
        String token = this.wechatAccessTokenHelper.getToken(miniProgram.getWxAppId(), miniProgram.getWxAppSecret(), false);
        BufferedImage bufferedImage = SmallProgramUtil.createMiniProgramQrcode((String)token, (String)pagePath, (String)scene, (boolean)false);
        String errorMessage = "\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u5c0f\u7a0b\u5e8f[" + miniProgram.getName() + "]\u5c1a\u672a\u901a\u8fc7\u5ba1\u6838\uff0c\u6216\u9875\u9762\u8def\u5f84\u4e0d\u5b58\u5728";
        Checker.checkCondition((bufferedImage == null ? 1 : 0) != 0, (String)errorMessage);
        String url = FileUploadUtil.upload2Cos((BufferedImage)bufferedImage, (String)("business-card/" + appId), (String)fileName, (FileServer)fileServer);
        qrcode.setUrl(url);
        this.mapper.insert((Object)qrcode);
        return qrcode;
    }

    private BusinessCardQrcode selectByBusinessCardId(String businessCardId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("businessCardId", (Object)businessCardId);
        return (BusinessCardQrcode)((Object)this.mapper.select(criteria));
    }
}

