/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.simple.mybatis.util.ReflectionUtil;
import com.wego168.coweb.domain.BusinessCard;
import com.wego168.coweb.domain.BusinessCardVisibility;
import com.wego168.coweb.enums.BusinessCardVisibilityType;
import com.wego168.coweb.model.response.BusinessCardCollectionListResponse;
import com.wego168.coweb.model.response.BusinessCardListResponse;
import com.wego168.coweb.model.response.MyBusinessCardListResponse;
import com.wego168.coweb.persistence.BusinessCardMapper;
import com.wego168.coweb.persistence.BusinessCardVisibilityMapper;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.service.CrudService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BusinessCardService
extends CrudService<BusinessCard> {
    @Autowired
    private BusinessCardMapper mapper;
    @Autowired
    private BusinessCardVisibilityMapper visibilityMapper;
    @Autowired
    private SimpleRedisTemplate redisTemplate;
    private String[] searchInTheseProperties = new String[]{"name", "company", "position", "phone"};

    public CrudMapper<BusinessCard> getMapper() {
        return this.mapper;
    }

    public List<BusinessCardListResponse> selectWechatPage(String appId, String keyword, String orderBy, Page page) {
        List<BusinessCardListResponse> list;
        page.put((Object)"appId", (Object)appId);
        page.put((Object)"orderBy", (Object)this.determineOrderBySql("card.", orderBy));
        if (StringUtil.isNotBlank((String)keyword)) {
            page.put((Object)"keyword", (Object)("%" + keyword + "%"));
        }
        if (Checker.listNotEmpty(list = this.mapper.selectWechatPage(page))) {
            for (BusinessCardListResponse businessCardListResponse : list) {
                businessCardListResponse.erase();
            }
        }
        return list;
    }

    public List<BusinessCardCollectionListResponse> selectCollectPage(String appId, String memberId, Page page) {
        page.put((Object)"appId", (Object)appId);
        page.put((Object)"memberId", (Object)memberId);
        List<BusinessCardCollectionListResponse> list = this.mapper.selectCollectPage(page);
        if (Checker.listNotEmpty(list)) {
            for (BusinessCardCollectionListResponse r : list) {
                r.erase();
            }
        }
        return list;
    }

    public List<MyBusinessCardListResponse> selectMemberList(String memberId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("memberId", (Object)memberId);
        criteria.eq("isDeleted", (Object)false);
        criteria.orderBy("top DESC, createTime DESC");
        return super.selectList(criteria, MyBusinessCardListResponse.class);
    }

    @Transactional
    public void insertBusinessCardAndVisibility(BusinessCard businessCard) {
        BusinessCardVisibility visibility = new BusinessCardVisibility();
        BaseDomainUtil.initBaseDomain((BaseDomain)visibility, (String)businessCard.getAppId());
        visibility.setId(businessCard.getId());
        visibility.setAddressVisibility(BusinessCardVisibilityType.PUBLIC.value());
        visibility.setCompanyVisibility(BusinessCardVisibilityType.PUBLIC.value());
        visibility.setEmailVisibility(BusinessCardVisibilityType.PUBLIC.value());
        visibility.setHonorVisibility(BusinessCardVisibilityType.PUBLIC.value());
        visibility.setMemberId(businessCard.getMemberId());
        visibility.setNameVisibility(BusinessCardVisibilityType.PUBLIC.value());
        visibility.setPhoneVisibility(BusinessCardVisibilityType.PUBLIC.value());
        visibility.setPositionVisibility(BusinessCardVisibilityType.PUBLIC.value());
        visibility.setWechatVisibility(BusinessCardVisibilityType.PUBLIC.value());
        this.buildSearchColumn(businessCard, visibility);
        this.mapper.insert((Object)businessCard);
        this.visibilityMapper.insert((Object)visibility);
    }

    public boolean overQuantity(String memberId, String appId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("memberId", (Object)memberId).eq("isDeleted", (Object)false);
        return this.mapper.selectCount(criteria) >= this.getMaxBusinessCardQuantityPerMember(appId);
    }

    public BusinessCard selectByIdAndMemberId(String id, String memberId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("id", (Object)id).eq("memberId", (Object)memberId);
        return (BusinessCard)((Object)this.mapper.select(criteria));
    }

    public int getMaxBusinessCardQuantityPerMember(String appId) {
        String key = "max-business-card-quantity-per-member-" + appId;
        Integer quantity = (Integer)this.redisTemplate.get("max-business-card-quantity-per-member-" + appId, Integer.class);
        if (quantity == null) {
            quantity = 3;
            this.redisTemplate.set(key, (Object)quantity);
        }
        return quantity;
    }

    public String buildSearchColumn(BusinessCard businessCard, BusinessCardVisibility visibility) {
        Map fieldMap = ReflectionUtil.getDeclaredFields(BusinessCard.class);
        Map visibilityFieldMap = ReflectionUtil.getDeclaredFields(BusinessCardVisibility.class);
        StringBuffer searchColumn = new StringBuffer();
        for (String property : this.searchInTheseProperties) {
            Field visibilityField;
            String propertyVisibility;
            Field field = (Field)fieldMap.get(property);
            Object value = ReflectionUtil.getValue((Field)field, (Object)((Object)businessCard));
            if (value == null || !StringUtil.equals((String)(propertyVisibility = (String)ReflectionUtil.getValue((Field)(visibilityField = (Field)visibilityFieldMap.get(property + "Visibility")), (Object)((Object)visibility))), (String)BusinessCardVisibilityType.PUBLIC.value())) continue;
            if (value instanceof String) {
                searchColumn.append((String)value);
                continue;
            }
            searchColumn.append(value.toString());
        }
        String searchColumnString = searchColumn.toString();
        businessCard.setSearchColumn(searchColumnString);
        return searchColumnString;
    }

    public void setTop(String id, String memberId) {
        JpaCriteria criteria = JpaCriteria.builder().set("top", (Object)0).eq("memberId", (Object)memberId);
        this.mapper.updateSelective(criteria);
        BusinessCard param = new BusinessCard();
        param.setId(id);
        param.setUpdateTime(new Date());
        param.setTop(1);
        this.mapper.updateSelective((Object)param);
    }

    public void cancelTop(String id) {
        JpaCriteria criteria = JpaCriteria.builder().set("top", (Object)0).set("updateTime", (Object)new Date()).eq("id", (Object)id);
        this.mapper.updateSelective(criteria);
    }

    @Async
    public void addViewQuantityAsync(String id) {
        this.mapper.addViewQuantity(id);
    }

    private String determineOrderBySql(String businessCardAlias, String orderBy) {
        String orderBySql = businessCardAlias + " create_time DESC";
        if (StringUtil.equals((String)orderBy, (String)"more-collect-first")) {
            orderBySql = businessCardAlias + " collect_quantity DESC";
        } else if (StringUtil.equals((String)orderBy, (String)"more-view-first")) {
            orderBySql = businessCardAlias + " view_quantity DESC";
        } else if (StringUtil.equals((String)orderBy, (String)"more-active-first")) {
            orderBySql = businessCardAlias + " update_time DESC";
        }
        return orderBySql;
    }
}

