/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.coweb.domain.BusinessCardStyleTemplate;
import com.wego168.coweb.persistence.BusinessCardStyleTemplateMapper;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.CrudService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.Checker;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessCardStyleTemplateService
extends CrudService<BusinessCardStyleTemplate> {
    @Autowired
    private BusinessCardStyleTemplateMapper mapper;

    public CrudMapper<BusinessCardStyleTemplate> getMapper() {
        return this.mapper;
    }

    public List<BusinessCardStyleTemplate> selectListByAppId(String appId) {
        String[] visibility = null;
        return this.selectListByAppId(appId, visibility);
    }

    public List<BusinessCardStyleTemplate> selectListByAppId(String appId, String[] visibility) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("appId", (Object)appId);
        if (visibility != null) {
            criteria.in("visibility", (Object[])visibility);
        }
        criteria.orderBy("sortNumber DESC");
        List<BusinessCardStyleTemplate> list = this.mapper.selectList(criteria);
        if (Checker.listIsEmpty((List)list)) {
            list = this.init(appId);
        }
        return list;
    }

    private List<BusinessCardStyleTemplate> init(String appId) {
        ArrayList<BusinessCardStyleTemplate> list = new ArrayList<BusinessCardStyleTemplate>(4);
        BusinessCardStyleTemplate templateA = new BusinessCardStyleTemplate();
        BaseDomainUtil.initBaseDomain((BaseDomain)templateA, (String)appId);
        templateA.setCode("a");
        templateA.setName("\u9ed8\u8ba4\u6837\u5f0fa");
        templateA.setSortNumber(100);
        templateA.setVisibility("public");
        list.add(templateA);
        BusinessCardStyleTemplate templateB = new BusinessCardStyleTemplate();
        BaseDomainUtil.initBaseDomain((BaseDomain)templateB, (String)appId);
        templateB.setCode("b");
        templateB.setName("\u9ed8\u8ba4\u6837\u5f0fb");
        templateB.setSortNumber(90);
        templateB.setVisibility("public");
        list.add(templateB);
        BusinessCardStyleTemplate templateC = new BusinessCardStyleTemplate();
        BaseDomainUtil.initBaseDomain((BaseDomain)templateC, (String)appId);
        templateC.setCode("c");
        templateC.setName("\u9ed8\u8ba4\u6837\u5f0fc");
        templateC.setSortNumber(80);
        templateC.setVisibility("public");
        list.add(templateC);
        BusinessCardStyleTemplate templateD = new BusinessCardStyleTemplate();
        BaseDomainUtil.initBaseDomain((BaseDomain)templateD, (String)appId);
        templateD.setCode("d");
        templateD.setName("\u9ed8\u8ba4\u6837\u5f0fd");
        templateD.setSortNumber(70);
        templateD.setVisibility("public");
        list.add(templateD);
        this.mapper.insertBatch(list);
        return list;
    }
}

