/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaCriteria;
import com.wego168.coweb.domain.ClassAndGrade;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.domain.Profession;
import com.wego168.coweb.enums.ProfessionTypeEnum;
import com.wego168.coweb.persistence.ClassAndGradeMapper;
import com.wego168.coweb.persistence.ContactsMapper;
import com.wego168.coweb.service.ProfessionService;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.IntegerUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClassAndGradeService
extends BaseService<ClassAndGrade> {
    @Autowired
    private ProfessionService professionService;
    @Autowired
    private ClassAndGradeMapper classAndGradeMapper;
    @Autowired
    private ContactsMapper contactsMapper;

    public CrudMapper<ClassAndGrade> getMapper() {
        return this.classAndGradeMapper;
    }

    public ClassAndGrade selectByClassName(String className) {
        return (ClassAndGrade)((Object)super.select(JpaCriteria.builder().eq("appId", (Object)this.getAppId()).eq("isDeleted", (Object)false).eq("className", (Object)className)));
    }

    public List<ClassAndGrade> selectClassList() {
        return super.selectList(JpaCriteria.builder().eq("appId", (Object)this.getAppId()).eq("isDeleted", (Object)false).orderBy("seq_num,class_name"));
    }

    public String getClassNameById(String classId) {
        ClassAndGrade classAndGrade = (ClassAndGrade)((Object)super.selectById((Object)classId));
        Shift.throwsIfInvalid((classAndGrade == null || classAndGrade.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u73ed\u7ea7\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        return classAndGrade.getClassName();
    }

    public String getClassIdByName(String className) {
        ClassAndGrade classAndGrade = this.selectByClassName(className);
        Shift.throwsIfInvalid((classAndGrade == null || classAndGrade.getIsDeleted() != false ? 1 : 0) != 0, (String)("\u73ed\u7ea7" + className + "\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664"));
        return classAndGrade.getId();
    }

    @Transactional
    public Integer importData(List<ClassAndGrade> list) {
        return super.insertBatch(list);
    }

    public Double getPercent(ClassAndGrade classAndGrade) {
        if (classAndGrade.getJoinMemberAmount() != 0) {
            Integer joinMemberAmount = classAndGrade.getJoinMemberAmount();
            Integer classMemberAmount = classAndGrade.getClassMemberAmount();
            if (IntegerUtil.equals((Integer)classMemberAmount, (Integer)0)) {
                return 0.0;
            }
            Double percent = new BigDecimal((double)joinMemberAmount.intValue() / (double)classMemberAmount.intValue()).setScale(2, 4).doubleValue();
            return percent;
        }
        return 0.0;
    }

    @Transactional
    public void updateClassMemberAmountByMap(Map<String, Integer> classMemberAmountMap) {
        Set<String> classIdSet = classMemberAmountMap.keySet();
        ArrayList<String> classIdList = new ArrayList<String>(classIdSet);
        for (String classId : classIdList) {
            ClassAndGrade classAndGrade = (ClassAndGrade)((Object)this.selectById(classId));
            classAndGrade.setClassMemberAmount(classAndGrade.getClassMemberAmount() + classMemberAmountMap.get(classId));
            classAndGrade.setPercent(this.getPercent(classAndGrade));
            classAndGrade.setUpdateTime(new Date());
            super.updateSelective((Object)classAndGrade);
        }
    }

    @Transactional
    public void updateClassMemberAmount(String newClassId, String oldClassId, Integer changeAmount, Boolean isBind) {
        if (changeAmount != 0) {
            ClassAndGrade newClassAndGrade = (ClassAndGrade)((Object)this.selectById(newClassId));
            ClassAndGrade oldClassAndGrade = null;
            if (StringUtil.isNotBlank((String)oldClassId)) {
                oldClassAndGrade = (ClassAndGrade)((Object)this.selectById(oldClassId));
            }
            this.updateClassMemberAmount(newClassAndGrade, oldClassAndGrade, changeAmount, isBind);
        }
    }

    @Transactional
    public void updateClassMemberAmount(ClassAndGrade newClassAndGrade, ClassAndGrade oldClassAndGrade, Integer changeAmount, Boolean isBind) {
        if (changeAmount != 0) {
            Date date = new Date();
            newClassAndGrade.setClassMemberAmount(newClassAndGrade.getClassMemberAmount() + changeAmount);
            if (isBind.booleanValue()) {
                newClassAndGrade.setJoinMemberAmount(newClassAndGrade.getJoinMemberAmount() + changeAmount);
            }
            newClassAndGrade.setPercent(this.getPercent(newClassAndGrade));
            newClassAndGrade.setUpdateTime(date);
            super.updateSelective((Object)newClassAndGrade);
            if (oldClassAndGrade != null) {
                oldClassAndGrade.setClassMemberAmount(oldClassAndGrade.getClassMemberAmount() - changeAmount);
                if (isBind.booleanValue()) {
                    oldClassAndGrade.setJoinMemberAmount(oldClassAndGrade.getJoinMemberAmount() - changeAmount);
                }
                oldClassAndGrade.setPercent(this.getPercent(oldClassAndGrade));
                oldClassAndGrade.setUpdateTime(date);
                super.updateSelective((Object)oldClassAndGrade);
            }
        }
    }

    public List<ClassAndGrade> selectClassAndGradeRank() {
        return this.classAndGradeMapper.selectClassAndGradeRank(this.getAppId(), false);
    }

    @Transactional
    public void refreshClassMemberAmount() {
        HashMap<String, Object> classMap = new HashMap<String, Object>();
        List classList = super.selectList(JpaCriteria.builder());
        for (Object classAndGrade : classList) {
            ((ClassAndGrade)((Object)classAndGrade)).setClassMemberAmount(0);
            ((ClassAndGrade)((Object)classAndGrade)).setJoinMemberAmount(0);
            classMap.put(classAndGrade.getId(), classAndGrade);
        }
        List<Bootmap> totalAmountList = this.contactsMapper.selectClassTotalAmount(this.getAppId(), false);
        for (Bootmap bootmap : totalAmountList) {
            String classId = bootmap.getString("classId");
            Integer amount = bootmap.getInteger("amount");
            ClassAndGrade classAndGrade = (ClassAndGrade)((Object)classMap.get(classId));
            classAndGrade.setClassMemberAmount(amount);
        }
        List<Bootmap> joinAmountList = this.contactsMapper.selectClassJoinAmount(this.getAppId(), false);
        for (Bootmap bootmap : joinAmountList) {
            String classId = bootmap.getString("classId");
            Integer amount = bootmap.getInteger("amount");
            ClassAndGrade classAndGrade = (ClassAndGrade)((Object)classMap.get(classId));
            classAndGrade.setJoinMemberAmount(amount);
        }
        for (ClassAndGrade classAndGrade : classList) {
            classAndGrade.setPercent(this.getPercent(classAndGrade));
            super.updateSelective((Object)classAndGrade);
        }
    }

    public void insertClassAndGrade(ClassAndGrade classAndGrade) {
        String className = this.generateClassName(classAndGrade);
        ClassAndGrade vo = this.selectByClassName(className);
        Shift.throwsIfInvalid((vo != null ? 1 : 0) != 0, (String)"\u8be5\u73ed\u7ea7\u5df2\u5b58\u5728");
        classAndGrade.setClassName(className);
        classAndGrade = this.initClassAndGrade(classAndGrade);
        super.insert((Object)classAndGrade);
    }

    public ClassAndGrade initClassAndGradeByProfessionName(ClassAndGrade classAndGrade, Map<String, Profession> professionMap, String degreeName, String departmentName, String professionName, String fullClassName) {
        if (StringUtil.isNotBlank((String)degreeName)) {
            Profession degree = professionMap.get(degreeName);
            classAndGrade.setDegreeId(degree.getId());
            if (StringUtil.isNotBlank((String)departmentName)) {
                Map<String, Profession> departmentMap = degree.getChildMap();
                Profession department = departmentMap.get(departmentName);
                classAndGrade.setDepartmentId(department.getId());
                if (StringUtil.isNotBlank((String)professionName)) {
                    Map<String, Profession> childMap = department.getChildMap();
                    Profession profession = childMap.get(professionName);
                    classAndGrade.setProfessionId(profession.getId());
                }
            }
        }
        classAndGrade.setClassName(fullClassName);
        this.initClassAndGrade(classAndGrade);
        return classAndGrade;
    }

    public ClassAndGrade initClassAndGrade(ClassAndGrade classAndGrade) {
        classAndGrade.setClassMemberAmount(0);
        classAndGrade.setJoinMemberAmount(0);
        classAndGrade.setPercent(0.0);
        classAndGrade.setUpdateTime(new Date());
        if (classAndGrade.getSeqNum() == null) {
            classAndGrade.setSeqNum(300);
        }
        return classAndGrade;
    }

    public Map<String, String> getClassIdMap() {
        List<ClassAndGrade> list = this.selectClassList();
        HashMap<String, String> idMap = new HashMap<String, String>();
        if (list != null && list.size() > 0) {
            for (ClassAndGrade classAndGrade : list) {
                idMap.put(classAndGrade.getClassName(), classAndGrade.getId());
            }
        }
        return idMap;
    }

    public void replaceClassNameByDegreeId(String degreeId, String oldName, String newName) {
        this.classAndGradeMapper.replaceClassNameByDegreeId(degreeId, oldName, newName);
    }

    public void replaceClassNameByDepartmentId(String departmentId, String oldName, String newName) {
        this.classAndGradeMapper.replaceClassNameByDepartmentId(departmentId, oldName, newName);
    }

    public void replaceClassNameByProfessionId(String professionId, String oldName, String newName) {
        this.classAndGradeMapper.replaceClassNameByDegreeId(professionId, oldName, newName);
    }

    public String generateClassName(ClassAndGrade classAndGrade) {
        String degreeId = classAndGrade.getDegreeId();
        String departmentId = classAndGrade.getDepartmentId();
        String professionId = classAndGrade.getProfessionId();
        String year = classAndGrade.getYear();
        String className = classAndGrade.getClassName();
        Profession degree = null;
        Profession department = null;
        Profession profession = null;
        String professionName = null;
        if (StringUtil.isNotBlank((String)degreeId)) {
            degree = (Profession)((Object)this.professionService.selectById(degreeId));
            Shift.throwsIfInvalid((degree == null || degree.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u5b66\u4f4d\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        if (StringUtil.isNotBlank((String)departmentId)) {
            department = (Profession)((Object)this.professionService.selectById(departmentId));
            Shift.throwsIfInvalid((department == null || department.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u7cfb\u522b\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        if (StringUtil.isNotBlank((String)professionId)) {
            profession = (Profession)((Object)this.professionService.selectById(professionId));
            Shift.throwsIfInvalid((profession == null || profession.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u4e13\u4e1a\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
            professionName = profession.getName();
        }
        return this.generateClassName(year, degree != null ? degree.getName() : null, department != null ? department.getName() : null, professionName, className);
    }

    public String generateClassName(String year, String degreeName, String departmentName, String professionName, String className) {
        String fullClassName = "";
        if (StringUtil.isNotBlank((String)year)) {
            fullClassName = year;
        }
        if (StringUtil.isNotBlank((String)degreeName)) {
            fullClassName = fullClassName + "-" + degreeName;
        }
        if (StringUtil.isNotBlank((String)departmentName)) {
            fullClassName = fullClassName + "-" + departmentName;
        }
        if (StringUtil.isNotBlank((String)professionName)) {
            fullClassName = fullClassName + "-" + professionName;
        }
        if (StringUtil.isNotBlank((String)className)) {
            fullClassName = fullClassName + StringUtil.removeAllBlank((String)className);
        }
        if (fullClassName.startsWith("-")) {
            fullClassName = fullClassName.replaceFirst("-", "");
        }
        return fullClassName;
    }

    public ClassAndGrade selectByContacts(Contacts contactsVo) {
        List classAndGrades = this.selectList(JpaCriteria.builder().eq("appId", (Object)this.getAppId()));
        if (classAndGrades.size() == 1) {
            return (ClassAndGrade)((Object)classAndGrades.get(0));
        }
        ClassAndGrade classAndGrade = null;
        String degreeName = contactsVo.getDegreeName();
        String departmentName = contactsVo.getDepartmentName();
        String year = contactsVo.getYear();
        String degreeId = "";
        if (StringUtil.isNotBlank((String)degreeName)) {
            List professions = this.professionService.selectList(JpaCriteria.builder().eq("type", (Object)ProfessionTypeEnum.DEGREE.value()).eq("name", (Object)degreeName));
            Shift.throwsIfInvalid((professions.size() != 1 ? 1 : 0) != 0, (String)"\u5b66\u4f4d\u914d\u7f6e\u6709\u8bef");
            degreeId = ((Profession)((Object)professions.get(0))).getId();
        }
        if (StringUtil.isNotBlank((String)departmentName) && StringUtil.isNotBlank((String)year)) {
            Shift.throwsIfBlank((String)year, (String)"\u5165\u5b66\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
            Shift.throwsIfBlank((String)degreeId, (String)"\u5b66\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            classAndGrade = this.classAndGradeMapper.selectByDegreeId(degreeId, departmentName, year);
        }
        if (classAndGrade != null) {
            return classAndGrade;
        }
        List classAndGradeList = super.selectList(JpaCriteria.builder().eq("appId", (Object)this.getAppId()).eq("isDeleted", (Object)false).orderBy("createTime asc"));
        if (classAndGradeList.size() > 0) {
            return (ClassAndGrade)((Object)classAndGradeList.get(0));
        }
        classAndGrade = this.initClass();
        Shift.throwsIfNull((Object)((Object)classAndGrade), (String)"\u65e0\u6cd5\u786e\u5b9a\u73ed\u7ea7");
        return classAndGrade;
    }

    public ClassAndGrade initClass() {
        Profession p1 = new Profession();
        BaseDomainUtil.initBaseDomain((BaseDomain)p1, (String)this.getAppId());
        p1.setName("/");
        p1.setType(1);
        p1.setSeqNum(0);
        this.professionService.insert((Object)p1);
        Profession p2 = new Profession();
        BaseDomainUtil.initBaseDomain((BaseDomain)p2, (String)this.getAppId());
        p2.setName("\u9ed8\u8ba4\u6587\u5b57");
        p2.setType(2);
        p2.setSeqNum(0);
        p2.setParentId(p1.getId());
        this.professionService.insert((Object)p2);
        ClassAndGrade classAndGrade = new ClassAndGrade();
        BaseDomainUtil.initBaseDomain((BaseDomain)classAndGrade, (String)this.getAppId());
        classAndGrade.setYear(Calendar.getInstance().get(1) + "");
        classAndGrade.setDegreeId(p1.getId());
        classAndGrade.setDepartmentId(p2.getId());
        classAndGrade.setSeqNum(0);
        this.insertClassAndGrade(classAndGrade);
        List classAndGradeList = super.selectList(JpaCriteria.builder().eq("appId", (Object)this.getAppId()).eq("isDeleted", (Object)false).orderBy("createTime asc"));
        if (classAndGradeList.size() > 0) {
            return (ClassAndGrade)((Object)classAndGradeList.get(0));
        }
        return null;
    }
}

