/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.github.stuxuhai.jpinyin.PinyinException;
import com.github.stuxuhai.jpinyin.PinyinFormat;
import com.github.stuxuhai.jpinyin.PinyinHelper;
import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.domain.Config;
import com.wego168.bbs.service.BbsPointService;
import com.wego168.coweb.domain.ClassAndGrade;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.domain.MembershipRecord;
import com.wego168.coweb.persistence.ContactsMapper;
import com.wego168.coweb.service.ClassAndGradeService;
import com.wego168.coweb.service.MembershipRecordService;
import com.wego168.coweb.service.MyConfigService;
import com.wego168.coweb.service.MyMemberService;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.domain.MemberData;
import com.wego168.member.domain.MemberLevel;
import com.wego168.member.domain.MemberLevelJoin;
import com.wego168.member.enums.MemberLevelJoinStatusEnum;
import com.wego168.member.enums.MemberStatusEnum;
import com.wego168.member.model.PersonalityLabelImportModel;
import com.wego168.member.model.response.PersonalityLabelMemberPageResponse;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.MemberDataService;
import com.wego168.member.service.impl.MemberLevelJoinService;
import com.wego168.member.service.impl.MemberLevelService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.member.service.impl.PersonalityLabelService;
import com.wego168.member.service.impl.PersonalityLabelTemplateService;
import com.wego168.member.util.SessionUtil;
import com.wego168.persistence.CrudMapper;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.service.BaseService;
import com.wego168.util.IntegerUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContactsService
extends BaseService<Contacts> {
    private static final Logger log = LoggerFactory.getLogger(ContactsService.class);
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private MyMemberService myMemberService;
    @Autowired
    private ClassAndGradeService classAndGradeService;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private MyConfigService myConfigService;
    @Autowired
    private MemberDataService memberDataService;
    @Autowired
    private MembershipRecordService membershipRecordService;
    @Autowired
    private ContactsMapper contactsMapper;
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;
    @Autowired
    private MemberService memberService;
    @Autowired
    private PersonalityLabelService personalityLabelService;
    @Autowired
    private PersonalityLabelTemplateService personalityLabelTemplateService;
    @Autowired
    private MemberLevelJoinService memberLevelJoinService;
    @Autowired
    private MemberLevelService memberLevelService;
    @Autowired
    private BbsPointService bbsPointService;

    public CrudMapper<Contacts> getMapper() {
        return this.contactsMapper;
    }

    public Contacts selectContactsById(String id) {
        Contacts contacts = this.contactsMapper.selectContactsById(id, this.getAppId(), false);
        Shift.throwsIfNull((Object)((Object)contacts), (String)"\u8be5\u7528\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        return contacts;
    }

    public Contacts selectByPhone(String phone) {
        return (Contacts)((Object)this.select(JpaCriteria.builder().eq("appId", (Object)this.getAppId()).eq("phone", (Object)phone)));
    }

    public List<Contacts> selectContacts(Page page) {
        page.put((Object)"appId", (Object)this.getAppId());
        page.put((Object)"isDeleted", (Object)false);
        return this.contactsMapper.selectContacts(page);
    }

    @Transactional
    public Integer importData(List<Contacts> importList, Integer keyType) {
        Integer count = 0;
        HashMap<String, Integer> classMemberAmountMap = new HashMap<String, Integer>();
        List<Contacts> oldContacts = this.selectList();
        if (oldContacts != null && oldContacts.size() > 0) {
            LinkedList<Contacts> insertList = new LinkedList<Contacts>();
            HashMap<String, Contacts> contactsMap = new HashMap<String, Contacts>();
            for (Contacts contacts : oldContacts) {
                String key = "";
                key = contacts.getPhone();
                contactsMap.put(key, contacts);
            }
            Set classIdSet = null;
            for (Contacts importContacts : importList) {
                String[] tagNames;
                String tagName;
                String classId;
                String key = "";
                key = importContacts.getPhone();
                classIdSet = classMemberAmountMap.keySet();
                if (!classIdSet.contains(classId = importContacts.getClassId())) {
                    classMemberAmountMap.put(classId, 0);
                }
                if (!contactsMap.containsKey(key)) {
                    importContacts = this.initContacts(importContacts);
                    insertList.add(importContacts);
                    classMemberAmountMap.put(classId, (Integer)classMemberAmountMap.get(classId) + 1);
                } else {
                    Contacts contacts = (Contacts)((Object)contactsMap.get(key));
                    if (!contacts.getIsBind().booleanValue()) {
                        importContacts.setId(contacts.getId());
                        importContacts.setUpdateTime(new Date());
                        importContacts.setIsDeleted(false);
                        if (!StringUtils.equals((CharSequence)contacts.getName(), (CharSequence)importContacts.getName())) {
                            importContacts.setNameInitial(this.getNameInitial(importContacts.getName()));
                        }
                        if (!StringUtils.equals((CharSequence)contacts.getClassName(), (CharSequence)importContacts.getClassName())) {
                            classMemberAmountMap.put(classId, (Integer)classMemberAmountMap.get(classId) + 1);
                            String oldClassId = contacts.getClassId();
                            if (!classIdSet.contains(oldClassId)) {
                                classMemberAmountMap.put(oldClassId, -1);
                            } else {
                                classMemberAmountMap.put(oldClassId, (Integer)classMemberAmountMap.get(oldClassId) - 1);
                            }
                        }
                        super.updateSelective((Object)importContacts);
                    }
                    if (StringUtil.isNotBlank((String)contacts.getMemberId()) && StringUtil.isNotBlank((String)importContacts.getMemberLevelName()) && null != importContacts.getEndMemberLevelJoinTime()) {
                        this.memberLevelJoinService.update(contacts.getMemberId(), importContacts.getMemberLevelName(), importContacts.getEndMemberLevelJoinTime());
                    }
                }
                if (!StringUtil.isNotBlank((String)(tagName = importContacts.getTagName()))) continue;
                for (String str : tagNames = tagName.split("/")) {
                    boolean flag;
                    boolean bl = flag = this.personalityLabelTemplateService.existSameName(str, this.getAppId()) == null;
                    if (!flag) continue;
                    this.personalityLabelTemplateService.insert(str, 0, this.getAppId());
                }
            }
            count = super.insertBatch(insertList);
        } else {
            Set classIdSet = classMemberAmountMap.keySet();
            for (Contacts importContacts : importList) {
                this.initContacts(importContacts);
                String string = importContacts.getClassId();
                if (!classIdSet.contains(string)) {
                    classMemberAmountMap.put(string, 1);
                    continue;
                }
                classMemberAmountMap.put(string, (Integer)classMemberAmountMap.get(string) + 1);
            }
            count = super.insertBatch(importList);
        }
        this.classAndGradeService.updateClassMemberAmountByMap(classMemberAmountMap);
        return count;
    }

    public boolean isEnglishOrChinese(String str) {
        str = StringUtil.removeAllBlank((String)str);
        String regex = "^[a-zA-Z0-9\u4e00-\u9fa5]+$";
        return str.matches(regex);
    }

    public String getNameInitial(String name) {
        if (StringUtil.isNotBlank((String)name)) {
            name = StringUtil.removeAllBlank((String)name);
            String nameInitial = null;
            if (!this.isEnglishOrChinese(name)) {
                nameInitial = "#";
                return "#";
            }
            try {
                nameInitial = PinyinHelper.convertToPinyinString((String)name, (String)"", (PinyinFormat)PinyinFormat.WITHOUT_TONE).toUpperCase();
            }
            catch (PinyinException e) {
                nameInitial = "#";
            }
            return nameInitial;
        }
        return null;
    }

    @Transactional
    public MemberAccount bindAccountToNewContacts(Contacts contacts, MemberAccount memberAccount, ClassAndGrade classAndGrade) {
        Member member = this.myMemberService.selectById(memberAccount.getMemberId());
        member.setName(contacts.getName());
        member.setStatus(Integer.valueOf(MemberStatusEnum.PASS.value()));
        this.myMemberService.updateSelective(member);
        this.myMemberService.setCacheMember(member);
        contacts.setMemberId(memberAccount.getMemberId());
        contacts.setIsBind(true);
        contacts.setStatus(MemberStatusEnum.PASS.value());
        this.contactsService.updateSelective((Object)contacts);
        classAndGrade.setJoinMemberAmount(classAndGrade.getJoinMemberAmount() + 1);
        classAndGrade.setPercent(this.classAndGradeService.getPercent(classAndGrade));
        classAndGrade.setUpdateTime(new Date());
        this.classAndGradeService.updateSelective((Object)classAndGrade);
        return memberAccount;
    }

    @Transactional
    public MemberAccount bindAccountToNewContactsByRegister(Contacts contacts, MemberAccount memberAccount, ClassAndGrade classAndGrade) {
        this.memberAccountService.updateSelective((Object)memberAccount);
        this.updateMemberByContacts(contacts, memberAccount.getMemberId());
        contacts.setMemberId(memberAccount.getMemberId());
        this.contactsService.updateSelective((Object)contacts);
        classAndGrade.setJoinMemberAmount(classAndGrade.getJoinMemberAmount() + 1);
        classAndGrade.setPercent(this.classAndGradeService.getPercent(classAndGrade));
        classAndGrade.setUpdateTime(new Date());
        this.classAndGradeService.updateSelective((Object)classAndGrade);
        return memberAccount;
    }

    public void updateMemberByContacts(Contacts contacts, String memberId) {
        MemberData memberData;
        Member member = this.myMemberService.selectById(memberId);
        if (StringUtil.isNotBlank((String)contacts.getName())) {
            member.setName(contacts.getName());
        }
        if (StringUtil.isNotBlank((String)contacts.getPhone())) {
            member.setMobilePhoneNumber(contacts.getPhone());
        }
        if ((memberData = (MemberData)this.memberDataService.selectById((Object)contacts.getMemberId())) != null) {
            if (StringUtil.isNotBlank((String)contacts.getCompany())) {
                memberData.setCompany(contacts.getCompany());
            }
            if (StringUtil.isNotBlank((String)contacts.getPosition())) {
                memberData.setPosition(contacts.getPosition());
            }
            this.memberDataService.updateSelective((Object)memberData);
        }
        if (member.getStatus() == null) {
            member.setStatus(this.memberService.getMemberStatus());
        }
        this.myMemberService.updateSelective(member);
        this.myMemberService.setCacheMember(member);
    }

    @Transactional
    public MemberAccount bindAccountToOldContacts(Contacts contacts, MemberAccount memberAccount) {
        Member member = this.memberService.selectById(memberAccount.getMemberId());
        member.setStatus(Integer.valueOf(MemberStatusEnum.PASS.value()));
        this.myMemberService.setCacheMember(member);
        contacts.setMemberId(memberAccount.getMemberId());
        contacts.setIsBind(true);
        contacts.setStatus(MemberStatusEnum.PASS.value());
        this.contactsService.updateSelective((Object)contacts);
        MemberData memberData = (MemberData)this.memberDataService.selectById((Object)contacts.getMemberId());
        if (memberData != null) {
            if (StringUtil.isNotBlank((String)contacts.getCompany())) {
                memberData.setCompany(contacts.getCompany());
            }
            if (StringUtil.isNotBlank((String)contacts.getPosition())) {
                memberData.setPosition(contacts.getPosition());
            }
            this.memberDataService.updateSelective((Object)memberData);
        }
        return memberAccount;
    }

    @Transactional
    public void updateContactsByAdmin(Contacts contacts) {
        String classId = contacts.getClassId();
        ClassAndGrade temp = (ClassAndGrade)((Object)this.classAndGradeService.selectById(classId));
        Shift.throwsIfInvalid((temp == null || temp.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u73ed\u7ea7\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        this.classAndGradeService.updateClassMemberAmount(contacts.getClassId(), contacts.getClassId(), (Integer)1, contacts.getIsBind());
        Date date = new Date();
        contacts.setPhone(contacts.getPhone().trim());
        contacts.setUpdateTime(date);
        contacts.setNameInitial(this.getNameInitial(contacts.getName()));
        List<PersonalityLabelMemberPageResponse> pList = contacts.getLabels();
        if (StringUtil.isNotBlank((String)contacts.getMemberId())) {
            Member member = this.myMemberService.selectById(contacts.getMemberId());
            member.setName(contacts.getName());
            member.setMobilePhoneNumber(contacts.getPhone());
            member.setUpdateTime(date);
            this.myMemberService.updateSelective(member);
            if (pList != null) {
                Shift.throwsIfInvalid((pList.size() > 3 ? 1 : 0) != 0, (String)"\u6700\u591a\u6807\u7b7e\u6570\u4e0d\u53ef\u8d85\u8fc73\u4e2a");
                List ids = pList.stream().map(PersonalityLabelMemberPageResponse::getId).collect(Collectors.toList());
                this.personalityLabelService.updateDeleteNotIds(contacts.getMemberId(), ids);
                for (PersonalityLabelMemberPageResponse p : pList) {
                    if (StringUtil.isBlank((String)p.getId())) {
                        this.personalityLabelService.insert(p.getName(), p.getSortNumber().intValue(), contacts.getMemberId());
                        continue;
                    }
                    this.personalityLabelService.update(p.getName(), p.getSortNumber().intValue(), p.getId());
                }
            }
            this.setMemberLevelJoin(contacts.getMemberLevelId(), contacts.getMemberId(), contacts.getEndMemberLevelJoinTime());
        } else if (pList != null) {
            Shift.throwsIfInvalid((pList.size() > 3 ? 1 : 0) != 0, (String)"\u6700\u591a\u6807\u7b7e\u6570\u4e0d\u53ef\u8d85\u8fc73\u4e2a");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < pList.size(); ++i) {
                sb.append(pList.get(i).getName());
                if (i + 1 >= pList.size()) continue;
                sb.append("/");
            }
            contacts.setTagName(sb.toString());
        }
        this.contactsService.updateSelective((Object)contacts);
    }

    public void updatePersonalityLabel(String id) {
        Contacts vo = (Contacts)((Object)this.selectById(id));
        if (vo != null && StringUtil.isNotBlank((String)vo.getTagName())) {
            this.personalityLabelService.importExcel(vo.getMemberId(), vo.getTagName().split("/"));
        }
    }

    @Transactional
    public void updateContactsByMember(Member member, Contacts contacts, String year, String degreeName, String departmentName, String studentId, String wechat, String company, String position, String trade, String city, String mailbox, String provide, String demand, Boolean isPublic, Integer sex, String nativePlace, String companyPhone, String qqNumber, String birthday, String hobby, String headImage) {
        Config config;
        Date date = new Date();
        contacts.setWechat(wechat);
        contacts.setCompany(company);
        contacts.setPosition(position);
        contacts.setTrade(trade);
        contacts.setCity(city);
        contacts.setMailbox(mailbox);
        contacts.setProvide(provide);
        contacts.setDemand(demand);
        contacts.setIsPublic(isPublic);
        contacts.setSex(sex);
        contacts.setNativePlace(nativePlace);
        contacts.setCompanyPhone(companyPhone);
        contacts.setQqNumber(qqNumber);
        contacts.setBirthday(birthday);
        contacts.setUpdateTime(date);
        contacts.setHobby(hobby);
        contacts.setYear(year);
        contacts.setDegreeName(degreeName);
        contacts.setDepartmentName(departmentName);
        contacts.setStudentId(studentId);
        if (contacts.getSerialNumber() == null && (config = this.myConfigService.getByKey("contacts_serial_number")) != null && StringUtil.equals((String)config.getValue(), (String)"open")) {
            Long serialNumber = this.simpleRedisTemplate.incr("contacts_serial_number");
            contacts.setSerialNumber(serialNumber.intValue());
        }
        member.setHeadImage(headImage);
        member.setUpdateTime(date);
        this.contactsService.updateSelective((Object)contacts);
        this.myMemberService.updateSelective(member);
        this.bbsPointService.giveFinishProfilePointAsync(member.getId(), member.getAppId());
    }

    public Contacts initContacts(Contacts contacts) {
        if (StringUtil.isNotBlank((String)contacts.getPhone())) {
            contacts.setPhone(StringUtil.removeAllBlank((String)contacts.getPhone()).replaceAll("-", ""));
        }
        contacts.setIsBind(false);
        contacts.setIsPublic(true);
        contacts.setIsMembership(false);
        contacts.setIsFrozen(false);
        contacts.setNameInitial(this.getNameInitial(contacts.getName()));
        return contacts;
    }

    public Contacts initRegisterContacts(Contacts contacts) {
        if (StringUtil.isNotBlank((String)contacts.getPhone())) {
            contacts.setPhone(StringUtil.removeAllBlank((String)contacts.getPhone()).replaceAll("-", ""));
        }
        contacts.setIsBind(true);
        contacts.setIsPublic(true);
        contacts.setIsMembership(false);
        contacts.setIsFrozen(false);
        contacts.setNameInitial(this.getNameInitial(contacts.getName()));
        return contacts;
    }

    public Contacts create(Contacts contacts) {
        Date date = new Date();
        this.initContacts(contacts);
        contacts.setAppId(this.getAppId());
        contacts.setCreateTime(date);
        contacts.setIsDeleted(false);
        return contacts;
    }

    public List<Contacts> selectList() {
        return this.contactsMapper.selectAll(this.getAppId());
    }

    public Contacts selectByStudentId(String studentId) {
        return this.contactsMapper.selectByStudentId(studentId, this.getAppId(), false);
    }

    public Contacts selectByStudentIdCheckNull(String studentId) {
        Contacts contacts = this.selectByStudentId(studentId);
        Shift.throwsIfNull((Object)((Object)contacts), (String)"\u8be5\u6821\u53cb\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        return contacts;
    }

    public Contacts selectByClassAndName(String classId, String name) {
        return this.contactsMapper.selectByClassAndName(classId, name, this.getAppId(), false);
    }

    public Contacts selectByClassAndNameCheckNull(String classId, String name) {
        Contacts contacts = this.selectByClassAndName(classId, name);
        Shift.throwsIfNull((Object)((Object)contacts), (String)"\u8be5\u6821\u53cb\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        return contacts;
    }

    public Contacts selectByMemberId(String memberId) {
        return this.contactsMapper.selectByMemberId(memberId, this.getAppId(), false);
    }

    public Contacts selectByMemberId(String memberId, String appId) {
        return this.contactsMapper.selectByMemberId(memberId, appId, false);
    }

    public Contacts selectByMemberIdIgnoreIsDeleted(String memberId) {
        return this.contactsMapper.selectByMemberIdIgnoreIsDeleted(memberId, this.getAppId());
    }

    public List<Contacts> selectPageByAdmin(Page page) {
        if (StringUtil.isNotBlank((String)page.getString("phone"))) {
            page.put((Object)"phone", (Object)("%" + page.getString("phone") + "%"));
        }
        page.put((Object)"appId", (Object)this.getAppId());
        page.put((Object)"isDeleted", (Object)false);
        String orderBy = page.getString("orderBy");
        String orderBySql = this.determineOrderBySql(orderBy, "c.", "m.");
        page.put((Object)"orderBy", (Object)orderBySql);
        return this.contactsMapper.selectPageByAdmin(page);
    }

    public Integer statistics(Boolean isBind) {
        Integer count = this.contactsMapper.statistics(isBind, this.getAppId(), false);
        return count;
    }

    public List<String> selectMembershipMemberIds() {
        return this.contactsMapper.selectMembershipMemberIds(this.getAppId(), false);
    }

    @Transactional
    public void frozen(Contacts contacts, Boolean isFrozen) {
        if (isFrozen.booleanValue()) {
            if (!contacts.getIsFrozen().booleanValue()) {
                contacts.setIsFrozen(true);
                super.updateSelective((Object)contacts);
            }
        } else if (contacts.getIsFrozen().booleanValue()) {
            contacts.setIsFrozen(false);
            super.updateSelective((Object)contacts);
        }
    }

    @Transactional
    public void insertContacts(Contacts contacts) {
        ClassAndGrade classAndGrade = (ClassAndGrade)((Object)this.classAndGradeService.selectById(contacts.getClassId()));
        Shift.throwsIfNull((Object)((Object)classAndGrade), (String)"\u8be5\u73ed\u7ea7\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        Config tradeConfig = this.myConfigService.getByKey("trade");
        if (tradeConfig != null && StringUtil.isNotBlank((String)tradeConfig.getValue())) {
            Set<String> tradeSet = this.myConfigService.getTradeSet();
            if (StringUtils.isNotBlank((CharSequence)contacts.getTrade())) {
                Shift.throwsIfInvalid((!tradeSet.contains(contacts.getTrade()) ? 1 : 0) != 0, (String)"\u884c\u4e1a\u4e0e\u540e\u53f0\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u786e\u8ba4");
            }
        }
        Contacts vo = null;
        vo = (Contacts)((Object)this.select(JpaCriteria.builder().eq("phone", (Object)contacts.getPhone()).eq("appId", (Object)this.getAppId()).eq("isDeleted", (Object)"0")));
        Shift.throwsIfInvalid((vo != null ? 1 : 0) != 0, (String)"\u8be5\u6821\u53cb\u5df2\u5b58\u5728");
        contacts = this.create(contacts);
        List<PersonalityLabelMemberPageResponse> pList = contacts.getLabels();
        if (pList != null) {
            Shift.throwsIfInvalid((pList.size() > 3 ? 1 : 0) != 0, (String)"\u6700\u591a\u6807\u7b7e\u6570\u4e0d\u53ef\u8d85\u8fc73\u4e2a");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < pList.size(); ++i) {
                sb.append(pList.get(i).getName());
                if (i + 1 >= pList.size()) continue;
                sb.append("/");
            }
            contacts.setTagName(sb.toString());
        }
        super.insert((Object)contacts);
        this.classAndGradeService.updateClassMemberAmount(classAndGrade, null, (Integer)1, (Boolean)false);
        if (StringUtil.isNotBlank((String)contacts.getMemberId())) {
            String memberId = contacts.getMemberId();
            this.setMemberLevelJoin(contacts.getMemberLevelId(), memberId, contacts.getEndMemberLevelJoinTime());
        }
    }

    @Transactional
    public Map<String, Object> registerContacts(Contacts contacts, MemberAccount memberAccount) {
        Contacts phoneContacts = (Contacts)((Object)this.contactsService.select(JpaCriteria.builder().eq("memberId", (Object)SessionUtil.getMemberIdIfAbsentToThrow()).eq("appId", (Object)this.getAppId()).eq("isDeleted", (Object)0)));
        Boolean isNewMember = false;
        ClassAndGrade classAndGrade = this.classAndGradeService.selectByContacts(contacts);
        Shift.throwsIfInvalid((classAndGrade == null || classAndGrade.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u60a8\u6240\u5728\u7684\u73ed\u7ea7\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        if (phoneContacts == null) {
            log.error("\u6ce8\u518c\u65b0\u5efa\u4f1a\u5458\u8d26\u53f7\uff0cmemberId->{}", (Object)memberAccount.getMemberId());
            this.initRegisterContacts(contacts);
            Shift.throwsIfBlank((String)contacts.getPhone(), (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            contacts.setMemberId(memberAccount.getMemberId());
            contacts.setClassId(classAndGrade.getId());
            contacts.setStatus(this.memberService.getMemberStatus());
            contacts.setIsBind(true);
            super.insert((Object)contacts);
            this.bindAccountToNewContactsByRegister(contacts, memberAccount, classAndGrade);
            this.updateMemberByContacts(contacts, memberAccount.getMemberId());
            isNewMember = true;
        } else {
            String id = phoneContacts.getId();
            contacts.setId(id);
            log.error("\u66f4\u65b0\u539f\u6709\u4f1a\u5458\u5e93->{}\uff0cmemberId->{}", (Object)id, (Object)memberAccount.getMemberId());
            contacts.setUpdateTime(new Date());
            if (phoneContacts.getStatus() == null) {
                contacts.setStatus(this.memberService.getMemberStatus());
            }
            contacts.setIsBind(true);
            super.updateSelective((Object)contacts);
            this.updateMemberByContacts((Contacts)((Object)this.selectById(id)), memberAccount.getMemberId());
        }
        this.contactsService.updatePersonalityLabel(contacts.getId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isMemberAccount", isNewMember);
        map.put("className", classAndGrade.getClassName());
        map.put("contacts", (Object)contacts);
        return map;
    }

    @Transactional
    public void deleteContacts(Contacts vo) {
        this.contactsService.updateDelete(vo.getId());
        this.classAndGradeService.updateClassMemberAmount(vo.getClassId(), null, (Integer)-1, vo.getIsBind());
        if (StringUtil.isNotBlank((String)vo.getMemberId())) {
            MemberAccount memberAccount = this.memberAccountService.selectByMemberId(vo.getMemberId());
            memberAccount.setBindStatus(Integer.valueOf(0));
            this.memberAccountService.updateSelective((Object)memberAccount);
        }
    }

    public List<Bootmap> addClassToList(List<Bootmap> list) {
        if (list != null && list.size() > 0) {
            HashSet<String> memberIdSet = new HashSet<String>();
            for (Bootmap bootmap : list) {
                String memberId = bootmap.getString("memberId");
                if (memberIdSet.contains(memberId)) continue;
                memberIdSet.add(memberId);
            }
            List<Contacts> contactsLits = this.selectListWithMemberIdList(new ArrayList<String>(memberIdSet));
            HashMap<String, String> classNameMap = new HashMap<String, String>();
            for (Contacts contacts : contactsLits) {
                classNameMap.put(contacts.getMemberId(), contacts.getClassName());
            }
            for (Bootmap bootmap : list) {
                String memberId = bootmap.getString("memberId");
                bootmap.put((Object)"className", classNameMap.get(memberId));
            }
        }
        return list;
    }

    public List<Contacts> selectListWithMemberIdList(List<String> memberIdList) {
        return this.contactsMapper.selectListWithMemberIdList(memberIdList, this.getAppId(), false);
    }

    public void updateAllMembershipStatus(Boolean isMembership) {
        this.contactsMapper.updateAllMembershipStatus(isMembership, this.getAppId());
    }

    public void updateMembershipStatusInIdList(List<String> contactsIdList, Boolean isMembership) {
        this.contactsMapper.updateMembershipStatusInIdList(contactsIdList, isMembership, this.getAppId());
    }

    public void updateMembershipStatusNotInIdList(List<String> contactsIdList, Boolean isMembership) {
        this.contactsMapper.updateMembershipStatusNotInIdList(contactsIdList, isMembership, this.getAppId());
    }

    @Transactional
    public void updateMembershipStatus() {
        String thisYear = new SimpleDateFormat("yyyy").format(new Date());
        List recordList = this.membershipRecordService.selectList(JpaCriteria.builder().eq("openYear", (Object)thisYear));
        if (recordList.size() == 0) {
            this.updateAllMembershipStatus(false);
        } else {
            ArrayList<String> contactsIdList = new ArrayList<String>(recordList.size());
            for (MembershipRecord membershipRecord : recordList) {
                contactsIdList.add(membershipRecord.getContactsId());
            }
            this.updateMembershipStatusInIdList(contactsIdList, true);
            this.updateMembershipStatusNotInIdList(contactsIdList, false);
        }
    }

    public Contacts selectByPhoneYearName(String phone, String year, String name) {
        return this.contactsMapper.selectByPhoneYearName(phone, year, name, this.getAppId());
    }

    public Contacts selectByContacts(Contacts contactsVo) {
        contactsVo.setAppId(this.getAppId());
        return this.contactsMapper.selectByContacts(contactsVo);
    }

    public Contacts selectField(Contacts contactsVo) {
        contactsVo.setAppId(this.getAppId());
        return this.contactsMapper.selectField(contactsVo);
    }

    @Transactional
    public void auditContacts(Contacts contacts) {
        Member member = this.memberService.selectById(contacts.getMemberId());
        if (IntegerUtil.equals((Integer)MemberStatusEnum.PASS.value(), (Integer)contacts.getStatus())) {
            member.setStatus(Integer.valueOf(MemberStatusEnum.PASS.value()));
            contacts.setStatus(MemberStatusEnum.PASS.value());
            contacts.setIsBind(true);
        } else {
            member.setStatus(Integer.valueOf(MemberStatusEnum.NOT_PASS.value()));
            contacts.setStatus(MemberStatusEnum.NOT_PASS.value());
            contacts.setIsBind(true);
        }
        super.updateSelective((Object)contacts);
        this.myMemberService.updateSelective(member);
        this.myMemberService.setCacheMember(member);
    }

    @Transactional
    public void importPersonalityLabel(List<PersonalityLabelImportModel> list) {
        for (PersonalityLabelImportModel p : list) {
            Member member = this.memberService.selectByMobile(p.getPhone());
            if (member != null) {
                this.personalityLabelService.importExcel(member.getId(), p.getTagName().split("/"));
                continue;
            }
            Contacts contacts = this.contactsService.selectByPhone(p.getPhone());
            if (contacts != null) {
                contacts.setTagName(p.getTagName());
                this.contactsService.updateSelective((Object)contacts);
                continue;
            }
            contacts = new Contacts();
            contacts.setPhone(p.getPhone());
            contacts.setName(p.getName());
            contacts.setIsBind(false);
            contacts.setIsPublic(true);
            contacts.setIsMembership(false);
            contacts.setIsFrozen(false);
            contacts.setClassId(this.classAndGradeService.selectByContacts(contacts).getId());
            contacts.setNameInitial(this.contactsService.getNameInitial(contacts.getName()));
            this.contactsService.create(contacts);
        }
    }

    public void createMemberLevelJoin(Contacts contacts) {
        if (contacts.getEndMemberLevelJoinTime() != null && StringUtil.isNotBlank((String)contacts.getMemberLevelName())) {
            String memberId = contacts.getMemberId();
            MemberLevel memberLevel = (MemberLevel)this.memberLevelService.select(JpaCriteria.builder().eq("name", (Object)contacts.getMemberLevelName()).eq("appId", (Object)contacts.getAppId()).eq("isDeleted", (Object)false));
            if (memberLevel == null) {
                return;
            }
            MemberLevelJoin memberLevelJoin = this.memberLevelJoinService.findByMemberStatusNew(memberId);
            if (memberLevelJoin == null) {
                memberLevelJoin = this.memberLevelJoinService.create(memberId, memberLevel.getId(), contacts.getEndMemberLevelJoinTime(), MemberLevelJoinStatusEnum.NEW.value());
                this.memberLevelJoinService.insert((Object)memberLevelJoin);
            }
        }
    }

    private void setMemberLevelJoin(String memberLevelId, String memberId, Date endTime) {
        if (StringUtil.isNotBlank((String)memberLevelId) && endTime != null) {
            MemberLevelJoin memberLevelJoin = this.memberLevelJoinService.findByMemberStatusNew(memberId);
            if (memberLevelJoin == null) {
                memberLevelJoin = this.memberLevelJoinService.create(memberId, memberLevelId, endTime, MemberLevelJoinStatusEnum.NEW.value());
                this.memberLevelJoinService.insert((Object)memberLevelJoin);
            } else {
                memberLevelJoin.setEndTime(endTime);
                memberLevelJoin.setMemberLevelId(memberLevelId);
                this.memberLevelJoinService.updateSelective((Object)memberLevelJoin);
            }
        }
    }

    public void setMemberLevelInfo(Contacts c) {
        if (StringUtil.isBlank((String)c.getMemberId())) {
            return;
        }
        MemberLevelJoin memberLevelJoin = this.memberLevelJoinService.selectByMemberId(c.getMemberId());
        if (memberLevelJoin == null) {
            c.setMemberLevelName(null);
            c.setEndMemberLevelJoinTime(null);
            return;
        }
        MemberLevel memberLevel = (MemberLevel)this.memberLevelService.selectById((Object)memberLevelJoin.getMemberLevelId());
        if (memberLevel != null) {
            c.setMemberLevelName(memberLevel.getName());
            c.setEndMemberLevelJoinTime(memberLevelJoin.getEndTime());
        }
    }

    @Transactional
    public Integer deleteMemberLevel(String oldId, Boolean transferMember, String newId, String appId) {
        int row = 0;
        MemberLevel old = (MemberLevel)this.memberLevelService.selectById((Object)oldId);
        MemberLevel now = (MemberLevel)this.memberLevelService.selectById((Object)newId);
        if (old == null) {
            return row;
        }
        if (transferMember.booleanValue()) {
            this.contactsMapper.updateSelective(JpaCriteria.builder().set("memberLevelName", (Object)now.getName()).eq("memberLevelName", (Object)old.getName()));
        } else {
            String memberLevelName = old.getName();
            this.contactsMapper.clearMemberLevelName(appId, memberLevelName);
        }
        row = this.memberLevelService.delete(oldId, transferMember, newId);
        return row;
    }

    private String determineOrderBySql(String orderBy, String contactAlias, String memberAlias) {
        if (StringUtil.equals((String)orderBy, (String)"newContactFirst")) {
            return contactAlias + "create_time DESC";
        }
        if (StringUtil.equals((String)orderBy, (String)"updatedContactFirst")) {
            return contactAlias + "update_time DESC";
        }
        return contactAlias + "is_bind DESC, " + contactAlias + "create_time DESC";
    }
}

