/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.base.domain.Config;
import com.wego168.base.enums.ConfigEnum;
import com.wego168.base.service.ConfigService;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.domain.ContactsSetting;
import com.wego168.coweb.enums.CowebCheckEnum;
import com.wego168.coweb.model.response.ProfileContactsSettingMobileResponse;
import com.wego168.coweb.persistence.ContactsSettingMapper;
import com.wego168.coweb.service.MyConfigService;
import com.wego168.member.domain.Member;
import com.wego168.member.service.impl.MemberService;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.Checker;
import com.wego168.util.IntegerUtil;
import com.wego168.util.SequenceUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.wx.domain.WxApp;
import com.wego168.wx.enums.WxAppServiceTypeEnum;
import com.wego168.wx.service.WxAppService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContactsSettingService
extends BaseService<ContactsSetting> {
    private static final Logger log = LoggerFactory.getLogger(ContactsSettingService.class);
    @Autowired
    private ContactsSettingMapper contactsSettingMapper;
    @Autowired
    private ConfigService configService;
    @Autowired
    private MyConfigService myConfigService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private WxAppService wxAppService;

    public CrudMapper<ContactsSetting> getMapper() {
        return this.contactsSettingMapper;
    }

    @Transactional
    public void init(String appId) {
        ArrayList<Config> configs = new ArrayList<Config>();
        Config POSTER_TIPS1 = this.configService.create(appId, 10, "POSTER_TIPS1", "\u6d77\u62a5\u63d0\u793a\u8bed1", "\u76ee\u524d\u7cfb\u7edf\u6574\u7406\u6821\u53cb\u4eba\u5458\u8fbe %s \u4eba", null, 1, "\u76ee\u524d\u7cfb\u7edf\u6574\u7406\u6821\u53cb\u4eba\u5458\u8fbe %s \u4eba", (short)1, true);
        Config POSTER_TIPS2 = this.configService.create(appId, 10, "POSTER_TIPS2", "\u6d77\u62a5\u63d0\u793a\u8bed2", "\u5df2\u6709 %s \u4eba\u5728\u672c\u7cfb\u7edf\u767b\u5f55", null, 1, "\u5df2\u6709 %s \u4eba\u5728\u672c\u7cfb\u7edf\u767b\u5f55", (short)1, true);
        Config GUIDE = this.configService.create(appId, 10, "GUIDE", "\u6ce8\u518c\u5f15\u5bfc\u8bed", "\u60a8\u8fd8\u4e0d\u662f\u4f1a\u5458\uff0c\u8bf7\u5148\u6ce8\u518c\u4f1a\u5458", null, 1, "\u6ce8\u518c\u5f15\u5bfc\u8bed", (short)1, true);
        Config c = this.configService.create(appId, 0, ConfigEnum.open_register.name(), "\u662f\u5426\u5f00\u653e\u6ce8\u518c", "1", null, 1, null, (short)10, true);
        Config c1 = this.configService.create(appId, 0, ConfigEnum.is_need_audit.name(), "\u662f\u5426\u9700\u8981\u8ba4\u8bc1", "0", null, 1, null, (short)10, true);
        configs.add(POSTER_TIPS1);
        configs.add(POSTER_TIPS2);
        configs.add(GUIDE);
        configs.add(c);
        configs.add(c1);
        for (Config config : configs) {
            if (this.configService.selectByKey(config.getKey()) != null) continue;
            this.configService.insert((Object)config);
        }
        ArrayList<ContactsSetting> contactsSettings = new ArrayList<ContactsSetting>();
        ContactsSetting name = ContactsSettingService.builder("\u59d3\u540d", "name", "\u59d3\u540d", true, true, true, true, 20, appId);
        ContactsSetting phone = ContactsSettingService.builder("\u624b\u673a", "phone", "\u624b\u673a", true, true, true, true, 19, appId);
        ContactsSetting year = ContactsSettingService.builder("\u5165\u5b66\u5e74\u4efd", "year", "\u5165\u5b66\u65f6\u95f4", true, true, true, false, 18, appId);
        ContactsSetting departmentName = ContactsSettingService.builder("\u7cfb\u522b", "departmentName", "\u7cfb\u522b", true, true, false, true, 17, appId);
        ContactsSetting studentId = ContactsSettingService.builder("\u5b66\u53f7", "studentId", "\u5b66\u53f7", true, true, true, false, 16, appId);
        ContactsSetting degreeName = ContactsSettingService.builder("\u5b66\u4f4d", "degreeName", "\u5b66\u4f4d", true, true, true, false, 15, appId);
        ContactsSetting wechat = ContactsSettingService.builder("\u5fae\u4fe1", "wechat", "\u5fae\u4fe1", true, false, false, false, 14, appId);
        ContactsSetting company = ContactsSettingService.builder("\u516c\u53f8", "company", "\u516c\u53f8", true, false, false, false, 13, appId);
        ContactsSetting position = ContactsSettingService.builder("\u804c\u4f4d", "position", "\u804c\u4f4d", true, false, false, false, 12, appId);
        ContactsSetting trade = ContactsSettingService.builder("\u884c\u4e1a", "trade", "\u884c\u4e1a", true, false, false, false, 11, appId);
        ContactsSetting city = ContactsSettingService.builder("\u57ce\u5e02", "city", "\u57ce\u5e02", false, false, false, false, 10, appId);
        ContactsSetting mailBox = ContactsSettingService.builder("\u90ae\u7bb1", "mailbox", "\u90ae\u7bb1", false, false, false, false, 9, appId);
        ContactsSetting nativePlace = ContactsSettingService.builder("\u7c4d\u8d2f", "nativePlace", "\u7c4d\u8d2f", false, false, false, false, 8, appId);
        ContactsSetting companyPhone = ContactsSettingService.builder("\u5355\u4f4d\u7535\u8bdd", "companyPhone", "\u7c4d\u8d2f", false, false, false, false, 7, appId);
        ContactsSetting qqNumber = ContactsSettingService.builder("QQ", "qqNumber", "\u7c4d\u8d2f", false, false, false, false, 6, appId);
        ContactsSetting birthday = ContactsSettingService.builder("\u751f\u65e5", "birthday", "\u751f\u65e5", false, false, false, false, 5, appId);
        ContactsSetting hobby = ContactsSettingService.builder("\u5174\u8da3\u7231\u597d", "hobby", "\u5174\u8da3\u7231\u597d", false, false, false, false, 4, appId);
        ContactsSetting demand = ContactsSettingService.builder("\u9700\u6c42\u4e0e\u671f\u671b", "demand", "\u9700\u6c42\u4e0e\u671f\u671b", false, false, false, false, 3, appId);
        ContactsSetting provide = ContactsSettingService.builder("\u6280\u80fd\u4e0e\u8d44\u6e90", "provide", "\u6280\u80fd\u4e0e\u8d44\u6e90", false, false, false, false, 2, appId);
        ContactsSetting phoneBackup = ContactsSettingService.builder("\u624b\u673a\u5907\u4efd", "phoneBackup", "\u624b\u673a\u5907\u4efd", false, false, false, false, 1, appId);
        ContactsSetting memberLevelName = ContactsSettingService.builder("\u7b49\u7ea7/\u5934\u8854", "memberLevelName", "\u7b49\u7ea7/\u5934\u8854", false, false, false, false, 1, appId);
        ContactsSetting endMemberLevelJoinTime = ContactsSettingService.builder("\u5230\u671f\u65f6\u95f4", "endMemberLevelJoinTime", "\u5230\u671f\u65f6\u95f4", false, false, false, false, 1, appId);
        contactsSettings.add(name);
        contactsSettings.add(phone);
        contactsSettings.add(year);
        contactsSettings.add(departmentName);
        contactsSettings.add(degreeName);
        contactsSettings.add(studentId);
        contactsSettings.add(wechat);
        contactsSettings.add(company);
        contactsSettings.add(position);
        contactsSettings.add(trade);
        contactsSettings.add(city);
        contactsSettings.add(mailBox);
        contactsSettings.add(nativePlace);
        contactsSettings.add(companyPhone);
        contactsSettings.add(qqNumber);
        contactsSettings.add(birthday);
        contactsSettings.add(hobby);
        contactsSettings.add(demand);
        contactsSettings.add(provide);
        contactsSettings.add(phoneBackup);
        contactsSettings.add(memberLevelName);
        contactsSettings.add(endMemberLevelJoinTime);
        for (ContactsSetting contactsSetting : contactsSettings) {
            ContactsSetting temp = (ContactsSetting)((Object)this.select(JpaCriteria.builder().eq("fieldId", (Object)contactsSetting.getFieldId()).eq("appId", (Object)appId)));
            if (temp != null) continue;
            this.insert((Object)contactsSetting);
        }
        Member member = new Member();
        WxApp wxApp = this.wxAppService.selectByAppId(appId, WxAppServiceTypeEnum.MINI_PROGRAM.value());
        Shift.throwsIfNull((Object)wxApp, (String)"\u672a\u5bf9\u63a5\u5c0f\u7a0b\u5e8f");
        if (this.memberService.selectById(appId) == null) {
            member.setId(appId);
            member.setName(wxApp.getName());
            member.setHeadImage(wxApp.getLogoUrl());
            member.setNumber(SequenceUtil.createRandomNumberSequence((int)12));
            member.setIsDeleted(Boolean.valueOf(false));
            member.setIsFrozen(Boolean.valueOf(false));
            member.setAppellation("\u5e94\u7528\u521d\u59cb\u5316\u7528\u6237");
            this.memberService.insert((Object)member);
        }
    }

    @Transactional
    public void update(List<ContactsSetting> contactsSettings) {
        for (ContactsSetting contactsSetting : contactsSettings) {
            this.update((Object)contactsSetting);
        }
    }

    public List<ContactsSetting> getField() {
        Config register = this.configService.selectByKey(ConfigEnum.open_register.name());
        Config auth = this.configService.selectByKey(ConfigEnum.is_need_audit.name());
        List list = null;
        if (StringUtil.equals((String)"1", (String)auth.getValue()) && StringUtil.equals((String)"0", (String)register.getValue())) {
            JpaCriteria jpaCriteria = JpaCriteria.builder().eq("authenticate", (Object)true).orderBy("seqNum desc");
            list = this.selectList(jpaCriteria);
        } else {
            JpaCriteria jpaCriteria = JpaCriteria.builder().eq("register", (Object)true).orderBy("seqNum desc");
            list = this.selectList(jpaCriteria);
        }
        Shift.throwsIfNull((Object)list, (String)"\u627e\u4e0d\u5230\u914d\u7f6e\u7684\u5b57\u6bb5");
        return list;
    }

    public List<ContactsSetting> getExportField() {
        List list = this.selectList(JpaCriteria.builder().eq("isNeed", (Object)true).orderBy("seqNum desc"));
        return list;
    }

    public void validateCowebCheck(Contacts contacts) {
        List<ContactsSetting> contactsSettings = this.getField();
        Class<?> clazz = ((Object)((Object)contacts)).getClass();
        Field[] fields = clazz.getDeclaredFields();
        try {
            for (ContactsSetting contactsSetting : contactsSettings) {
                for (Field field : fields) {
                    if (!field.getName().equalsIgnoreCase(contactsSetting.getFieldId())) continue;
                    field.setAccessible(true);
                    Object object = field.get((Object)contacts);
                    int cowebCheck = this.myConfigService.getCowebCheck();
                    if (IntegerUtil.equals((Integer)CowebCheckEnum.AUTHENTICATE.value(), (Integer)cowebCheck) && contactsSetting.getAuthenticate().booleanValue()) {
                        this.throwsIfBlank(object, contactsSetting.getFieldName());
                    }
                    if (!IntegerUtil.equals((Integer)CowebCheckEnum.REGISTER.value(), (Integer)cowebCheck) || !contactsSetting.getRequired().booleanValue()) continue;
                    this.throwsIfBlank(object, contactsSetting.getFieldName());
                }
            }
        }
        catch (IllegalAccessException e) {
            log.error("\u6821\u9a8c\u5931\u8d25", (Throwable)e);
            Shift.throwsIfInvalid((boolean)true, (String)"\u6821\u9a8c\u5931\u8d25");
        }
    }

    public static void main(String[] args) throws ClassNotFoundException, IllegalAccessException {
        String appId = "0";
        ArrayList<ContactsSetting> contactsSettings = new ArrayList<ContactsSetting>();
        ContactsSetting name = ContactsSettingService.builder("\u59d3\u540d", "name", "\u59d3\u540d", true, true, true, true, 20, appId);
        ContactsSetting phone = ContactsSettingService.builder("\u624b\u673a", "phone", "\u624b\u673a", true, true, true, true, 19, appId);
        ContactsSetting year = ContactsSettingService.builder("\u5165\u5b66\u5e74\u4efd", "year", "\u5165\u5b66\u5e74\u4efd", true, true, true, true, 18, appId);
        ContactsSetting professionName = ContactsSettingService.builder("\u4e13\u4e1a", "professionName", "\u4e13\u4e1a", true, true, true, true, 17, appId);
        ContactsSetting studentId = ContactsSettingService.builder("\u5b66\u53f7", "studentId", "\u5b66\u53f7", true, true, true, true, 16, appId);
        ContactsSetting wechat = ContactsSettingService.builder("\u5fae\u4fe1", "wechat", "\u5fae\u4fe1", true, false, false, false, 15, appId);
        ContactsSetting company = ContactsSettingService.builder("\u516c\u53f8", "company", "\u516c\u53f8", true, false, false, false, 14, appId);
        ContactsSetting position = ContactsSettingService.builder("\u804c\u4f4d", "position", "\u804c\u4f4d", true, false, false, false, 13, appId);
        ContactsSetting trade = ContactsSettingService.builder("\u884c\u4e1a", "trade", "\u884c\u4e1a", true, false, false, false, 12, appId);
        ContactsSetting city = ContactsSettingService.builder("\u57ce\u5e02", "city", "\u57ce\u5e02", false, false, false, false, 11, appId);
        ContactsSetting mailBox = ContactsSettingService.builder("\u90ae\u7bb1", "mailBox", "\u90ae\u7bb1", false, false, false, false, 10, appId);
        ContactsSetting nativePlace = ContactsSettingService.builder("\u7c4d\u8d2f", "nativePlace", "\u7c4d\u8d2f", false, false, false, false, 10, appId);
        ContactsSetting companyPhone = ContactsSettingService.builder("\u5355\u4f4d\u7535\u8bdd", "companyPhone", "\u7c4d\u8d2f", false, false, false, false, 10, appId);
        ContactsSetting qqNumber = ContactsSettingService.builder("QQ", "qqNumber", "\u7c4d\u8d2f", false, false, false, false, 10, appId);
        ContactsSetting birthday = ContactsSettingService.builder("\u751f\u65e5", "birthday", "\u751f\u65e5", false, false, false, false, 10, appId);
        ContactsSetting hobby = ContactsSettingService.builder("\u5174\u8da3\u7231\u597d", "hobby", "\u5174\u8da3\u7231\u597d", false, false, false, false, 10, appId);
        ContactsSetting demand = ContactsSettingService.builder("\u9700\u6c42\u4e0e\u671f\u671b", "demand", "\u9700\u6c42\u4e0e\u671f\u671b", false, false, false, false, 10, appId);
        ContactsSetting provide = ContactsSettingService.builder("\u6280\u80fd\u4e0e\u8d44\u6e90", "provide", "\u6280\u80fd\u4e0e\u8d44\u6e90", false, false, false, false, 10, appId);
        ContactsSetting phoneBackup = ContactsSettingService.builder("\u624b\u673a\u5907\u4efd", "phoneBackup", "\u624b\u673a\u5907\u4efd--", false, false, false, false, 10, appId);
        contactsSettings.add(name);
        contactsSettings.add(phone);
        contactsSettings.add(year);
        contactsSettings.add(professionName);
        contactsSettings.add(studentId);
        contactsSettings.add(wechat);
        contactsSettings.add(company);
        contactsSettings.add(position);
        contactsSettings.add(trade);
        contactsSettings.add(city);
        contactsSettings.add(mailBox);
        contactsSettings.add(nativePlace);
        contactsSettings.add(companyPhone);
        contactsSettings.add(qqNumber);
        contactsSettings.add(birthday);
        contactsSettings.add(hobby);
        contactsSettings.add(demand);
        contactsSettings.add(provide);
        contactsSettings.add(phoneBackup);
        Contacts contacts = new Contacts();
        contacts.setName("");
        contacts.setMailbox("123456");
        Class<?> clazz = ((Object)((Object)contacts)).getClass();
        Field[] fields = clazz.getDeclaredFields();
        for (ContactsSetting contactsSetting : contactsSettings) {
            System.out.println("######" + contactsSetting.getFieldId());
            for (Field field : fields) {
                if (!field.getName().equalsIgnoreCase(contactsSetting.getFieldId()) || !contactsSetting.getIsNeed().booleanValue() || !contactsSetting.getRegister().booleanValue() || !contactsSetting.getRequired().booleanValue()) continue;
                field.setAccessible(true);
            }
        }
    }

    private void throwsIfBlank(Object object, String fieldName) {
        if (object == null) {
            Shift.throwsIfInvalid((boolean)true, (String)(fieldName + "\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        Shift.throwsIfBlank((String)object.toString(), (String)(fieldName + "\u4e0d\u80fd\u4e3a\u7a7a"));
    }

    public Config getCowebCheck() {
        Config config = this.configService.selectByKey("coweb_check");
        Shift.throwsIfNull((Object)config, (String)"\u6ce8\u518c\u8ba4\u8bc1\u914d\u7f6e\u4e3a\u7a7a");
        return config;
    }

    public List<ProfileContactsSettingMobileResponse> selectProfileSettingList(String appId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("appId", (Object)appId);
        criteria.eq("isDeleted", (Object)false);
        criteria.eq("isNeed", (Object)true);
        criteria.orderBy("seqNum DESC");
        List list = this.selectList(criteria, ProfileContactsSettingMobileResponse.class);
        if (Checker.listNotEmpty((List)list)) {
            Map configMap = this.configService.selectAsMapByKeyList(appId, list);
            for (ProfileContactsSettingMobileResponse response : list) {
                Integer showType;
                String configKey = response.getKey();
                Config config = (Config)configMap.get(configKey);
                if (config == null || !IntegerUtil.equals((Integer)(showType = config.getShowType()), (Integer)1)) continue;
                response.setShowType("select");
                response.setValueRange(config.getValue().split("_"));
            }
        }
        return list;
    }

    private static ContactsSetting builder(String fileName, String field, String showName, boolean isNeed, boolean authenticate, boolean register, boolean required, int seqNum, String appId) {
        ContactsSetting contactsSetting = new ContactsSetting();
        contactsSetting.setFieldName(fileName);
        contactsSetting.setFieldId(field);
        contactsSetting.setShowName(showName);
        contactsSetting.setIsNeed(isNeed);
        contactsSetting.setAuthenticate(authenticate);
        contactsSetting.setRegister(register);
        contactsSetting.setRequired(required);
        contactsSetting.setSeqNum(seqNum);
        contactsSetting.setAppId(appId);
        return contactsSetting;
    }
}

