/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaCriteria;
import com.wego168.base.domain.Config;
import com.wego168.base.enums.ConfigEnum;
import com.wego168.base.service.ConfigService;
import com.wego168.coweb.domain.ClassAndGrade;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.service.ClassAndGradeService;
import com.wego168.coweb.service.ContactsService;
import com.wego168.domain.BaseDomain;
import com.wego168.member.domain.Member;
import com.wego168.member.enums.MemberStatusEnum;
import com.wego168.member.service.MemberLoginHandler;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CowebMemberLoginHandler
implements MemberLoginHandler {
    private static final Logger log = LoggerFactory.getLogger(CowebMemberLoginHandler.class);
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private ClassAndGradeService classAndGradeService;
    @Autowired
    private ConfigService configService;

    @Transactional
    public void login(Member member, Bootmap bootmap) {
        Config auth;
        if (null == member) {
            log.error("member\u4e3a\u7a7a\uff0c\u4e0d\u4ea7\u751f\u6821\u53cb\u6570\u636e");
            return;
        }
        if (StringUtil.isBlank((String)member.getMobilePhoneNumber())) {
            log.error("\u624b\u673a\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u4ea7\u751f\u6821\u53cb\u6570\u636e");
            return;
        }
        String appId = member.getAppId();
        Config register = this.configService.getCache(ConfigEnum.open_register.name(), appId);
        if (register != null & (auth = this.configService.getCache(ConfigEnum.is_need_audit.name(), appId)) != null && StringUtil.equals((String)"0", (String)register.getValue()) && StringUtil.equals((String)"1", (String)auth.getValue())) {
            log.error("\u5f00\u542f\u8ba4\u8bc1\u7684\u60c5\u51b5\uff0c\u8df3\u8fc7\u521b\u5efa\u6821\u53cb\u6570\u636e{}", (Object)member.getId());
            return;
        }
        Contacts idContact = this.contactsService.selectByMemberId(member.getId());
        Contacts phoneContact = (Contacts)((Object)this.contactsService.select(JpaCriteria.builder().eq("appId", (Object)appId).eq("phone", (Object)member.getMobilePhoneNumber())));
        if (idContact == null && phoneContact != null && StringUtil.isBlank((String)phoneContact.getMemberId())) {
            phoneContact.setMemberId(member.getId());
            phoneContact.setIsBind(true);
            this.contactsService.updateSelective((Object)phoneContact);
            this.contactsService.updatePersonalityLabel(phoneContact.getId());
            this.contactsService.createMemberLevelJoin(phoneContact);
        }
        if (idContact == null && phoneContact == null) {
            Contacts contacts = new Contacts();
            BaseDomainUtil.initBaseDomain((BaseDomain)contacts, (String)appId);
            this.contactsService.initContacts(contacts);
            contacts.setIsBind(true);
            contacts.setMemberId(member.getId());
            contacts.setStatus(this.determineContactInitialStatus(member));
            log.error("contact initial status->{}, appId->{}", (Object)contacts.getStatus(), (Object)appId);
            contacts.setName(StringUtil.isBlank((String)member.getName()) ? member.getAppellation() : member.getName());
            contacts.setPhone(member.getMobilePhoneNumber());
            ClassAndGrade classAndGrade = this.classAndGradeService.selectByContacts(contacts);
            contacts.setClassId(classAndGrade.getId());
            this.contactsService.insert((Object)contacts);
        }
        log.error("phone{}", (Object)member.getMobilePhoneNumber());
    }

    public void createMemberFeeJoin() {
    }

    private int determineContactInitialStatus(Member member) {
        String appId = member.getAppId();
        Config contactInitialStatusConfig = this.configService.getCache(ConfigEnum.contact_initial_status.name(), appId);
        String contactInitialStatus = "follow-member";
        if (contactInitialStatusConfig != null && StringUtil.isNotBlank((String)contactInitialStatusConfig.getValue())) {
            contactInitialStatus = contactInitialStatusConfig.getValue();
        }
        if (StringUtil.equals((String)contactInitialStatus, (String)"pass")) {
            return MemberStatusEnum.PASS.value();
        }
        if (StringUtil.equals((String)contactInitialStatus, (String)"wait-audit")) {
            return MemberStatusEnum.NOT_AUDIT.value();
        }
        return member.getStatus();
    }
}

