/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.wego168.base.enums.OrderStatusEnum;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.domain.Donate;
import com.wego168.coweb.domain.DonateOrder;
import com.wego168.coweb.enums.OrderCreateTypeEnum;
import com.wego168.coweb.enums.OrderTypeEnum;
import com.wego168.coweb.persistence.DonateOrderMapper;
import com.wego168.coweb.service.ClassAndGradeService;
import com.wego168.coweb.service.DonateService;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.SequenceUtil;
import com.wego168.util.Shift;
import com.wego168.wxpay.enums.PayStatusEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DonateOrderService
extends BaseService<DonateOrder> {
    @Autowired
    private DonateService donateService;
    @Autowired
    private ClassAndGradeService classAndGradeService;
    @Autowired
    private DonateOrderMapper donateOrderMapper;

    public CrudMapper<DonateOrder> getMapper() {
        return this.donateOrderMapper;
    }

    public DonateOrder create(DonateOrder donateOrder, String memberId) {
        Donate donate = this.donateService.selectByIdCheckStatus(donateOrder.getSourceId());
        if (donate.getIsConstant().booleanValue()) {
            Integer amount = donate.getAmount();
            Shift.throwsIfInvalid((donateOrder.getAmount() < amount ? 1 : 0) != 0, (String)("\u6350\u8d60\u91d1\u989d\u4e0d\u5c11\u4e8e" + String.format("%.2f", (double)amount.intValue() / 100.0) + "\u5143"));
        }
        if (donateOrder.getIsNeedReceipt() == null) {
            donateOrder.setIsNeedReceipt(false);
        }
        donateOrder.setMemberId(memberId);
        donateOrder.setOrderNo(SequenceUtil.createRandomNumberSequence((int)12));
        donateOrder.setOrderName(donateOrder.getDonator() + "\u7684\u6350\u8d60\u8ba2\u5355");
        donateOrder.setOrderType(OrderTypeEnum.DONATE.value());
        donateOrder.setCreateType(OrderCreateTypeEnum.MEMBER.value());
        donateOrder.setOrderStatus(OrderStatusEnum.PAY.id());
        donateOrder.setPayStatus(PayStatusEnum.NEW.value());
        return donateOrder;
    }

    public DonateOrder getDefaultInfo(String sourceId, Contacts contacts) {
        Donate donate = this.donateService.selectByIdCheckStatus(sourceId);
        String[] split = null;
        if (contacts != null) {
            String className = this.classAndGradeService.getClassNameById(contacts.getClassId());
            split = className.split("-");
        }
        DonateOrder donateOrder = new DonateOrder();
        donateOrder.setAmount(donate.getAmount());
        donateOrder.setSourceId(sourceId);
        donateOrder.setDonator(contacts == null ? "" : contacts.getName());
        donateOrder.setPhone(contacts == null ? "" : contacts.getPhone());
        donateOrder.setMailbox(contacts == null ? "" : contacts.getMailbox());
        donateOrder.setEnrollmentYear(split == null ? "" : split[0]);
        donateOrder.setProfession(split == null ? "" : split[1]);
        donateOrder.setIsContacts(contacts != null);
        donateOrder.setIsAnonymity(false);
        donateOrder.setTitle(donate.getTitle());
        donateOrder.setIconUrl(donate.getIconUrl());
        return donateOrder;
    }
}

