/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.advice.DateTimeUtil;
import com.wego168.coweb.domain.DonateOrder;
import com.wego168.coweb.domain.DonateRecord;
import com.wego168.coweb.persistence.DonateRecordMapper;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DonateRecordService
extends BaseService<DonateRecord> {
    @Autowired
    private DonateRecordMapper donateRecordMapper;

    public CrudMapper<DonateRecord> getMapper() {
        return this.donateRecordMapper;
    }

    public DonateRecord createByDonateOrder(DonateOrder donateOrder) {
        DonateRecord record = new DonateRecord();
        record.setOrderId(donateOrder.getId());
        record.setSourceId(donateOrder.getSourceId());
        record.setMemberId(donateOrder.getMemberId());
        record.setDonator(donateOrder.getDonator());
        record.setAmount(donateOrder.getAmount());
        record.setPhone(donateOrder.getPhone());
        record.setMailbox(donateOrder.getMailbox());
        record.setHeadImage(donateOrder.getHeadImage());
        record.setContent(donateOrder.getContent());
        record.setEnrollmentYear(donateOrder.getEnrollmentYear());
        record.setProfession(donateOrder.getProfession());
        record.setIsContacts(donateOrder.getIsContacts());
        record.setIsAnonymity(donateOrder.getIsAnonymity());
        record.setIsNeedReceipt(donateOrder.getIsNeedReceipt());
        return record;
    }

    public DonateRecord selectByOrderId(String orderId) {
        return (DonateRecord)((Object)super.select(JpaCriteria.builder().eq("orderId", (Object)orderId)));
    }

    public List<DonateRecord> selectRecordPageByAdmin(Page page) {
        page.put((Object)"appId", (Object)this.getAppId());
        page.put((Object)"isDeleted", (Object)false);
        List<DonateRecord> list = this.donateRecordMapper.selectRecordPageByAdmin(page);
        return list;
    }

    public List<DonateRecord> selectRecordPage(Page page) {
        page.put((Object)"appId", (Object)this.getAppId());
        page.put((Object)"isDeleted", (Object)false);
        List<DonateRecord> list = this.donateRecordMapper.selectRecordPage(page);
        if (list != null && list.size() > 0) {
            for (DonateRecord donateRecord : list) {
                donateRecord.setCreateTimeStr(DateTimeUtil.convertFormat((Date)donateRecord.getCreateTime()));
            }
        }
        return list;
    }
}

