/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.simple.mybatis.Page;
import com.wego168.base.advice.DateTimeUtil;
import com.wego168.base.domain.Content;
import com.wego168.base.service.ContentService;
import com.wego168.coweb.domain.Donate;
import com.wego168.coweb.enums.DonateStatusEnum;
import com.wego168.coweb.persistence.DonateMapper;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.Checker;
import com.wego168.util.IntegerUtil;
import com.wego168.util.Shift;
import com.wego168.web.util.GuidGenerator;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DonateService
extends BaseService<Donate> {
    @Autowired
    private ContentService contentService;
    @Autowired
    private DonateMapper donateMapper;

    public CrudMapper<Donate> getMapper() {
        return this.donateMapper;
    }

    @Transactional
    public void insertDonate(Donate donate) {
        if (donate.getIsConstant() != null && donate.getIsConstant().booleanValue()) {
            Checker.checkPositiveInteger((Integer)donate.getAmount(), (String)"\u6350\u8d60\u91d1\u989d");
        }
        Content content = new Content();
        content.setId(GuidGenerator.generate());
        content.setContent(donate.getContent());
        this.contentService.insert((Object)content);
        donate.setStatus(DonateStatusEnum.ING.getIndex());
        donate.setContentId(content.getId());
        super.insert((Object)donate);
    }

    public List<Donate> selectDonatePage(Page page) {
        page.put((Object)"isDeleted", (Object)false);
        List<Donate> list = this.donateMapper.selectDonatePage(page);
        if (list != null && list.size() > 0) {
            for (Donate donate : list) {
                donate.setCreateTimeStr(DateTimeUtil.convertFormat((Date)donate.getCreateTime()));
            }
        }
        return list;
    }

    public List<Donate> selectDonateJoinPage(Page page) {
        page.put((Object)"isDeleted", (Object)false);
        List<Donate> list = this.donateMapper.selectDonateJoinPage(page);
        if (list != null && list.size() > 0) {
            for (Donate donate : list) {
                donate.setCreateTimeStr(DateTimeUtil.convertFormat((Date)donate.getCreateTime()));
            }
        }
        return list;
    }

    public Donate selectDonateById(String id) {
        return this.donateMapper.selectDonateById(id, this.getAppId(), false);
    }

    public Donate selectByIdCheckStatus(String id) {
        Donate donate = (Donate)((Object)super.selectById((Object)id));
        Shift.throwsIfInvalid((donate == null || donate.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u6350\u8d60\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        Integer status = donate.getStatus();
        Shift.throwsIfInvalid((boolean)IntegerUtil.equals((Integer)status, (Integer)DonateStatusEnum.STOP.getIndex()), (String)"\u8be5\u6350\u8d60\u6d3b\u52a8\u5df2\u6682\u505c");
        Shift.throwsIfInvalid((boolean)IntegerUtil.equals((Integer)status, (Integer)DonateStatusEnum.END.getIndex()), (String)"\u8be5\u6350\u8d60\u6d3b\u52a8\u5df2\u7ed3\u675f");
        return donate;
    }

    @Transactional
    public void updateDonate(Donate donate) {
        Donate vo = (Donate)((Object)super.selectById((Object)donate.getId()));
        Shift.throwsIfInvalid((vo == null || vo.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        Content content = (Content)this.contentService.selectById((Object)vo.getContentId());
        content.setId(GuidGenerator.generate());
        content.setContent(donate.getContent());
        this.contentService.updateSelective((Object)content);
        if (new Date().after(donate.getEndTime())) {
            donate.setStatus(DonateStatusEnum.END.getIndex());
        } else if (!IntegerUtil.equals((Integer)donate.getStatus(), (Integer)DonateStatusEnum.STOP.getIndex())) {
            donate.setStatus(DonateStatusEnum.ING.getIndex());
        }
        donate.setUpdateTime(new Date());
        super.updateSelective((Object)donate);
    }

    public void updateDonateStatus() {
        this.donateMapper.updateDonateStatus(new Date(), DonateStatusEnum.END.getIndex(), false);
    }
}

