/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.activity.domain.Activity;
import com.wego168.activity.domain.ActivityFee;
import com.wego168.activity.service.ActivityFeeService;
import com.wego168.activity.service.ActivityService;
import com.wego168.base.domain.SingleContent;
import com.wego168.base.service.SingleContentService;
import com.wego168.bbs.enums.InformationAuditStatusEnum;
import com.wego168.bbs.service.BBSCommentService;
import com.wego168.course.domain.Course;
import com.wego168.course.service.CourseService;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.domain.MiniProgramSearchApp;
import com.wego168.coweb.enums.MiniProgramSearchSignEnum;
import com.wego168.coweb.service.ContactsService;
import com.wego168.coweb.service.MiniProgramSearchAppService;
import com.wego168.coweb.service.MyInformationService;
import com.wego168.mall.service.ProductService;
import com.wego168.util.StringUtil;
import com.wego168.web.AuthenticationUser;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HomeResponseService {
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private SingleContentService singleContentService;
    @Autowired
    private ActivityFeeService activityFeeService;
    @Autowired
    private MyInformationService myInformationService;
    @Autowired
    private BBSCommentService bbsCommentService;
    @Autowired
    private ProductService productService;
    @Autowired
    private MiniProgramSearchAppService miniProgramSearchAppService;
    @Autowired
    private AuthenticationUser authenticationUser;
    @Autowired
    private CourseService courseService;

    public List<Bootmap> search(String keyword) {
        LinkedList<Bootmap> bootmaps = new LinkedList<Bootmap>();
        List<MiniProgramSearchApp> miniProgramSearchApps = this.miniProgramSearchAppService.get(this.authenticationUser.getAppId());
        for (MiniProgramSearchApp miniProgramSearchApp : miniProgramSearchApps) {
            List<Course> courses;
            List<SingleContent> singleContents;
            List<Bootmap> informations;
            List<Contacts> contacts;
            Bootmap bootmap;
            List<Activity> activities;
            if (StringUtil.equals((String)MiniProgramSearchSignEnum.ACTIVITY.value(), (String)miniProgramSearchApp.getSign()) && (activities = this.searchActivity(keyword, miniProgramSearchApp)) != null && activities.size() > 0) {
                bootmap = new Bootmap();
                bootmap.put((Object)"showName", (Object)miniProgramSearchApp.getShowName());
                bootmap.put((Object)"sign", (Object)miniProgramSearchApp.getSign());
                bootmap.put((Object)"data", activities);
                bootmaps.add(bootmap);
            }
            if (StringUtil.equals((String)MiniProgramSearchSignEnum.CONTACTS.value(), (String)miniProgramSearchApp.getSign()) && (contacts = this.searchContacts(keyword)) != null && contacts.size() > 0) {
                bootmap = new Bootmap();
                bootmap.put((Object)"showName", (Object)miniProgramSearchApp.getShowName());
                bootmap.put((Object)"sign", (Object)miniProgramSearchApp.getSign());
                bootmap.put((Object)"data", contacts);
                bootmaps.add(bootmap);
            }
            if (StringUtil.equals((String)MiniProgramSearchSignEnum.INFORMATION.value(), (String)miniProgramSearchApp.getSign()) && (informations = this.searchInformation(keyword, miniProgramSearchApp)) != null && informations.size() > 0) {
                bootmap = new Bootmap();
                bootmap.put((Object)"showName", (Object)miniProgramSearchApp.getShowName());
                bootmap.put((Object)"sign", (Object)miniProgramSearchApp.getSign());
                bootmap.put((Object)"data", informations);
                bootmaps.add(bootmap);
            }
            if (StringUtil.equals((String)MiniProgramSearchSignEnum.SINGLECONTENT.value(), (String)miniProgramSearchApp.getSign()) && (singleContents = this.searchSingleContent(keyword, miniProgramSearchApp)) != null && singleContents.size() > 0) {
                bootmap = new Bootmap();
                bootmap.put((Object)"showName", (Object)miniProgramSearchApp.getShowName());
                bootmap.put((Object)"sign", (Object)miniProgramSearchApp.getSign());
                bootmap.put((Object)"data", singleContents);
                bootmaps.add(bootmap);
            }
            if (StringUtil.equals((String)MiniProgramSearchSignEnum.COURSE.value(), (String)miniProgramSearchApp.getSign()) && (courses = this.searchCourse(keyword, miniProgramSearchApp)) != null && courses.size() > 0) {
                bootmap = new Bootmap();
                bootmap.put((Object)"showName", (Object)miniProgramSearchApp.getShowName());
                bootmap.put((Object)"sign", (Object)miniProgramSearchApp.getSign());
                bootmap.put((Object)"data", courses);
                bootmaps.add(bootmap);
            }
            if (!StringUtil.equals((String)MiniProgramSearchSignEnum.MALL.value(), (String)miniProgramSearchApp.getSign())) continue;
            Page page = new Page();
            page.put((Object)"name", (Object)keyword);
            page.put((Object)"appId", (Object)this.authenticationUser.getAppId());
            List lists = this.productService.pageForSale(page);
            if (lists != null && lists.size() > 0) {
                for (Map boot : lists) {
                    if (boot.containsKey("salesQty")) {
                        Integer salesQty = Integer.valueOf(boot.get("salesQty").toString());
                        boot.put("saleQty", salesQty);
                        continue;
                    }
                    boot.put("saleQty", 0);
                }
            }
            if (lists == null || lists.size() <= 0) continue;
            Bootmap bootmap2 = new Bootmap();
            bootmap2.put((Object)"showName", (Object)miniProgramSearchApp.getShowName());
            bootmap2.put((Object)"sign", (Object)miniProgramSearchApp.getSign());
            bootmap2.put((Object)"data", (Object)lists);
            bootmaps.add(bootmap2);
        }
        return bootmaps;
    }

    private List<Course> searchCourse(String keyword, MiniProgramSearchApp miniProgramSearchApp) {
        JpaCriteria jpaCriteria = JpaCriteria.builder().like("title", (Object)("%" + keyword + "%"));
        jpaCriteria.eq("type", (Object)1);
        if (StringUtil.isNotBlank((String)miniProgramSearchApp.getParam())) {
            jpaCriteria.eq("categoryId", (Object)miniProgramSearchApp.getParam());
        }
        return this.courseService.selectList(jpaCriteria);
    }

    private List<Activity> searchActivity(String keyword, MiniProgramSearchApp miniProgramSearchApp) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.like("title", (Object)keyword);
        criteria.eq("type", (Object)1);
        criteria.eq("appId", (Object)miniProgramSearchApp.getAppId());
        criteria.eq("isRelease", (Object)true);
        criteria.eq("isDeleted", (Object)false);
        if (StringUtil.isNotBlank((String)miniProgramSearchApp.getParam())) {
            criteria.eq("categoryId", (Object)miniProgramSearchApp.getParam());
        }
        List activities = this.activityService.selectList(criteria);
        for (Activity activity : activities) {
            if (!activity.getIsEnableFee().booleanValue()) continue;
            ActivityFee activityFee = this.activityFeeService.selectByActivityId(activity.getId());
            activity.setActivityFee(activityFee);
        }
        return activities;
    }

    private List<Contacts> searchContacts(String keyword) {
        Page page = new Page();
        page.put((Object)"name", (Object)keyword);
        return this.contactsService.selectContacts(page);
    }

    private List<Bootmap> searchInformation(String keyword, MiniProgramSearchApp miniProgramSearchApp) {
        List<Bootmap> list;
        Page page = new Page();
        page.put((Object)"keyword", (Object)keyword);
        page.put((Object)"auditStatus", (Object)InformationAuditStatusEnum.AUDIT.value());
        if (StringUtil.isNotBlank((String)miniProgramSearchApp.getParam())) {
            page.eq("categoryId", (Object)miniProgramSearchApp.getParam());
        }
        if ((list = this.myInformationService.searchInformationPage(page, "")) != null && list.size() > 0) {
            list = this.bbsCommentService.addCommentToList(list, Integer.valueOf(3));
            list = this.myInformationService.addIsAuditToList(list);
        }
        return list;
    }

    private List<SingleContent> searchSingleContent(String keyword, MiniProgramSearchApp miniProgramSearchApp) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.like("title", (Object)keyword);
        criteria.eq("isDisplay", (Object)true);
        criteria.eq("isDeleted", (Object)false);
        if (StringUtil.isNotBlank((String)miniProgramSearchApp.getParam())) {
            criteria.eq("categoryId", (Object)miniProgramSearchApp.getParam());
        }
        List singleContents = this.singleContentService.selectList(criteria);
        return singleContents;
    }
}

