/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.wego168.base.enums.OrderStatusEnum;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.domain.MembershipOrder;
import com.wego168.coweb.domain.MembershipRecord;
import com.wego168.coweb.enums.OrderCreateTypeEnum;
import com.wego168.coweb.enums.OrderTypeEnum;
import com.wego168.coweb.persistence.MembershipOrderMapper;
import com.wego168.coweb.service.ContactsService;
import com.wego168.coweb.service.MembershipRecordService;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.DateUtil;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import com.wego168.wx.enums.WxAppServiceTypeEnum;
import com.wego168.wxpay.domain.Pay;
import com.wego168.wxpay.enums.PayStatusEnum;
import com.wego168.wxpay.service.PayService;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MembershipOrderService
extends BaseService<MembershipOrder> {
    @Autowired
    private PayService payService;
    @Autowired
    private MembershipRecordService membershipRecordService;
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private MembershipOrderMapper membershipOrderMapper;

    public CrudMapper<MembershipOrder> getMapper() {
        return this.membershipOrderMapper;
    }

    public Boolean checkYear(String openYear) {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
        String firstYear = simpleDateFormat.format(date);
        String lastYear = simpleDateFormat.format(DateUtil.addYearsToDate((Date)date, (int)1));
        if (openYear.compareTo(firstYear) >= 0 && openYear.compareTo(lastYear) <= 0) {
            return true;
        }
        return false;
    }

    public MembershipOrder create(Contacts contacts, String openYear, Integer amount) {
        MembershipOrder membershipOrder = new MembershipOrder();
        membershipOrder.setOrderNo(SequenceUtil.createRandomNumberSequence((int)12));
        membershipOrder.setOrderType(OrderTypeEnum.MEMBERSHIP.value());
        membershipOrder.setOpenYear(openYear);
        membershipOrder.setMemberId(contacts.getMemberId());
        membershipOrder.setContactsId(contacts.getId());
        membershipOrder.setOrderName(contacts.getId() + "\u7684" + openYear + "\u5e74\u4f1a\u7c4d\u8ba2\u5355");
        membershipOrder.setOrderStatus(OrderStatusEnum.PAY.id());
        membershipOrder.setPayStatus(PayStatusEnum.NEW.value());
        membershipOrder.setAmount(amount);
        membershipOrder.setCreateType(OrderCreateTypeEnum.MEMBER.value());
        return membershipOrder;
    }

    public MembershipOrder createByAdmin(String contactsId, String openYear, Integer amount) {
        Contacts contacts = (Contacts)((Object)this.contactsService.selectById(contactsId));
        MembershipOrder membershipOrder = this.create(contacts, openYear, amount);
        membershipOrder.setCreateType(OrderCreateTypeEnum.ADMIN.value());
        membershipOrder.setOrderStatus(OrderStatusEnum.FINISH.id());
        membershipOrder.setPayStatus(PayStatusEnum.SUCCESS.value());
        return membershipOrder;
    }

    @Transactional
    public void openMembershipByAdmin(String contactsId, String openYear, Integer amount) {
        MembershipOrder membershipOrder = this.createByAdmin(contactsId, openYear, amount);
        super.insert((Object)membershipOrder);
        Pay cashPay = this.payService.createByCashTrade(amount.intValue(), membershipOrder.getId(), OrderTypeEnum.MEMBERSHIP.value(), "\u4f1a\u7c4d\u4f1a\u8d39\u652f\u4ed8", membershipOrder.getAppId(), contactsId, "NONE", WxAppServiceTypeEnum.MINI_PROGRAM.value());
        this.payService.insert((Object)cashPay);
        MembershipRecord membershipRecord = this.membershipRecordService.createByOrder(membershipOrder);
        this.membershipRecordService.insert((Object)membershipRecord);
        String thisYear = new SimpleDateFormat("yyyy").format(new Date());
        if (StringUtil.equals((String)membershipOrder.getOpenYear(), (String)thisYear)) {
            Contacts contacts = (Contacts)((Object)this.contactsService.selectById(contactsId));
            contacts.setIsMembership(true);
            this.contactsService.updateSelective((Object)contacts);
        }
    }
}

