/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.domain.MembershipOrder;
import com.wego168.coweb.domain.MembershipRecord;
import com.wego168.coweb.persistence.MembershipRecordMapper;
import com.wego168.coweb.service.ContactsService;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.DateUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MembershipRecordService
extends BaseService<MembershipRecord> {
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private MembershipRecordMapper membershipDuesRecordMapper;

    public CrudMapper<MembershipRecord> getMapper() {
        return this.membershipDuesRecordMapper;
    }

    public List<MembershipRecord> selectByStudentId(String studentId) {
        Contacts contacts = this.contactsService.selectByStudentId(studentId);
        Shift.throwsIfInvalid((contacts == null || contacts.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u5b66\u53f7\u6821\u53cb\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        return super.selectList(JpaCriteria.builder().eq("contactsId", (Object)contacts.getId()).orderBy("open_year DESC"));
    }

    public MembershipRecord selectByContactsIdAndOpenYear(String contactsId, String openYear) {
        return (MembershipRecord)((Object)super.select(JpaCriteria.builder().eq("contactsId", (Object)contactsId).eq("openYear", (Object)openYear).eq("isDeleted", (Object)false)));
    }

    public MembershipRecord createByOrder(MembershipOrder membershipOrder) {
        MembershipRecord membershipRecord = new MembershipRecord();
        membershipRecord.setMemberId(membershipOrder.getMemberId());
        membershipRecord.setContactsId(membershipOrder.getContactsId());
        membershipRecord.setOpenYear(membershipOrder.getOpenYear());
        membershipRecord.setAmount(membershipOrder.getAmount());
        return membershipRecord;
    }

    public Map<String, List<String>> getRecordByStudentId(String studentId) {
        List<MembershipRecord> records = this.selectByStudentId(studentId);
        ArrayList<String> openList = new ArrayList<String>();
        ArrayList<String> notOpenList = new ArrayList<String>();
        HashMap<String, List<String>> returnMap = new HashMap<String, List<String>>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
        Date date = new Date();
        String thisYear = simpleDateFormat.format(date);
        String nextYear = simpleDateFormat.format(DateUtil.addYearsToDate((Date)date, (int)1));
        notOpenList.add(thisYear);
        notOpenList.add(nextYear);
        if (records != null && records.size() > 0) {
            for (MembershipRecord membershipRecord : records) {
                openList.add(membershipRecord.getOpenYear());
                if (StringUtil.equals((String)nextYear, (String)membershipRecord.getOpenYear())) {
                    notOpenList.remove(nextYear);
                }
                if (!StringUtil.equals((String)thisYear, (String)membershipRecord.getOpenYear())) continue;
                notOpenList.remove(thisYear);
            }
        }
        returnMap.put("openList", openList);
        returnMap.put("notOpenList", notOpenList);
        return returnMap;
    }
}

