/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.wego168.activity.domain.Activity;
import com.wego168.activity.domain.ActivitySignSetting;
import com.wego168.activity.enums.ActivitySignSettingScopeEnum;
import com.wego168.activity.service.ActivityService;
import com.wego168.activity.service.ActivitySignSettingService;
import com.wego168.bbs.domain.Information;
import com.wego168.bbs.enums.InformationTypeEnum;
import com.wego168.bbs.service.InformationService;
import com.wego168.coweb.enums.ActivityTypeEnum;
import com.wego168.coweb.persistence.MyActivityMapper;
import com.wego168.coweb.scheduler.Task;
import com.wego168.coweb.service.MyInformationService;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.util.SessionUtil;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MyActivityService
extends BaseService<Activity> {
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivitySignSettingService activitySignSettingService;
    @Autowired
    private InformationService informationService;
    @Autowired
    private MyInformationService myInformationService;
    @Autowired
    private MyActivityMapper myActivityMapper;
    @Autowired
    private Task task;
    private static final Logger logger = LoggerFactory.getLogger(MyActivityService.class);

    public CrudMapper<Activity> getMapper() {
        return this.myActivityMapper;
    }

    @Transactional
    public Information insertActivity(Activity activity, MemberAccount memberAccount, Member member) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        activity.setCreateBy(memberId);
        activity.setType(ActivityTypeEnum.MEMBER.getIndex());
        activity.setIsRelease(Boolean.valueOf(true));
        activity.setIsEnableComment(Boolean.valueOf(true));
        activity.setIsEnableCommentAudit(Boolean.valueOf(true));
        activity.setIsEnableFee(Boolean.valueOf(false));
        activity.setIsEnableCheckin(Boolean.valueOf(false));
        activity.setIsEnableAloneItem(Boolean.valueOf(false));
        activity.setIsShowBase(Boolean.valueOf(true));
        ActivitySignSetting activitySignSetting = activity.getActivitySignSetting();
        activitySignSetting.setSignNum(Integer.valueOf(0));
        activitySignSetting.setPreSignNum(Integer.valueOf(0));
        activitySignSetting.setIsEnableUnsign(Boolean.valueOf(false));
        activitySignSetting.setIsNeedSubscribe(Boolean.valueOf(false));
        activitySignSetting.setIsEnableAudit(Boolean.valueOf(false));
        activitySignSetting.setIsEnableRemindMsg(Boolean.valueOf(true));
        activitySignSetting.setIsEnableRemindStart(Boolean.valueOf(false));
        activitySignSetting.setIsEnableSmsRemind(Boolean.valueOf(false));
        activitySignSetting.setIsEnableWxRemind(Boolean.valueOf(true));
        activitySignSetting.setIsEnableWxTemplateRemind(Boolean.valueOf(true));
        activitySignSetting.setIsShowSignMembers(Boolean.valueOf(true));
        activitySignSetting.setIsEnableSignShow(Boolean.valueOf(true));
        activitySignSetting.setIsEnableToAuditShow(Boolean.valueOf(false));
        activitySignSetting.setIsEnableUnpaidShow(Boolean.valueOf(false));
        activitySignSetting.setIsEnableSMSVerify(Boolean.valueOf(false));
        activitySignSetting.setAppId(activity.getAppId());
        activitySignSetting.setSignScope(ActivitySignSettingScopeEnum.ALL.value());
        this.activityService.changeActivityStatus(activity, activitySignSetting);
        super.insert((Object)activity);
        String activityId = activity.getId();
        activitySignSetting.setActivityId(activityId);
        this.activitySignSettingService.insert((Object)activitySignSetting);
        Information information = new Information();
        information.setAppId(activity.getAppId());
        information.setCategoryId(activity.getCategoryId());
        information.setMemberId(memberId);
        information.setAddress(activity.getAddress());
        information.setTitle(activity.getTitle());
        information.setContent(activity.getInfo());
        information.setImgUrl(activity.getIconUrl());
        information.setSourceId(activity.getId());
        information.setType(Integer.valueOf(InformationTypeEnum.ACTIVITY.value()));
        information.setCreateTime(new Date());
        Integer templeType = this.myInformationService.checkStatusAndContent(information);
        this.informationService.insertInformation(information);
        if (member != null) {
            this.task.sendPublishTemple(information.getId(), memberAccount.getUsername(), member.getName(), templeType, information.getUnAutoAuditedReason());
        }
        return information;
    }
}

