/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.wego168.base.domain.Config;
import com.wego168.base.service.ConfigService;
import com.wego168.coweb.domain.ClassAndGrade;
import com.wego168.coweb.enums.VerifyTypeEnum;
import com.wego168.coweb.service.ClassAndGradeService;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MyConfigService
extends ConfigService {
    @Autowired
    private ConfigService configService;
    @Autowired
    private ClassAndGradeService classAndGradeService;

    public Set<String> getTradeSet() {
        Config config = this.configService.getByKey("trade");
        if (config != null && StringUtil.isNotBlank((String)config.getValue())) {
            String[] tradeConfig = config.getValue().split("_");
            List<String> tradeList = Arrays.asList(tradeConfig);
            HashSet<String> tradeSet = new HashSet<String>(tradeList);
            return tradeSet;
        }
        return null;
    }

    public Map<String, Object> getClassAndTradeList() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Config config = super.getByKey("trade");
        if (config != null) {
            String value = config.getValue();
            String[] tradeConfig = value.split("_");
            List<String> tradeList = Arrays.asList(tradeConfig);
            map.put("tradeList", tradeList);
        }
        List<ClassAndGrade> classList = this.classAndGradeService.selectClassList();
        map.put("classList", classList);
        return map;
    }

    public Integer getVerifyType() {
        Config config = this.getVerifyTypeConfig();
        Integer verifyType = Integer.valueOf(config.getValue());
        Shift.throwsIfInvalid((!VerifyTypeEnum.isValid(verifyType) ? 1 : 0) != 0, (String)"\u9a8c\u8bc1\u65b9\u5f0f\u914d\u7f6e\u9519\u8bef");
        return verifyType;
    }

    public Config getVerifyTypeConfig() {
        Config config = super.getByKey("verify_type");
        Shift.throwsIfNull((Object)config, (String)"\u8bf7\u5148\u914d\u7f6e\u9a8c\u8bc1\u65b9\u5f0f");
        return config;
    }

    public Integer getCowebCheck() {
        Config config = this.getCowebCheckConfig();
        Integer verifyType = Integer.valueOf(config.getValue());
        Shift.throwsIfInvalid((!VerifyTypeEnum.isValid(verifyType) ? 1 : 0) != 0, (String)"\u9a8c\u8bc1\u65b9\u5f0f\u914d\u7f6e\u9519\u8bef");
        return verifyType;
    }

    public Config getCowebCheckConfig() {
        Config config = this.getByKey("coweb_check");
        Shift.throwsIfNull((Object)config, (String)"\u8bf7\u5148\u914d\u7f6e\u9a8c\u8bc1\u65b9\u5f0f");
        return config;
    }

    public Config getAppCustomer() {
        Config config = this.getByKey("appCustomer");
        if (config == null) {
            config = this.configService.create(this.getAppId(), 10, "appCustomer", "\u5ba2\u670d", "18000000000", null, 1, "\u5ba2\u670d\u7535\u8bdd", (short)1, true);
            this.insert(config);
        }
        return config;
    }

    public void saveOrUpdate(Config config) {
        if (StringUtil.isBlank((String)config.getId())) {
            this.insert(config);
        } else {
            this.update(config);
        }
    }

    public void saveOrUpdateAuthenticateBg(Config config) {
    }

    public void copyData(String sourceAppId, String targetAppId) {
    }

    public void init(String appId) {
    }
}

