/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.sdk.green.AliyunGreenSDK;
import com.simple.mybatis.Bootmap;
import com.simple.mybatis.Page;
import com.wego168.base.domain.Config;
import com.wego168.base.service.ConfigService;
import com.wego168.bbs.domain.Information;
import com.wego168.bbs.enums.InformationAuditStatusEnum;
import com.wego168.bbs.service.BBSPraiseService;
import com.wego168.bbs.service.InformationService;
import com.wego168.bbs.service.SensitiveWordService;
import com.wego168.coweb.enums.MiniprogarmTempleTypeEnum;
import com.wego168.coweb.persistence.MyInformationMapper;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.IntegerUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MyInformationService
extends BaseService<Information> {
    private static final Logger log = LoggerFactory.getLogger(MyInformationService.class);
    @Autowired
    private BBSPraiseService bbsPraiseService;
    @Autowired
    private InformationService informationService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private SensitiveWordService sensitiveWordService;
    @Autowired
    private MyInformationMapper myInformationMapper;

    public CrudMapper<Information> getMapper() {
        return this.myInformationMapper;
    }

    public List<Bootmap> selectInformationPage(Page page, String memberId) {
        page.put((Object)"appId", (Object)this.getAppId());
        page.put((Object)"isDeleted", (Object)0);
        List<Bootmap> list = this.myInformationMapper.selectInformationPage(page);
        List<Object> linkedList = new LinkedList<Bootmap>();
        if (list != null && list.size() > 0) {
            for (Bootmap bootmap : linkedList) {
                String username = bootmap.getString("username");
                if (!StringUtil.isBlank((String)username)) continue;
                username = bootmap.getString("appellation");
                bootmap.put((Object)"username", (Object)username);
            }
            linkedList = new LinkedList<Bootmap>(list);
            linkedList = this.informationService.convertFormat(linkedList);
        }
        return linkedList;
    }

    public List<Bootmap> searchInformationPage(Page page, String memberId) {
        page.put((Object)"appId", (Object)this.getAppId());
        page.put((Object)"isDeleted", (Object)0);
        List list = this.myInformationMapper.selectInformationPage(page);
        if (list != null && list.size() > 0) {
            list = this.informationService.convertFormat(list);
        }
        return list;
    }

    public List<Bootmap> selectJoinedPage(Page page, String memberId) {
        page.put((Object)"appId", (Object)this.getAppId());
        page.put((Object)"isDeleted", (Object)false);
        List list = this.myInformationMapper.selectJoinedPage(page);
        if (list != null && list.size() > 0) {
            list = this.bbsPraiseService.addIsPraiseToList(list, memberId);
            list = this.informationService.convertFormat(list);
        }
        return list;
    }

    public Integer checkStatusAndContent(Information information) {
        Integer templeType;
        Config config = this.configService.selectByKey("audit_switch", information.getAppId());
        log.error("\u8d44\u8baf\u5ba1\u6838->{}", (Object)config.getId());
        if (config != null && !config.getIsDeleted().booleanValue() && StringUtil.equals((String)"open", (String)config.getValue())) {
            information.setAuditStatus(Integer.valueOf(InformationAuditStatusEnum.WAIT.value()));
            information.setIsAutoAudit(Boolean.valueOf(true));
            templeType = MiniprogarmTempleTypeEnum.PUBLISH_SUCCESS_WAIT.value();
        } else {
            Set sensitiveWordSet;
            JSONObject jsonObject = AliyunGreenSDK.sendScanTask((String)information.getContent());
            if (StringUtil.equals((String)((String)jsonObject.get((Object)"suggestion")), (String)"block")) {
                String tip = jsonObject.get((Object)"tip").toString();
                Shift.throwsIfInvalid((!tip.contains("\u5e7f\u544a") ? 1 : 0) != 0, (String)tip);
            }
            if ((sensitiveWordSet = this.sensitiveWordService.getSensitiveWord(information.getContent())).size() > 0) {
                information.setIsAutoAudit(Boolean.valueOf(false));
                information.setAuditStatus(Integer.valueOf(InformationAuditStatusEnum.WAIT.value()));
                information.setUnAutoAuditedReason("\u5305\u542b\u654f\u611f\u8bcd:" + sensitiveWordSet);
                templeType = MiniprogarmTempleTypeEnum.PUBLISH_FAILED.value();
            } else {
                information.setIsAutoAudit(Boolean.valueOf(true));
                information.setAuditStatus(Integer.valueOf(InformationAuditStatusEnum.AUDIT.value()));
                templeType = MiniprogarmTempleTypeEnum.PUBLISH_SUCCESS.value();
            }
        }
        return templeType;
    }

    public List<Bootmap> addIsAuditToList(List<Bootmap> list) {
        for (Bootmap bootmap : list) {
            Integer auditStatus = bootmap.getInteger("auditStatus");
            Boolean isReportAudit = bootmap.getBoolean("isReportAudit");
            if (IntegerUtil.equals((Integer)auditStatus, (Integer)InformationAuditStatusEnum.AUDIT.value()) && isReportAudit.booleanValue()) {
                bootmap.put((Object)"isAudit", (Object)true);
                continue;
            }
            bootmap.put((Object)"isAudit", (Object)false);
        }
        return list;
    }

    public Bootmap getSourceData(String sourceId) {
        return this.myInformationMapper.getSourceData(sourceId);
    }

    public List<Bootmap> selectInformationPage(Page page) {
        page.put((Object)"appId", (Object)this.getAppId());
        page.put((Object)"isDeleted", (Object)false);
        List list = this.myInformationMapper.selectInformationPage(page);
        if (list != null && list.size() > 0) {
            list = this.informationService.convertFormat(list);
        }
        return list;
    }
}

