/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.activity.domain.ActivitySignSetting;
import com.wego168.activity.service.ActivitySignService;
import com.wego168.activity.service.ActivitySignSettingService;
import com.wego168.base.domain.Sign;
import com.wego168.base.enums.OrderStatusEnum;
import com.wego168.base.enums.SignStatusEnum;
import com.wego168.base.enums.SourceTypeEnum;
import com.wego168.base.service.SignService;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.domain.DonateOrder;
import com.wego168.coweb.domain.DonateRecord;
import com.wego168.coweb.domain.MembershipOrder;
import com.wego168.coweb.domain.MembershipRecord;
import com.wego168.coweb.enums.OrderTypeEnum;
import com.wego168.coweb.scheduler.Task;
import com.wego168.coweb.service.ContactsService;
import com.wego168.coweb.service.DonateOrderService;
import com.wego168.coweb.service.DonateRecordService;
import com.wego168.coweb.service.MembershipOrderService;
import com.wego168.coweb.service.MembershipRecordService;
import com.wego168.util.IntegerUtil;
import com.wego168.util.StringUtil;
import com.wego168.wxpay.domain.Pay;
import com.wego168.wxpay.enums.PayStatusEnum;
import com.wego168.wxpay.service.PayService;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="cowebPayNotifyService")
public class PayNotifyService {
    @Autowired
    private PayService payService;
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private MembershipOrderService membershipOrderService;
    @Autowired
    private MembershipRecordService membershipRecordService;
    @Autowired
    private DonateOrderService donateOrderService;
    @Autowired
    private DonateRecordService donateRecordService;
    @Autowired
    private SignService signService;
    @Autowired
    private ActivitySignService activitySignService;
    @Autowired
    private ActivitySignSettingService activitySignSettingService;
    @Autowired
    private Task task;

    @Transactional
    public void update(Pay pay, String orderId, int payAmount, String outTradeNumber) {
        if (pay != null) {
            this.payService.updateWechatPay(outTradeNumber, pay.getId());
        }
        String payType = "";
        String url = "";
        if (IntegerUtil.equals((Integer)pay.getOrderType(), (Integer)OrderTypeEnum.MEMBERSHIP.value())) {
            payType = "\u5f00\u901a\u5e74\u4f1a\u652f\u4ed8";
            MembershipOrder membershipOrder = (MembershipOrder)((Object)this.membershipOrderService.selectById(orderId));
            membershipOrder.setOrderStatus(OrderStatusEnum.FINISH.id());
            membershipOrder.setPayStatus(PayStatusEnum.SUCCESS.value());
            this.membershipOrderService.updateSelective((Object)membershipOrder);
            MembershipRecord membershipRecord = this.membershipRecordService.createByOrder(membershipOrder);
            this.membershipRecordService.insert((Object)membershipRecord);
            String thisYear = new SimpleDateFormat("yyyy").format(new Date());
            if (StringUtil.equals((String)membershipOrder.getOpenYear(), (String)thisYear)) {
                Contacts contacts = this.contactsService.selectByMemberId(membershipOrder.getMemberId());
                contacts.setIsMembership(true);
                this.contactsService.updateSelective((Object)contacts);
            }
        } else if (IntegerUtil.equals((Integer)pay.getOrderType(), (Integer)OrderTypeEnum.DONATE.value())) {
            DonateOrder donateOrder = (DonateOrder)((Object)this.donateOrderService.selectById(orderId));
            donateOrder.setOrderStatus(OrderStatusEnum.FINISH.id());
            donateOrder.setPayStatus(PayStatusEnum.SUCCESS.value());
            this.donateOrderService.updateSelective((Object)donateOrder);
            DonateRecord donateRecord = this.donateRecordService.createByDonateOrder(donateOrder);
            this.donateRecordService.insert((Object)donateRecord);
        } else if (IntegerUtil.equals((Integer)pay.getOrderType(), (Integer)OrderTypeEnum.ACTIVITY.value())) {
            Sign sign = (Sign)this.signService.selectById((Object)orderId);
            sign.setPayAmount(Integer.valueOf(sign.getPayAmount() + payAmount));
            sign.setAmount(Integer.valueOf(sign.getPrice() - sign.getPayAmount()));
            sign.setPayTime(new Date());
            if (sign.getAmount() <= 0) {
                sign.setStatus(SignStatusEnum.SIGN.getIndex());
                sign.setIsPay(Boolean.valueOf(true));
            }
            this.signService.updateSelective((Object)sign);
            if (pay != null) {
                this.payService.updateWechatPay(outTradeNumber, pay.getId());
            }
            this.activitySignService.createAirboneCheckin(sign);
            if (SourceTypeEnum.ACTIVITY.getIndex() == sign.getSourceType()) {
                ActivitySignSetting activitySignSetting = (ActivitySignSetting)this.activitySignSettingService.select(JpaCriteria.builder().eq("activityId", (Object)sign.getSourceId()));
                this.activitySignSettingService.updateActivitySignNum(activitySignSetting);
            }
            payType = "\u6d3b\u52a8\u652f\u4ed8";
            url = "pages/activityDetail/activityDetail?id=" + sign.getSourceId();
        }
        this.task.sendPayTemple(pay, payType, url);
    }
}

