/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.coweb.domain.Profession;
import com.wego168.coweb.enums.ProfessionTypeEnum;
import com.wego168.coweb.persistence.ProfessionMapper;
import com.wego168.coweb.service.ClassAndGradeService;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.Checker;
import com.wego168.util.IntegerUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProfessionService
extends BaseService<Profession> {
    @Autowired
    private ClassAndGradeService classAndGradeService;
    @Autowired
    private ProfessionMapper professionMapper;

    public CrudMapper<Profession> getMapper() {
        return this.professionMapper;
    }

    @Transactional
    public void updateProfession(String id, String newName, Integer seqNum) {
        Profession profession = (Profession)((Object)this.selectById(id));
        Shift.throwsIfInvalid((profession == null || profession.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        String oldName = profession.getName();
        profession.setName(newName);
        this.checkProfessionIsUsable(profession);
        profession.setSeqNum(seqNum);
        profession.setUpdateTime(new Date());
        super.updateSelective((Object)profession);
        Boolean isChangeName = !StringUtil.equals((String)oldName, (String)newName);
        if (isChangeName.booleanValue()) {
            if (IntegerUtil.equals((Integer)profession.getType(), (Integer)ProfessionTypeEnum.DEGREE.value())) {
                this.classAndGradeService.replaceClassNameByDegreeId(profession.getId(), oldName, newName);
            } else if (IntegerUtil.equals((Integer)profession.getType(), (Integer)ProfessionTypeEnum.DEPARTMENT.value())) {
                this.classAndGradeService.replaceClassNameByDepartmentId(profession.getId(), oldName, newName);
            } else if (IntegerUtil.equals((Integer)profession.getType(), (Integer)ProfessionTypeEnum.PROFESSION.value())) {
                this.classAndGradeService.replaceClassNameByDepartmentId(profession.getId(), oldName, newName);
            }
        }
    }

    public void deleteProfession(String professionId) {
        Profession profession = (Profession)((Object)super.selectById((Object)professionId));
        Shift.throwsIfInvalid((profession == null || profession.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        List classAndGrades = null;
        if (IntegerUtil.equals((Integer)profession.getType(), (Integer)ProfessionTypeEnum.DEGREE.value())) {
            classAndGrades = this.classAndGradeService.selectList(JpaCriteria.builder().eq("degreeId", (Object)professionId));
        } else if (IntegerUtil.equals((Integer)profession.getType(), (Integer)ProfessionTypeEnum.DEPARTMENT.value())) {
            classAndGrades = this.classAndGradeService.selectList(JpaCriteria.builder().eq("departmentId", (Object)professionId));
        } else if (IntegerUtil.equals((Integer)profession.getType(), (Integer)ProfessionTypeEnum.PROFESSION.value())) {
            classAndGrades = this.classAndGradeService.selectList(JpaCriteria.builder().eq("professionId", (Object)professionId));
        }
        Shift.throwsIfInvalid((classAndGrades.size() > 0 ? 1 : 0) != 0, (String)"\u8be5\u9879\u76ee\u4e0b\u5b58\u5728\u73ed\u7ea7\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664");
        List list = super.selectList(JpaCriteria.builder().eq("parentId", (Object)professionId));
        Shift.throwsIfInvalid((list != null && list.size() > 0 ? 1 : 0) != 0, (String)"\u8be5\u9879\u76ee\u5b58\u5728\u5b50\u9879\u76ee\uff0c\u65e0\u6cd5\u5220\u9664");
        super.updateDelete((Object)professionId);
    }

    public Map<String, Profession> getProfessionMap() {
        List list = super.selectList(JpaCriteria.builder().orderBy("type ASC"));
        if (list != null && list.size() > 0) {
            HashMap<String, Profession> resultMap = new HashMap<String, Profession>();
            HashMap<String, String> professionNameMap = new HashMap<String, String>();
            HashMap<String, String> parentIdMap = new HashMap<String, String>();
            for (Profession profession : list) {
                Map<String, Profession> departmentMap;
                if (IntegerUtil.equals((Integer)profession.getType(), (Integer)ProfessionTypeEnum.DEGREE.value())) {
                    profession.setChildMap(new HashMap<String, Profession>());
                    resultMap.put(profession.getName(), profession);
                    professionNameMap.put(profession.getId(), profession.getName());
                    continue;
                }
                if (IntegerUtil.equals((Integer)profession.getType(), (Integer)ProfessionTypeEnum.DEPARTMENT.value())) {
                    String parentName = (String)professionNameMap.get(profession.getParentId());
                    Profession parentProfession = (Profession)((Object)resultMap.get(parentName));
                    if (parentProfession == null) continue;
                    String departmentName = profession.getName();
                    departmentMap = parentProfession.getChildMap();
                    profession.setChildMap(new HashMap<String, Profession>());
                    departmentMap.put(departmentName, profession);
                    professionNameMap.put(profession.getId(), profession.getName());
                    parentIdMap.put(profession.getId(), profession.getParentId());
                    continue;
                }
                if (!IntegerUtil.equals((Integer)profession.getType(), (Integer)ProfessionTypeEnum.PROFESSION.value())) continue;
                String degreeId = (String)parentIdMap.get(profession.getParentId());
                String degreeName = (String)professionNameMap.get(degreeId);
                Profession degree = (Profession)((Object)resultMap.get(degreeName));
                departmentMap = degree.getChildMap();
                String departmentName = (String)professionNameMap.get(profession.getParentId());
                Profession departmentProfession = departmentMap.get(departmentName);
                Map<String, Profession> professionMap = departmentProfession.getChildMap();
                professionMap.put(profession.getName(), profession);
            }
            return resultMap;
        }
        return null;
    }

    public void checkProfessionIsUsable(Profession profession) {
        Profession temp;
        String name = profession.getName();
        Checker.checkBlank((String)name, (String)"\u540d\u79f0");
        Integer type = profession.getType();
        Shift.throwsIfNull((Object)type, (String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Shift.throwsIfInvalid((!ProfessionTypeEnum.isValid(type) ? 1 : 0) != 0, (String)"\u7c7b\u578b\u9519\u8bef");
        String parentId = profession.getParentId();
        if (StringUtil.isNotBlank((String)parentId)) {
            Profession temp2 = (Profession)((Object)super.selectById((Object)parentId));
            Shift.throwsIfInvalid((temp2 == null || temp2.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u76ee\u5f55\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        JpaCriteria jpaCriteria = JpaCriteria.builder().eq("name", (Object)name).eq("type", (Object)type).eq("appId", (Object)this.getAppId()).eq("isDeleted", (Object)false);
        if (StringUtil.isNotBlank((String)profession.getId())) {
            jpaCriteria.ne("id", (Object)profession.getId());
        }
        if (StringUtil.isNotBlank((String)parentId)) {
            jpaCriteria.eq("parentId", (Object)parentId);
        }
        Shift.throwsIfInvalid(((temp = (Profession)((Object)super.select(jpaCriteria))) != null ? 1 : 0) != 0, (String)"\u8be5\u540d\u79f0\u5df2\u5b58\u5728");
    }

    public List<String> checkProfessionIsLegalByImport(String degreeName, String departmentName, String professionName, List<String> errMsgList, Map<String, Profession> professionMap) {
        if (StringUtil.isNotBlank((String)professionName) && StringUtil.isBlank((String)departmentName)) {
            errMsgList.add("\u7cfb\u522b\u4e3a\u7a7a");
        }
        if (StringUtil.isNotBlank((String)departmentName) && StringUtil.isBlank((String)degreeName)) {
            errMsgList.add("\u5b66\u4f4d\u4e3a\u7a7a");
        }
        if (StringUtil.isNotBlank((String)degreeName)) {
            if (!professionMap.containsKey(degreeName)) {
                errMsgList.add("\u5b66\u4f4d [" + degreeName + "] \u4e0e\u540e\u53f0\u914d\u7f6e\u4e0d\u4e00\u81f4");
            } else if (StringUtil.isNotBlank((String)departmentName)) {
                Profession department;
                Map<String, Profession> childMap;
                Profession degree = professionMap.get(degreeName);
                Map<String, Profession> departmentMap = degree.getChildMap();
                if (!departmentMap.containsKey(departmentName)) {
                    errMsgList.add("\u7cfb\u522b [" + departmentName + "] \u4e0e\u540e\u53f0\u914d\u7f6e\u4e0d\u4e00\u81f4");
                } else if (StringUtil.isNotBlank((String)professionName) && !(childMap = (department = departmentMap.get(departmentName)).getChildMap()).containsKey(professionName)) {
                    errMsgList.add("\u4e13\u4e1a [" + professionName + "] \u4e0e\u540e\u53f0\u914d\u7f6e\u4e0d\u4e00\u81f4");
                }
            }
        }
        return errMsgList;
    }
}

