/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.wego168.base.domain.Config;
import com.wego168.base.domain.Content;
import com.wego168.base.service.ConfigService;
import com.wego168.base.service.ContentService;
import com.wego168.coweb.model.response.QiChengVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QiChengAboutService {
    private static final Logger log = LoggerFactory.getLogger(QiChengAboutService.class);
    @Autowired
    private ConfigService configService;
    @Autowired
    private ContentService contentService;

    public QiChengVo get() {
        QiChengVo qiChengVo = new QiChengVo();
        Config qiChengContent = this.configService.selectByKey("qiChengContent", "0");
        Config qiChengPhone = this.configService.selectByKey("qiChengPhone", "0");
        if (null != qiChengContent) {
            String content = ((Content)this.contentService.selectById((Object)qiChengContent.getValue())).getContent();
            qiChengVo.setContent(content);
        }
        if (null != qiChengPhone) {
            qiChengVo.setPhone(qiChengPhone.getValue());
        }
        return qiChengVo;
    }

    @Transactional
    public void saveOrUpdate(QiChengVo vo) {
        this.qichengPhoneSaveOrUpdate(vo.getPhone());
        this.qichengContentSaveOrUpdate(vo.getContent());
    }

    private void qichengContentSaveOrUpdate(String content) {
        Config qiChengContent = this.configService.selectByKey("qiChengContent", "0");
        log.error("qiChengContent{}", (Object)qiChengContent);
        if (null == qiChengContent) {
            Content contentText = this.contentService.create(content, "0");
            this.contentService.insert((Object)contentText);
            Config config = this.configService.create("0", 0, "qiChengContent", "\u4f01\u6210\u4e92\u52a8\u6280\u672f\u4ecb\u7ecd", contentText.getId(), null, 0, null, (short)0, true);
            this.configService.insert((Object)config);
        } else {
            Content existContent = (Content)this.contentService.selectById((Object)qiChengContent.getValue());
            existContent.setContent(content);
            this.contentService.update((Object)existContent);
        }
    }

    private void qichengPhoneSaveOrUpdate(String phone) {
        Config qiChengPhone = this.configService.selectByKey("qiChengPhone", "0");
        if (null == qiChengPhone) {
            Config config = this.configService.create("0", 0, "qiChengPhone", "\u4f01\u6210\u4e92\u52a8\u5ba2\u670d\u7535\u8bdd", phone, null, 0, null, (short)0, true);
            this.configService.insert((Object)config);
        } else {
            qiChengPhone.setValue(phone);
            this.configService.update((Object)qiChengPhone);
        }
    }
}

