/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.service;

import com.simple.mybatis.Page;
import com.wego168.base.domain.Content;
import com.wego168.base.service.ContentService;
import com.wego168.coweb.domain.Welfare;
import com.wego168.coweb.persistence.WelfareMapper;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.web.util.GuidGenerator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WelfareService
extends BaseService<Welfare> {
    @Autowired
    private WelfareMapper welfareMapper;
    @Autowired
    private ContentService contentService;

    public CrudMapper<Welfare> getMapper() {
        return this.welfareMapper;
    }

    @Transactional
    public void inserts(Welfare welfare) {
        Content content = new Content();
        content.setId(GuidGenerator.generate());
        content.setContent(welfare.getContent());
        welfare.setContentId(content.getId());
        super.insert((Object)welfare);
        this.contentService.insert((Object)content);
    }

    @Transactional
    public void updates(Welfare welfare) {
        String content = welfare.getContent();
        Content content2 = new Content();
        if (StringUtils.isNotBlank((CharSequence)welfare.getContentId())) {
            content2.setId(welfare.getContentId());
            content2.setContent(content);
            this.contentService.updateSelective((Object)content2);
        } else {
            content2.setId(GuidGenerator.generate());
            content2.setContent(content);
            this.contentService.insert((Object)content2);
            welfare.setContentId(content2.getId());
        }
        super.updateSelective((Object)welfare);
    }

    public Welfare get(String id) {
        Welfare welfare = (Welfare)((Object)this.welfareMapper.selectById(id));
        if (welfare != null && StringUtils.isNotBlank((CharSequence)welfare.getContentId())) {
            Content content = (Content)this.contentService.selectById((Object)welfare.getContentId());
            welfare.setContent(content.getContent());
        }
        return welfare;
    }

    public List<Welfare> selectWelfarePage(Page page) {
        page.put((Object)"isDeleted", (Object)false);
        return this.welfareMapper.selectWelfarePage(page);
    }
}

