/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.util;

import com.alibaba.fastjson.JSONObject;
import com.wego168.web.util.SpringUtil;
import com.wego168.wechat.impl.WechatAccessTokenHelper;
import com.wego168.wx.domain.WxApp;
import com.wego168.wx.enums.WxAppServiceTypeEnum;
import com.wego168.wx.service.WxAppService;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniProgramUtil {
    private static final Logger log = LoggerFactory.getLogger(MiniProgramUtil.class);
    public static final String WXA_CODE_URL = "https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token=%s";
    private static WechatAccessTokenHelper wechatAccessTokenHelper = (WechatAccessTokenHelper)SpringUtil.getBean(WechatAccessTokenHelper.class);
    private static WxAppService wxAppService = (WxAppService)SpringUtil.getBean(WxAppService.class);

    public static BufferedImage getSmallProgramCode(String appId, String path, String posterId) {
        WxApp wxApp = wxAppService.getCacheByAppId(appId, WxAppServiceTypeEnum.MINI_PROGRAM.value());
        String accessToken = wechatAccessTokenHelper.getToken(wxApp.getWxAppId(), wxApp.getWxAppSecret(), false);
        String requestUrl = String.format(WXA_CODE_URL, accessToken);
        JSONObject paramJson = new JSONObject();
        paramJson.put("scene", (Object)posterId);
        paramJson.put("is_hyaline", (Object)true);
        paramJson.put("page", (Object)path);
        BufferedImage bufferedImage = null;
        try {
            URL url = new URL(requestUrl);
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            PrintWriter printWriter = new PrintWriter(httpURLConnection.getOutputStream());
            printWriter.write(paramJson.toString());
            printWriter.flush();
            bufferedImage = ImageIO.read(httpURLConnection.getInputStream());
            if (bufferedImage == null) {
                String result = IOUtils.toString((InputStream)httpURLConnection.getInputStream(), (Charset)StandardCharsets.UTF_8);
                log.error("\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801\u5931\u8d25{}", (Object)result);
            }
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u5931\u8d25", (Throwable)e);
        }
        return bufferedImage;
    }
}

