/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.util;

import com.wego168.base.advice.FileUploadUtil;
import com.wego168.base.domain.FileServer;
import com.wego168.base.service.FileServerService;
import com.wego168.util.Checker;
import com.wego168.util.SequenceUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.util.SpringUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfUtil {
    private static final Logger logger = LoggerFactory.getLogger(PdfUtil.class);
    private static final FileServerService fileServerService = (FileServerService)SpringUtil.getBean(FileServerService.class);

    public static void main(String[] args) throws IOException {
        List<BufferedImage> bufferedImages = PdfUtil.pdfToImage(new File("D:\\Work\\Wego168\\\u6587\u6863\\\u6c47\u805a\u652f\u4ed8\\\u6c47\u805a\u652f\u4ed8\u626b\u7801\u652f\u4ed8API\u63a5\u53e3\u6587\u6863 V1.82(1).pdf"));
        for (int i = 0; i < bufferedImages.size(); ++i) {
            ImageIO.write((RenderedImage)bufferedImages.get(i), "png", new File("D:\\bb\\" + i + ".png"));
        }
    }

    public static List<BufferedImage> pdfToImage(File file) {
        int index;
        String fileName = file.getName();
        String fileExtension = fileName.substring(index = fileName.lastIndexOf("."), fileName.length());
        if (!StringUtil.equalsIgnoreCase((String)".pdf", (String)fileExtension)) {
            logger.error("\u5f53\u524d\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6->{}", (Object)fileExtension);
            return null;
        }
        LinkedList<BufferedImage> bufferedImages = new LinkedList<BufferedImage>();
        try {
            PDDocument doc = PDDocument.load((File)file);
            PDFRenderer pdfRenderer = new PDFRenderer(doc);
            int pageCount = doc.getNumberOfPages();
            for (int i = 0; i < pageCount; ++i) {
                BufferedImage bufferedImage = pdfRenderer.renderImage(i);
                bufferedImages.add(bufferedImage);
            }
        }
        catch (Exception e) {
            logger.error("pdf\u8f6c\u56fe\u7247\u51fa\u9519", (Throwable)e);
            Shift.throwsIfInvalid((boolean)true, (String)"pdf\u8f6c\u6587\u4ef6\u51fa\u9519");
        }
        return bufferedImages;
    }

    public static List<String> pdfToImageAndUpload(File file) {
        int index;
        String fileName = file.getName();
        String fileExtension = fileName.substring(index = fileName.lastIndexOf("."), fileName.length());
        if (!StringUtil.equalsIgnoreCase((String)".pdf", (String)fileExtension)) {
            logger.error("\u5f53\u524d\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6->{}", (Object)fileExtension);
            return null;
        }
        LinkedList<String> urls = new LinkedList<String>();
        String defaultServerId = "1";
        FileServer server = (FileServer)fileServerService.selectById((Object)defaultServerId);
        Checker.checkCondition((server == null ? 1 : 0) != 0, (String)"\u56fe\u7247\u670d\u52a1\u5668\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u8f6c\u6362\u56fe\u7247");
        String cosBucket = "nameCard";
        try {
            PDDocument doc = PDDocument.load((File)file);
            PDFRenderer pdfRenderer = new PDFRenderer(doc);
            int pageCount = doc.getNumberOfPages();
            for (int i = 0; i < pageCount; ++i) {
                String imageName = SequenceUtil.createUuid() + ".png";
                BufferedImage bufferedImage = pdfRenderer.renderImageWithDPI(0, 300.0f, ImageType.ARGB);
                String url = FileUploadUtil.upload2Cos((BufferedImage)bufferedImage, (String)cosBucket, (String)imageName, (FileServer)server);
                urls.add(url);
            }
        }
        catch (Exception e) {
            logger.error("pdf\u8f6c\u56fe\u7247\u51fa\u9519", (Throwable)e);
            Shift.throwsIfInvalid((boolean)true, (String)"pdf\u8f6c\u6587\u4ef6\u51fa\u9519");
        }
        return urls;
    }
}

