/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.channel.controller.admin;

import com.simple.mybatis.Page;
import com.wego168.channel.domain.Channel;
import com.wego168.channel.domain.ChannelCode;
import com.wego168.channel.model.response.ChannelCodeListForSelect;
import com.wego168.channel.service.ChannelCodeService;
import com.wego168.channel.service.ChannelService;
import com.wego168.exception.WegoException;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;

public abstract class ChannelCodeControllerSupport
extends SimpleController {
    public RestResponse insert(String name, String code, String channelId) {
        try {
            this.checkInsertParam(name, code, channelId);
            Channel channel = (Channel)((Object)this.getChannelService().selectById(channelId));
            Checker.checkCondition((channel == null ? 1 : 0) != 0, (String)"\u8be5\u6e20\u9053\u4e0d\u5b58\u5728");
            String appId = this.getAppId();
            ChannelCode existChannelCode = this.getChannelCodeService().selectByCode(code, appId);
            Checker.checkCondition((existChannelCode != null ? 1 : 0) != 0, (String)("\u8be5\u4ee3\u7801[" + code + "]\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165"));
            this.getChannelCodeService().insert(name, code, channelId);
            return RestResponse.success((String)"\u6dfb\u52a0\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @ConditionalOnMissingBean
    public RestResponse update(String name, String note, boolean cascadeUpdate, String id) {
        this.checkUpdateParam(name, note, id);
        ChannelCodeService service = this.getChannelCodeService();
        if (cascadeUpdate) {
            ChannelCode channelCode = (ChannelCode)((Object)service.selectById(id));
            Checker.checkCondition((channelCode == null ? 1 : 0) != 0, (String)"\u8be5\u5b50\u6e20\u9053\u4e0d\u5b58\u5728");
            String oldName = channelCode.getName();
            if (StringUtil.equals((String)name, (String)oldName)) {
                service.update(name, note, id);
            } else {
                service.cascadeUpdate(name, note, id);
            }
        } else {
            service.update(name, note, id);
        }
        return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    public RestResponse list(String channelId, HttpServletRequest request) {
        Page page = this.buildPage(request);
        page.eq("channelId", (Object)channelId);
        page.eq("isDeleted", (Object)false);
        page.orderBy("code asc");
        List list = this.getChannelCodeService().selectPage(page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    public RestResponse selectPageForSelect(String name, String mobile, String code, String appId, HttpServletRequest request) {
        Page page = this.buildPage(request);
        List<ChannelCodeListForSelect> list = this.getChannelCodeService().selectPageForSelect(appId, name, mobile, code, page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    public RestResponse item(String id) {
        Checker.checkBlank((String)id, (String)"id");
        ChannelCode channelCode = (ChannelCode)((Object)this.getChannelCodeService().selectById(id));
        return RestResponse.success((Object)((Object)channelCode));
    }

    protected abstract ChannelService getChannelService();

    protected abstract ChannelCodeService getChannelCodeService();

    private void checkInsertParam(String name, String code, String channelId) {
        Checker.checkBlankAndLength((String)name, (String)"\u6e20\u9053\u4ee3\u7801\u540d\u79f0", (int)64);
        Checker.checkBlankAndLength((String)code, (String)"\u6e20\u9053\u4ee3\u7801", (int)32);
        Checker.checkBlankAndLength((String)channelId, (String)"\u6e20\u9053\u5546id", (int)32);
    }

    private void checkUpdateParam(String name, String note, String id) {
        Checker.checkBlankAndLength((String)name, (String)"\u6e20\u9053\u4ee3\u7801\u540d\u79f0", (int)64);
        Checker.checkBlankOrLength((String)note, (String)"\u5907\u6ce8", (int)64);
        Checker.checkBlankAndLength((String)id, (String)"\u6e20\u9053id", (int)32);
    }
}

