/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.channel.controller.admin;

import com.simple.mybatis.Page;
import com.wego168.authority.domain.SysAccount;
import com.wego168.authority.enums.SysAccountTypeEnum;
import com.wego168.authority.service.LoginService;
import com.wego168.authority.service.SysAccountService;
import com.wego168.channel.domain.Channel;
import com.wego168.channel.domain.ChannelAccount;
import com.wego168.channel.service.ChannelAccountService;
import com.wego168.channel.service.ChannelService;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public abstract class ChannelControllerSupport
extends SimpleController {
    @Autowired
    private LoginService loginService;
    @Autowired
    private Environment environment;

    public RestResponse insert(String name, String mobile, String channelName, String username, String password, String channelRoleId) {
        String appId = this.getAppId();
        this.checkInsertParam(name, mobile, channelName, username, password);
        ChannelAccountService accountService = this.getChannelAccountService();
        ChannelService service = this.getChannelService();
        SysAccountService sysAccountService = this.getSysAccountService();
        ChannelAccount mobileAccount = accountService.selectByUsername(mobile, appId);
        Checker.checkCondition((mobileAccount != null ? 1 : 0) != 0, (String)("\u6e20\u9053\u5546\u624b\u673a[" + mobile + "]\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165"));
        int accountType = SysAccountTypeEnum.CHANNEL_ACCOUNT.value();
        SysAccount existSysAccount = sysAccountService.selectByUsername(username, accountType, appId);
        Checker.checkCondition((existSysAccount != null ? 1 : 0) != 0, (String)("\u6e20\u9053\u5546\u7528\u6237\u624b\u673a[" + mobile + "]\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165"));
        SysAccount sysAccount = sysAccountService.create(appId, channelName, username, password);
        sysAccount.setType(Integer.valueOf(accountType));
        service.createChannelAndAccount(name, mobile, channelName, channelRoleId, sysAccount);
        return RestResponse.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    public RestResponse update(String name, String channelName, boolean cascadeUpdate, String id) {
        this.checkUpdateParam(name, channelName);
        ChannelService service = this.getChannelService();
        if (cascadeUpdate) {
            Channel channel = (Channel)((Object)service.selectById(id));
            Checker.checkCondition((channel == null ? 1 : 0) != 0, (String)"\u8be5\u6e20\u9053\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            String oldChannelName = channel.getChannelName();
            if (StringUtil.equals((String)channelName, (String)oldChannelName)) {
                service.update(name, channelName, id);
            } else {
                service.cascadeUpdate(name, channelName, id);
            }
        } else {
            service.update(name, channelName, id);
        }
        return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    public RestResponse list(String name, String mobile, HttpServletRequest request) {
        Page page = this.buildPage(request);
        if (StringUtil.isNotBlank((String)name)) {
            page.like("name", (Object)("%" + name + "%"));
        }
        if (StringUtil.isNotBlank((String)mobile)) {
            page.like("mobile", (Object)("%" + mobile + "%"));
        }
        List list = this.getChannelService().selectPage(page);
        if (this.isPhoneDisplay()) {
            this.phoneDisplay(list);
        }
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    public RestResponse item(String id) {
        Checker.checkBlank((String)id, (String)"id");
        Channel channel = (Channel)((Object)this.getChannelService().selectById(id));
        return RestResponse.success((Object)((Object)channel));
    }

    public SysAccount channelLogin(String username, String password, int sysAccountType) {
        SysAccount account = this.loginService.login(username, password, Integer.valueOf(sysAccountType));
        return account;
    }

    protected abstract ChannelService getChannelService();

    protected abstract ChannelAccountService getChannelAccountService();

    protected abstract SysAccountService getSysAccountService();

    private void checkInsertParam(String name, String mobile, String channelName, String username, String password) {
        Checker.checkBlank((String)name, (String)"\u6e20\u9053\u5546\u59d3\u540d");
        Checker.checkMobilePhoneNumber((String)mobile);
        Checker.checkBlank((String)channelName, (String)"\u6e20\u9053\u540d\u79f0");
        Checker.checkBlank((String)username, (String)"\u767b\u5f55\u8d26\u53f7");
        Checker.checkBlank((String)password, (String)"\u767b\u5f55\u5bc6\u7801");
    }

    private void checkUpdateParam(String name, String channelName) {
        Checker.checkBlank((String)name, (String)"\u6e20\u9053\u5546\u59d3\u540d");
        Checker.checkBlank((String)channelName, (String)"\u6e20\u9053\u540d\u79f0");
    }

    private boolean isPhoneDisplay() {
        try {
            String flag = this.environment.getProperty("phoneDisplay");
            return "true".equalsIgnoreCase(flag);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void phoneDisplay(List<Channel> channels) {
        for (Channel channel : channels) {
            if (!StringUtil.isNotBlank((String)channel.getMobile()) || channel.getMobile().length() < 11) continue;
            String phone = channel.getMobile();
            channel.setMobile(String.valueOf(phone.substring(0, 3)) + "****" + phone.substring(7, phone.length()));
        }
    }
}

