/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.channel.controller.admin;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.advice.FileUploadUtil;
import com.wego168.base.domain.FileServer;
import com.wego168.base.domain.MiniProgramPage;
import com.wego168.base.service.FileServerService;
import com.wego168.base.service.MiniProgramPageService;
import com.wego168.base.service.StorableService;
import com.wego168.base.util.FileUtil;
import com.wego168.channel.domain.ChannelCode;
import com.wego168.channel.domain.ChannelQrcode;
import com.wego168.channel.enums.ChannelQrcodeTargetTypeEnum;
import com.wego168.channel.enums.ChannelQrcodeTypeEnum;
import com.wego168.channel.model.response.ChannelCodeListForSelect;
import com.wego168.channel.model.response.ChannelQrcodeAdminListResponse;
import com.wego168.channel.service.ChannelCodeService;
import com.wego168.channel.service.ChannelQrcodeService;
import com.wego168.exception.WegoException;
import com.wego168.util.Checker;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import com.wego168.util.ZipUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import com.wego168.wx.domain.WxApp;
import com.wego168.wx.enums.WxAppServiceTypeEnum;
import com.wego168.wx.service.WxAppService;
import com.wego168.wx.token.SmallProgramUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminChannelQrcodeController")
public class ChannelQrcodeController
extends SimpleController {
    @Autowired
    private WxAppService wxAppService;
    @Autowired
    private FileServerService fileServerService;
    @Autowired
    private StorableService storableService;
    @Autowired
    private ChannelCodeService channelCodeService;
    @Autowired
    private ChannelQrcodeService service;
    @Autowired
    private MiniProgramPageService miniProgramPageService;
    @Autowired
    private Environment env;

    @GetMapping(value={"/api/admin/v1/channel-qrcode/page"})
    public RestResponse selectPage(String targetName, Boolean onlyShowUndefine, Boolean onlyShowUnbind, HttpServletRequest request) {
        Page page = this.buildPage(request);
        onlyShowUndefine = onlyShowUndefine == null ? false : onlyShowUndefine;
        onlyShowUnbind = onlyShowUnbind == null ? false : onlyShowUnbind;
        String appId = this.getAppId();
        List<ChannelQrcodeAdminListResponse> list = this.service.selectPageForAdmin(targetName, onlyShowUndefine, onlyShowUnbind, appId, page);
        this.storableService.assembleHost(list);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @PostMapping(value={"/api/admin/v1/channel-qrcode/insert-batch"})
    public RestResponse insertBatch(@RequestParam(value="quantity") String quantityString, String miniProgramPath, String channelCodeId, String targetId, String targetType, String targetName) {
        try {
            int quantity = Checker.checkStringIsPositiveInteger((String)quantityString, (String)"\u751f\u6210\u6570\u91cf");
            int maxQuantity = 100;
            Checker.checkCondition((quantity > maxQuantity ? 1 : 0) != 0, (String)("\u5355\u6b21\u6700\u5927\u751f\u6210\u6570\u91cf\u4e3a" + maxQuantity));
            miniProgramPath = "pagesCommon/channelTransfer/index";
            String channelId = this.check(channelCodeId, targetId, targetType, targetName, "insert");
            int serviceType = WxAppServiceTypeEnum.MINI_PROGRAM.value();
            String appId = this.getAppId();
            WxApp miniProgram = this.wxAppService.selectByAppId(appId, serviceType);
            Checker.checkCondition((miniProgram == null ? 1 : 0) != 0, (String)"\u5c0f\u7a0b\u5e8f\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801");
            String defaultServerId = "1";
            FileServer server = (FileServer)this.fileServerService.selectById((Object)defaultServerId);
            Checker.checkCondition((server == null ? 1 : 0) != 0, (String)"\u56fe\u7247\u670d\u52a1\u5668\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801");
            String batch = SequenceUtil.createUuid();
            ArrayList<ChannelQrcode> list = new ArrayList<ChannelQrcode>(quantity);
            int index = 0;
            while (index < quantity) {
                String scene = SequenceUtil.createUuid();
                BufferedImage bufferedImage = SmallProgramUtil.createMiniProgramQrcode((WxApp)miniProgram, (String)miniProgramPath, (String)scene);
                String errorMessage = "\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u5c0f\u7a0b\u5e8f[" + miniProgram.getName() + "]\u5c1a\u672a\u901a\u8fc7\u5ba1\u6838\uff0c\u6216\u9875\u9762\u8def\u5f84\u4e0d\u5b58\u5728";
                Checker.checkCondition((bufferedImage == null ? 1 : 0) != 0, (String)errorMessage);
                String fileName = String.valueOf(scene) + ".png";
                String cosBucket = "channel-qrcode/" + appId;
                String url = FileUploadUtil.upload2Cos((BufferedImage)bufferedImage, (String)cosBucket, (String)fileName, (FileServer)server);
                ChannelQrcode qrcode = this.service.createBlankMiniProgramQrcode(batch, scene, url, appId, defaultServerId);
                if (StringUtil.isNotBlank((String)targetType)) {
                    qrcode.setTargetId(targetId);
                    qrcode.setTargetType(targetType);
                    qrcode.setTargetName(targetName);
                }
                if (StringUtil.isNotBlank((String)channelCodeId)) {
                    qrcode.setChannelCodeId(channelCodeId);
                    qrcode.setChannelId(channelId);
                }
                list.add(qrcode);
                ++index;
            }
            this.service.insertBatch(list);
            return RestResponse.success((String)"\u751f\u6210\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/admin/v1/channel-qrcode/bind"})
    public RestResponse bind(@RequestParam(required=false, name="id") String idArrayString, String channelCodeId, String targetId, String targetType, String targetName) {
        try {
            Checker.checkBlank((String)idArrayString, (String)"\u5c0f\u7a0b\u5e8f\u7801");
            Checker.checkBlankOrLength((String)channelCodeId, (String)"\u6e20\u9053", (int)32);
            String channelId = this.check(channelCodeId, targetId, targetType, targetName, "update");
            Object[] idArray = idArrayString.split(",");
            List list = this.service.selectList(JpaCriteria.builder().in("id", idArray));
            Checker.checkCondition((list == null || list.size() != idArray.length ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u5c0f\u7a0b\u5e8f\u7801");
            Date now = new Date();
            for (ChannelQrcode qrcode : list) {
                ChannelQrcode param = new ChannelQrcode();
                param.setId(qrcode.getId());
                if (StringUtil.isNotBlank((String)channelCodeId)) {
                    param.setChannelCodeId(channelCodeId);
                    param.setChannelId(channelId);
                }
                if (StringUtil.isNotBlank((String)targetType)) {
                    param.setTargetId(targetId);
                    param.setTargetType(targetType);
                    param.setTargetName(targetName);
                }
                param.setUpdateTime(now);
                this.service.updateSelective((Object)param);
            }
            return RestResponse.success((String)"\u7ed1\u5b9a\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/admin/v1/channel-qrcode/download"})
    public RestResponse download(@RequestParam(required=false, name="id") String idArrayString) {
        try {
            Checker.checkBlank((String)idArrayString, (String)"\u6e20\u9053\u4e8c\u7ef4\u7801");
            String defaultServerId = "1";
            FileServer server = (FileServer)this.fileServerService.selectById((Object)defaultServerId);
            Checker.checkCondition((server == null ? 1 : 0) != 0, (String)"\u56fe\u7247\u670d\u52a1\u5668\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801");
            Object[] idArray = idArrayString.split(",");
            List list = this.service.selectList(JpaCriteria.builder().in("id", idArray));
            Checker.checkCondition((list == null || list.size() == 0 ? 1 : 0) != 0, (String)"\u8bf7\u5148\u9009\u62e9\u8981\u4e0b\u8f7d\u7684\u4e8c\u7ef4\u7801");
            String zipDownloadUrl = this.zipAndUploadQrcodeList(list, server);
            Bootmap response = new Bootmap();
            response.put((Object)"zipDownloadUrl", (Object)zipDownloadUrl);
            return RestResponse.success((Object)response, (String)"\u751f\u6210\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/admin/v1/activity-channel-qrcode/download-activity-mini-program"})
    public RestResponse insert(@RequestParam(required=false, name="channelCodeId") String channelCodeIdArrayString, String miniProgramPath, String activityId) {
        try {
            Checker.checkBlankAndLength((String)activityId, (String)"\u6d3b\u52a8", (int)32);
            Checker.checkBlank((String)channelCodeIdArrayString, (String)"\u6e20\u9053");
            String[] channelCodeIdArray = channelCodeIdArrayString.split(",");
            if (StringUtil.isBlank((String)miniProgramPath)) {
                String defaultMiniProgramPath;
                miniProgramPath = defaultMiniProgramPath = "pagesCoWebs/activity/detail/index";
            }
            int serviceType = WxAppServiceTypeEnum.MINI_PROGRAM.value();
            String appId = this.getAppId();
            WxApp miniProgram = this.wxAppService.selectByAppId(appId, serviceType);
            Checker.checkCondition((miniProgram == null ? 1 : 0) != 0, (String)"\u5c0f\u7a0b\u5e8f\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801");
            String defaultServerId = "1";
            FileServer server = (FileServer)this.fileServerService.selectById((Object)defaultServerId);
            Checker.checkCondition((server == null ? 1 : 0) != 0, (String)"\u56fe\u7247\u670d\u52a1\u5668\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801");
            Map<String, ChannelCodeListForSelect> channelCodeResponseMap = this.channelCodeService.selectResponseMap(channelCodeIdArray);
            Checker.checkCondition((channelCodeResponseMap.size() != channelCodeIdArray.length ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u6e20\u9053");
            Map<String, ChannelQrcode> qrcodeMap = this.service.selectMap(activityId, channelCodeIdArray);
            String type = ChannelQrcodeTypeEnum.MINI_PROGRAM.value();
            String batch = SequenceUtil.createUuid();
            String[] stringArray = channelCodeIdArray;
            int n = channelCodeIdArray.length;
            int n2 = 0;
            while (n2 < n) {
                String channelCodeId = stringArray[n2];
                ChannelCodeListForSelect channelCode = channelCodeResponseMap.get(channelCodeId);
                String channelQrcodeKey = String.valueOf(channelCodeId) + "-" + type + "-" + activityId;
                ChannelQrcode qrcode = qrcodeMap.get(channelQrcodeKey);
                if (qrcode == null) {
                    int maxSceneLength = 32;
                    String scenePrefix = "act-channelcode-";
                    int randomSequenceLength = maxSceneLength - scenePrefix.length();
                    String scene = String.valueOf(scenePrefix) + SequenceUtil.createRandomLetterAndNumberSequence((int)randomSequenceLength, null);
                    BufferedImage bufferedImage = SmallProgramUtil.createMiniProgramQrcode((WxApp)miniProgram, (String)miniProgramPath, (String)scene);
                    String errorMessage = "\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u5c0f\u7a0b\u5e8f[" + miniProgram.getName() + "]\u5c1a\u672a\u901a\u8fc7\u5ba1\u6838\uff0c\u6216\u9875\u9762\u8def\u5f84\u4e0d\u5b58\u5728";
                    Checker.checkCondition((bufferedImage == null ? 1 : 0) != 0, (String)errorMessage);
                    String fileName = String.valueOf(SequenceUtil.createUuid()) + ".png";
                    String cosBucket = "activity-channel-qrcode/" + appId;
                    String url = FileUploadUtil.upload2Cos((BufferedImage)bufferedImage, (String)cosBucket, (String)fileName, (FileServer)server);
                    qrcode = this.service.createActivityMiniProgramQrcode(url, defaultServerId, channelCodeId, activityId, appId, batch, scene);
                    this.service.insertAsync(qrcode);
                    this.service.setActivityChannelCodeCache(scene, activityId, channelCode.getChannelCode());
                    qrcodeMap.put(channelQrcodeKey, qrcode);
                }
                ++n2;
            }
            String zipDownloadUrl = this.zipAndUploadQrcodeMap(qrcodeMap, channelCodeResponseMap, server, batch);
            Bootmap response = new Bootmap();
            response.put((Object)"zipDownloadUrl", (Object)zipDownloadUrl);
            return RestResponse.success((Object)response, (String)"\u751f\u6210\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    private String check(String channelCodeId, String targetId, String targetType, String targetName, String method) {
        boolean hasTarget;
        Checker.checkBlankOrLength((String)channelCodeId, (String)"\u6e20\u9053", (int)32);
        String channelId = null;
        boolean hasChannel = false;
        if (StringUtil.isNotBlank((String)channelCodeId)) {
            hasChannel = true;
            ChannelCode channelCode = (ChannelCode)((Object)this.channelCodeService.selectById(channelCodeId));
            Checker.checkCondition((channelCode == null ? 1 : 0) != 0, (String)"\u8be5\u6e20\u9053\u4e0d\u5b58\u5728");
            channelId = channelCode.getChannelId();
        }
        if (StringUtil.isNotBlank((String)targetType)) {
            Checker.checkBlankAndLength((String)targetId, (String)"\u5c0f\u7a0b\u5e8f\u7801\u8df3\u8f6c\u76ee\u6807", (int)32);
            Checker.checkBlankAndLength((String)targetName, (String)"\u5c0f\u7a0b\u5e8f\u7801\u8df3\u8f6c\u76ee\u6807", (int)128);
            Checker.checkCondition((!ChannelQrcodeTargetTypeEnum.isValid(targetType) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u7c7b\u578b");
            if (!StringUtil.equals((String)targetType, (String)ChannelQrcodeTargetTypeEnum.ACTIVITY.value()) && StringUtil.equals((String)targetType, (String)ChannelQrcodeTargetTypeEnum.MINI_PROGRAM_PAGE.value())) {
                MiniProgramPage miniProgramPage = (MiniProgramPage)this.miniProgramPageService.selectById((Object)targetId);
                Checker.checkCondition((miniProgramPage == null ? 1 : 0) != 0, (String)"\u8be5\u5c0f\u7a0b\u5e8f\u9875\u9762\u4e0d\u5b58\u5728");
            }
        }
        boolean bl = hasTarget = StringUtil.isNotBlank((String)targetType) && StringUtil.isNotBlank((String)targetId);
        if (StringUtil.equals((String)method, (String)"update")) {
            Checker.checkCondition((!hasChannel && !hasTarget ? 1 : 0) != 0, (String)"\u8bf7\u5148\u9009\u62e9\u6e20\u9053\u6216\u76ee\u6807");
        }
        return channelId;
    }

    private String zipAndUploadQrcodeList(List<ChannelQrcode> list, FileServer server) {
        String fileName;
        String host = server.getHost();
        String cdn = server.getCdn();
        if (StringUtil.isNotBlank((String)cdn)) {
            host = cdn;
        }
        String batch = SequenceUtil.createUuid();
        String filePath = this.determineTempFilePath(batch);
        for (ChannelQrcode qrcode : list) {
            fileName = String.valueOf(qrcode.getCode()) + ".png";
            String qrocdeDownloadUrl = String.valueOf(host) + qrcode.getUrl();
            FileUtil.downloadFile((String)qrocdeDownloadUrl, (String)fileName, (String)filePath);
        }
        File dir = new File(filePath);
        File zip = new File(String.valueOf(filePath) + ".zip");
        ZipUtil.doCompress((File)dir, (File)zip);
        fileName = String.valueOf(batch) + ".zip";
        String cosBucket = "channel-qrcode-zip";
        String zipUrl = FileUploadUtil.upload2Cos((File)zip, (String)cosBucket, (String)fileName, (FileServer)server);
        this.deleteTempFileAsync(dir, zip);
        String zipDownloadUrl = String.valueOf(host) + zipUrl;
        return zipDownloadUrl;
    }

    private String zipAndUploadQrcodeMap(Map<String, ChannelQrcode> qrcodeMap, Map<String, ChannelCodeListForSelect> channelCodeResponseMap, FileServer server, String batch) {
        String host = server.getHost();
        String cdn = server.getCdn();
        if (StringUtil.isNotBlank((String)cdn)) {
            host = cdn;
        }
        String filePath = this.determineTempFilePath(batch);
        for (Map.Entry<String, ChannelQrcode> entry : qrcodeMap.entrySet()) {
            ChannelQrcode qrcode = entry.getValue();
            String channelCodeId = qrcode.getChannelCodeId();
            ChannelCodeListForSelect channelCode = channelCodeResponseMap.get(channelCodeId);
            String channelName = channelCode.getChannelName();
            String subChannelName = channelCode.getChannelCodeName();
            String fileName = String.valueOf(channelName) + ".png";
            if (StringUtil.isNotBlank((String)subChannelName)) {
                fileName = String.valueOf(channelName) + "-" + subChannelName + ".png";
            }
            String qrocdeDownloadUrl = String.valueOf(host) + qrcode.getUrl();
            FileUtil.downloadFile((String)qrocdeDownloadUrl, (String)fileName, (String)filePath);
        }
        File dir = new File(filePath);
        File zip = new File(String.valueOf(filePath) + ".zip");
        ZipUtil.doCompress((File)dir, (File)zip);
        String fileName = String.valueOf(batch) + ".zip";
        String cosBucket = "activity-channel-qrcode-zip";
        String zipUrl = FileUploadUtil.upload2Cos((File)zip, (String)cosBucket, (String)fileName, (FileServer)server);
        this.deleteTempFileAsync(dir, zip);
        String zipDownloadUrl = String.valueOf(host) + zipUrl;
        return zipDownloadUrl;
    }

    private String determineTempFilePath(String batch) {
        File dir;
        String operationSystem = this.env.getProperty("os.name");
        String filePath = null;
        if (operationSystem.contains("Linux")) {
            filePath = "/data/" + batch;
        }
        if (!(dir = new File(filePath = "D:/" + batch)).exists()) {
            dir.mkdirs();
        }
        return filePath;
    }

    @Async
    private void deleteTempFileAsync(File dir, File zip) {
        File[] tmpFileList;
        zip.delete();
        File[] fileArray = tmpFileList = dir.listFiles();
        int n = tmpFileList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
        dir.delete();
    }
}

