/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.channel.controller.web;

import com.wego168.base.domain.Storable;
import com.wego168.base.service.StorableService;
import com.wego168.channel.domain.ChannelQrcode;
import com.wego168.channel.model.response.ChannelQrcodeWebResponse;
import com.wego168.channel.service.ChannelQrcodeService;
import com.wego168.exception.WegoException;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="webChannelQrcodeController")
public class ChannelQrcodeController
extends SimpleController {
    @Autowired
    private StorableService storableService;
    @Autowired
    private ChannelQrcodeService service;

    @GetMapping(value={"/api/v1/channel-qrcode/get"})
    public RestResponse get(String id, String scene) {
        try {
            Checker.checkBlankOrLength((String)id, (String)"\u4e8c\u7ef4\u7801id", (int)32);
            Checker.checkBlankOrLength((String)scene, (String)"\u4e8c\u7ef4\u7801\u573a\u666f\u503c", (int)32);
            Checker.checkCondition((StringUtil.isBlank((String)id) && StringUtil.isBlank((String)scene) ? 1 : 0) != 0, (String)"\u7f3a\u5c11\u53c2\u6570");
            ChannelQrcode qrcodeDb = null;
            if (StringUtil.isNotBlank((String)id)) {
                qrcodeDb = (ChannelQrcode)((Object)this.service.selectById(id));
            } else {
                String appId = this.getAppId();
                qrcodeDb = this.service.selectByScene(scene, appId);
            }
            Checker.checkCondition((qrcodeDb == null ? 1 : 0) != 0, (String)"\u8be5\u4e8c\u7ef4\u7801\u4e0d\u5b58\u5728");
            this.storableService.assembleHost((Storable)qrcodeDb);
            return RestResponse.success((Object)new ChannelQrcodeWebResponse(qrcodeDb), (String)"ok");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }
}

