/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.channel.filter;

import com.wego168.base.filter.FilterIgnores;
import com.wego168.member.util.SessionUtil;
import com.wego168.util.RequestUtil;
import com.wego168.util.StringUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChannelFilter
implements Filter {
    private Logger logger = LoggerFactory.getLogger(ChannelFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)resp;
        HttpServletRequest request = (HttpServletRequest)req;
        if (FilterIgnores.isStaticResource((HttpServletRequest)request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String channel = request.getParameter("ch");
        if (StringUtil.equals((String)channel, (String)"1")) {
            this.logger.info("\u6e20\u9053\u94fe\u63a5\uff1a" + RequestUtil.getCurrentUrl((HttpServletRequest)request));
            String channelCode = request.getParameter("chc");
            String memberId = SessionUtil.getMemberId((HttpServletRequest)request);
            this.logger.info("\u6e20\u9053\u4ee3\u7801\uff1a" + channelCode + ",\u6e20\u9053\u4e0b\u7ea7\uff1a" + memberId);
            if (StringUtil.isNotBlank((String)channelCode) && StringUtil.isNotBlank((String)memberId) && !StringUtil.equals((String)channelCode, (String)memberId)) {
                this.createChannelRelationship(channelCode, memberId);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }

    protected abstract void createChannelRelationship(String var1, String var2);
}

