/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.channel.service;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.domain.Sign;
import com.wego168.base.persistence.SignMapper;
import com.wego168.channel.domain.ChannelCode;
import com.wego168.channel.model.response.ChannelCodeListForSelect;
import com.wego168.channel.persistence.ChannelCodeMapper;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.CrudService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.StringUtil;
import com.wego168.web.AuthenticationUser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ChannelCodeService
extends CrudService<ChannelCode> {
    @Autowired
    private ChannelCodeMapper channelCodeMapper;
    @Autowired
    private SignMapper signMapper;
    @Autowired
    private AuthenticationUser authenticationUser;

    public CrudMapper<ChannelCode> getMapper() {
        return this.channelCodeMapper;
    }

    public ChannelCode create(String name, String code, String channelId) {
        ChannelCode channelCode = new ChannelCode();
        BaseDomainUtil.initBaseDomain((BaseDomain)channelCode, (AuthenticationUser)this.authenticationUser);
        channelCode.setChannelId(channelId);
        channelCode.setCode(code);
        channelCode.setName(name);
        return channelCode;
    }

    public void insert(String name, String code, String channelId) {
        ChannelCode channelCode = this.create(name, code, channelId);
        this.channelCodeMapper.insert((Object)channelCode);
    }

    public void update(String name, String note, String id) {
        ChannelCode channelCode = new ChannelCode();
        channelCode.setName(name);
        channelCode.setNote(note);
        channelCode.setId(id);
        this.channelCodeMapper.updateSelective((Object)channelCode);
    }

    public void cascadeUpdate(String name, String note, String id) {
        this.update(name, note, id);
        this.updateSignSubChannelAsync(id, name);
    }

    public ChannelCode selectByCode(String code) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("code", (Object)code);
        criteria.eq("isDeleted", (Object)false);
        return (ChannelCode)((Object)this.channelCodeMapper.select(criteria));
    }

    public ChannelCode selectByCode(String code, String appId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("code", (Object)code);
        criteria.eq("appId", (Object)appId);
        criteria.eq("isDeleted", (Object)false);
        return (ChannelCode)((Object)this.channelCodeMapper.select(criteria));
    }

    public ChannelCode selectByMemberId(String memberId) {
        return this.channelCodeMapper.selectByMemberId(memberId);
    }

    public List<ChannelCodeListForSelect> selectPageForSelect(String appId, String name, String mobile, String code, Page page) {
        page.put((Object)"appId", (Object)appId);
        if (StringUtil.isNotBlank((String)name)) {
            page.put((Object)"name", (Object)("%" + name + "%"));
        }
        if (StringUtil.isNotBlank((String)mobile)) {
            page.put((Object)"mobile", (Object)("%" + mobile + "%"));
        }
        if (StringUtil.isNotBlank((String)code)) {
            page.put((Object)"code", (Object)("%" + code + "%"));
        }
        return this.channelCodeMapper.selectPageForSelect(page);
    }

    public Map<String, ChannelCodeListForSelect> selectResponseMap(String[] channelCodeIdArray) {
        HashMap<String, ChannelCodeListForSelect> map = new HashMap<String, ChannelCodeListForSelect>();
        List<ChannelCodeListForSelect> list = this.channelCodeMapper.selectListByIdArray(channelCodeIdArray);
        if (list != null && list.size() > 0) {
            for (ChannelCodeListForSelect channelCodeListForSelect : list) {
                String channelCodeId = channelCodeListForSelect.getId();
                map.put(channelCodeId, channelCodeListForSelect);
            }
        }
        return map;
    }

    @Async
    private void updateSignSubChannelAsync(String id, String channelCodeName) {
        Sign param = new Sign();
        param.setSubChannel(channelCodeName);
        JpaCriteria criteria = JpaCriteria.builder((Object)param);
        criteria.eq("channelCodeId", (Object)id);
        this.signMapper.updateSelective((Object)criteria);
    }
}

