/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.channel.service;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.channel.domain.ChannelQrcode;
import com.wego168.channel.enums.ChannelQrcodeTargetTypeEnum;
import com.wego168.channel.enums.ChannelQrcodeTypeEnum;
import com.wego168.channel.model.response.ChannelQrcodeAdminListResponse;
import com.wego168.channel.persistence.ChannelQrcodeMapper;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.service.BaseService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ChannelQrcodeService
extends BaseService<ChannelQrcode> {
    @Autowired
    private ChannelQrcodeMapper mapper;
    @Autowired
    private SimpleRedisTemplate redisTemplate;

    public CrudMapper<ChannelQrcode> getMapper() {
        return this.mapper;
    }

    public ChannelQrcode createBlankMiniProgramQrcode(String batch, String scene, String url, String appId, String serverId) {
        ChannelQrcode qrcode = new ChannelQrcode();
        BaseDomainUtil.initBaseDomain((BaseDomain)qrcode, (String)appId);
        qrcode.setChannelCodeId(ChannelQrcodeTargetTypeEnum.UNDEFINE.value());
        qrcode.setChannelId(ChannelQrcodeTargetTypeEnum.UNDEFINE.value());
        qrcode.setRemark(batch);
        qrcode.setScene(scene);
        qrcode.setServerId(serverId);
        qrcode.setTargetId(ChannelQrcodeTargetTypeEnum.UNDEFINE.value());
        qrcode.setTargetType(ChannelQrcodeTargetTypeEnum.UNDEFINE.value());
        qrcode.setType(ChannelQrcodeTypeEnum.MINI_PROGRAM.value());
        qrcode.setUrl(url);
        qrcode.setCode(SequenceUtil.createRandomLowerCaseLetterAndNumberSequence((int)8));
        return qrcode;
    }

    public ChannelQrcode createActivityMiniProgramQrcode(String url, String serverId, String channelCodeId, String activityId, String appId, String batch, String scene) {
        ChannelQrcode qrcode = new ChannelQrcode();
        BaseDomainUtil.initBaseDomain((BaseDomain)qrcode, (String)appId);
        qrcode.setChannelCodeId(channelCodeId);
        qrcode.setRemark(batch);
        qrcode.setScene(scene);
        qrcode.setServerId(serverId);
        qrcode.setTargetId(activityId);
        qrcode.setTargetType(ChannelQrcodeTargetTypeEnum.ACTIVITY.value());
        qrcode.setType(ChannelQrcodeTypeEnum.MINI_PROGRAM.value());
        qrcode.setUrl(url);
        return qrcode;
    }

    public ChannelQrcode selectByScene(String scene, String appId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("scene", (Object)scene);
        criteria.eq("appId", (Object)appId);
        return (ChannelQrcode)((Object)this.mapper.select(criteria));
    }

    public Map<String, ChannelQrcode> selectMap(String targetId, String[] channelCodeIdArray) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("targetId", (Object)targetId);
        criteria.in("channelCodeId", (Object[])channelCodeIdArray);
        List list = this.mapper.selectList(criteria);
        HashMap<String, ChannelQrcode> map = new HashMap<String, ChannelQrcode>();
        if (list != null && list.size() > 0) {
            for (ChannelQrcode qrcode : list) {
                map.put(String.valueOf(qrcode.getChannelCodeId()) + "-" + qrcode.getType() + "-" + targetId, qrcode);
            }
        }
        return map;
    }

    @Async
    public void insertAsync(ChannelQrcode qrcode) {
        this.mapper.insert((Object)qrcode);
    }

    public void setActivityChannelCodeCache(String scene, String activityId, String channelCode) {
        this.redisTemplate.setString(scene, String.valueOf(activityId) + "-" + channelCode);
    }

    public String getActivityIdFromCache(String scene) {
        String cache = this.redisTemplate.getString(scene);
        if (StringUtil.isNotBlank((String)cache) && cache.contains("-")) {
            return cache.split("-")[0];
        }
        return null;
    }

    public String getChannelCodeFromCache(String scene) {
        String cache = this.redisTemplate.getString(scene);
        if (StringUtil.isNotBlank((String)cache) && cache.contains("-")) {
            return cache.split("-")[1];
        }
        return null;
    }

    public List<ChannelQrcodeAdminListResponse> selectPageForAdmin(String targetName, boolean onlyShowUndefine, boolean onlyShowUnbind, String appId, Page page) {
        if (StringUtil.isNotBlank((String)targetName)) {
            page.put((Object)"targetName", (Object)("%" + targetName + "%"));
        }
        if (onlyShowUndefine) {
            page.put((Object)"targetType", (Object)ChannelQrcodeTargetTypeEnum.UNDEFINE.value());
        }
        if (onlyShowUnbind) {
            page.put((Object)"channelCodeId", (Object)ChannelQrcodeTargetTypeEnum.UNDEFINE.value());
        }
        page.put((Object)"appId", (Object)appId);
        return this.mapper.selectPageForAdmin(page);
    }
}

