/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.channel.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.authority.domain.SysAccount;
import com.wego168.authority.domain.SysAccountRole;
import com.wego168.authority.persistence.SysAccountMapper;
import com.wego168.authority.persistence.SysAccountRoleMapper;
import com.wego168.base.domain.Sign;
import com.wego168.base.persistence.SignMapper;
import com.wego168.channel.domain.Channel;
import com.wego168.channel.domain.ChannelAccount;
import com.wego168.channel.domain.ChannelCode;
import com.wego168.channel.persistence.ChannelAccountMapper;
import com.wego168.channel.persistence.ChannelMapper;
import com.wego168.channel.service.ChannelCodeService;
import com.wego168.domain.BaseDomain;
import com.wego168.member.enums.AccountBindStatusEnum;
import com.wego168.member.enums.AccountTypeEnum;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.SequenceUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChannelService
extends BaseService<Channel> {
    @Autowired
    private ChannelCodeService channelCodeService;
    @Autowired
    private ChannelMapper channelMapper;
    @Autowired
    private ChannelAccountMapper channelAccountMapper;
    @Autowired
    private SysAccountMapper sysAccountMapper;
    @Autowired
    private SysAccountRoleMapper sysAccountRoleMapper;
    @Autowired
    private SignMapper signMapper;

    public CrudMapper<Channel> getMapper() {
        return this.channelMapper;
    }

    private Channel create(String name, String mobile, String channelName, String appId) {
        Channel channel = new Channel();
        BaseDomainUtil.initBaseDomain((BaseDomain)channel);
        channel.setAppId(appId);
        channel.setChannelName(channelName);
        channel.setMobile(mobile);
        channel.setName(name);
        return channel;
    }

    private ChannelAccount createAccount(String mobile, String channelId, String appId) {
        ChannelAccount mobileAccount = new ChannelAccount();
        BaseDomainUtil.initBaseDomain((BaseDomain)mobileAccount);
        mobileAccount.setAppId(appId);
        mobileAccount.setBindStatus(AccountBindStatusEnum.UNBIND.value());
        mobileAccount.setChannelId(channelId);
        mobileAccount.setPassword("123456");
        mobileAccount.setType(AccountTypeEnum.MOBILE.value());
        mobileAccount.setUsername(mobile);
        return mobileAccount;
    }

    @Transactional
    public void createChannelAndAccount(String name, String mobile, String channelName, String channelRoleId, SysAccount sysAccount) {
        String appId = sysAccount.getAppId();
        Channel channel = this.create(name, mobile, channelName, appId);
        ChannelAccount mobileAccount = this.createAccount(mobile, channel.getId(), appId);
        this.channelAccountMapper.insert((Object)mobileAccount);
        this.channelMapper.insert((Object)channel);
        sysAccount.setUserId(channel.getId());
        this.sysAccountMapper.insert((Object)sysAccount);
        SysAccountRole sysAccountRole = new SysAccountRole();
        sysAccountRole.setAccountId(sysAccount.getId());
        sysAccountRole.setRoleId(channelRoleId);
        this.sysAccountRoleMapper.insert((Object)sysAccountRole);
        String code = SequenceUtil.createUuid();
        ChannelCode channelCode = this.channelCodeService.create(String.valueOf(channelName) + "-\u9ed8\u8ba4\u6e20\u9053", code, channel.getId());
        this.channelCodeService.insert((Object)channelCode);
    }

    public void update(String name, String channelName, String id) {
        Channel channel = new Channel();
        channel.setName(name);
        channel.setChannelName(channelName);
        channel.setId(id);
        this.channelMapper.updateSelective((Object)channel);
    }

    public void cascadeUpdate(String name, String channelName, String id) {
        this.update(name, channelName, id);
        this.updateSignChannelAsync(id, channelName);
    }

    public int countByAppId(String appId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("appId", (Object)appId);
        criteria.eq("isDeleted", (Object)false);
        return this.channelMapper.selectCount(criteria);
    }

    @Async
    private void updateSignChannelAsync(String channelId, String channelName) {
        Sign param = new Sign();
        param.setChannel(channelName);
        JpaCriteria criteria = JpaCriteria.builder((Object)param);
        criteria.eq("channelId", (Object)channelId);
        this.signMapper.updateSelective((Object)criteria);
    }
}

