/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.channel.task;

import com.wego168.channel.domain.ChannelChain;
import com.wego168.channel.domain.ChannelCode;
import com.wego168.channel.domain.ChannelLink;
import com.wego168.channel.service.ChannelChainService;
import com.wego168.channel.service.ChannelCodeService;
import com.wego168.channel.service.ChannelLinkService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ChannelTask {
    @Autowired
    private ChannelCodeService channelCodeService;
    @Autowired
    private ChannelChainService channelChainService;
    @Autowired
    private ChannelLinkService channelLinkService;

    @Async
    public void createChannelRelationship(String code, String memberId) {
        ChannelChain channelChain;
        ChannelCode channelCode = this.channelCodeService.selectByCode(code);
        if (channelCode == null) {
            return;
        }
        String channelId = channelCode.getChannelId();
        ChannelLink channelLink = this.channelLinkService.select(memberId, channelId, code);
        if (channelLink == null) {
            channelLink = ChannelLinkService.create(memberId, channelId, code);
            this.channelLinkService.insert(channelLink);
        }
        if ((channelChain = this.channelChainService.select(memberId, channelId)) == null) {
            channelChain = this.channelChainService.create(memberId, channelId, channelCode.getCode(), 1);
            this.channelChainService.insert(channelChain);
        }
    }
}

