/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.component;

import com.simple.mybatis.JpaCriteria;
import com.wego168.base.component.ActivitySignPaySubscriber;
import com.wego168.base.service.AppAbilityService;
import com.wego168.distribute.component.GiveDistributeCommissionComponent;
import com.wego168.distribute.component.GiveDistributePointComponent;
import com.wego168.distribute.enums.DistributerCommissionOrderTypeEnum;
import com.wego168.distribute.service.impl.DistributeOpenIdChainService;
import com.wego168.distribute.service.impl.DistributerCommissionService;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.domain.points.PointsFlow;
import com.wego168.member.enums.PointsBusinessTypeEnum;
import com.wego168.member.enums.PointsTypeEnum;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.points.PointsFlowService;
import com.wego168.share.domain.ShareOpenIdChain;
import com.wego168.share.service.ShareOpenIdChainService;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ActivityCommissionHandler
implements ActivitySignPaySubscriber {
    @Autowired
    private ShareOpenIdChainService shareOpenIdChainService;
    @Autowired
    private DistributeOpenIdChainService distributeOpenIdChainService;
    @Autowired
    private DistributerCommissionService distributerCommissionService;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private AppAbilityService appAbilityService;
    @Autowired
    private PointsFlowService pointsFlowService;
    @Autowired
    private GiveDistributePointComponent giveDistributePointComponent;
    @Autowired
    private GiveDistributeCommissionComponent giveDistributeCommissionComponent;
    private Logger logger = LoggerFactory.getLogger(ActivityCommissionHandler.class);

    @Async
    public void subscribeActivitySignPay(Integer payAmount, Integer activityAmount, Integer distributerCommissionAmount, Integer sharerCommissionAmount, int point, Boolean commissionNeedAudit, String activityTitle, String activityImage, String memberId, String signId, String appId) {
        this.logger.error("\u53d1\u653e\u6d3b\u52a8\u63a8\u5e7f\u4f63\u91d1\u3001\u9500\u552e\u4f63\u91d1\u548c\u63a8\u5e7f\u79ef\u5206");
        boolean open = this.appAbilityService.isOpen(appId, "share-activity");
        if (!open) {
            this.logger.error("app[{}]\u672a\u5f00\u542f\u63a8\u5e7f\u6d3b\u52a8\u529f\u80fd", (Object)appId);
            return;
        }
        commissionNeedAudit = commissionNeedAudit == null ? false : commissionNeedAudit;
        String openId = this.getOpenIdByMemberId(memberId);
        String distributerOpenId = this.distributeOpenIdChainService.getRealUpperOpenId(openId);
        List<ShareOpenIdChain> sharerOpenIdChainList = this.shareOpenIdChainService.listUpperChainsExcludeSystemVirtualChain(openId);
        if (distributerCommissionAmount != null) {
            this.giveDistributerCommission(distributerOpenId, appId, distributerCommissionAmount, activityAmount, memberId, openId, signId, activityTitle, activityImage, commissionNeedAudit);
        }
        if (sharerCommissionAmount != null) {
            this.giveSharerCommission(distributerOpenId, sharerOpenIdChainList, appId, appId, sharerCommissionAmount, activityAmount, "", memberId, openId, signId, activityTitle, activityImage, commissionNeedAudit);
        }
        if (point >= 0) {
            this.giveSharerPoint(sharerOpenIdChainList, appId, point, signId, activityTitle);
        } else {
            this.logger.error("\u62a5\u540d\u8bb0\u5f55[{}]\u672a\u4ea7\u751f\u63a8\u5e7f\u79ef\u5206\uff0c\u56e0\u4e3a\u63a8\u5e7f\u79ef\u5206\u5c1a\u672a\u8bbe\u7f6e", (Object)signId);
        }
    }

    @Async
    public void subscribeActivitySignRefund(String signId, String activityTitle, String memberId, String appId) {
        String note = "\u6d3b\u52a8\u62a5\u540d\u53d6\u6d88";
        if (StringUtil.isNotBlank((String)activityTitle)) {
            note = String.valueOf(activityTitle) + "\u6d3b\u52a8\u62a5\u540d\u53d6\u6d88";
        }
        this.distributerCommissionService.cancelCommissionByOrderId(signId, note);
        String businessId = signId;
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("businessId", (Object)businessId);
        criteria.eq("businessType", (Object)PointsBusinessTypeEnum.INVITE_ACTIVITY_SIGN.value());
        criteria.eq("appId", (Object)appId);
        criteria.eq("type", (Object)PointsTypeEnum.INCOME.value());
        criteria.orderBy("createTime DESC");
        List list = this.pointsFlowService.selectList(criteria);
        if (Checker.listIsEmpty((List)list)) {
            return;
        }
        this.logger.error("\u53d6\u6d88\u6d3b\u52a8\u62a5\u540d\uff0c\u56de\u6536\u9080\u8bf7\u79ef\u5206");
        for (PointsFlow pointsFlow : list) {
            String detail = pointsFlow.getDetail();
            int points = -pointsFlow.getAmount().intValue();
            String type = PointsTypeEnum.DEDUCT.value();
            String userId = pointsFlow.getUserId();
            String businessType = PointsBusinessTypeEnum.INVITE_ACTIVITY_SIGN.value();
            PointsFlow signPointsDeductFlow = this.pointsFlowService.build(userId, points, detail, type, businessId, businessType, appId);
            this.pointsFlowService.consume(new PointsFlow[]{signPointsDeductFlow});
        }
    }

    private void giveDistributerCommission(String distributerOpenId, String appId, int distributerCommission, int orderAmount, String orderBuyer, String orderBuyerOpenId, String orderId, String orderTitle, String orderUrl, boolean needAudit) {
        String distributerCommissionOrderType = DistributerCommissionOrderTypeEnum.ACTIVITY_SIGN.value();
        this.giveDistributeCommissionComponent.giveDistributerCommission(distributerOpenId, appId, distributerCommission, orderAmount, orderBuyer, orderBuyerOpenId, orderId, orderTitle, orderUrl, needAudit, distributerCommissionOrderType);
    }

    private void giveSharerCommission(String distributerOpenId, List<ShareOpenIdChain> sharerOpenIdChainList, String appId, String storeId, int sharerCommission, int orderAmount, String orderBuyer, String orderBuyerOpenId, String orderId, String orderTitle, String orderNo, String orderUrl, boolean needAudit) {
        String distributerCommissionOrderType = DistributerCommissionOrderTypeEnum.ACTIVITY_SIGN.value();
        this.giveDistributeCommissionComponent.giveSharerCommission(distributerOpenId, sharerOpenIdChainList, appId, storeId, sharerCommission, orderAmount, orderNo, orderBuyer, orderBuyerOpenId, orderId, orderTitle, orderUrl, needAudit, distributerCommissionOrderType);
    }

    private void giveSharerPoint(List<ShareOpenIdChain> sharerOpenIdChainList, String appId, int point, String orderId, String orderTitle) {
        this.giveDistributePointComponent.giveSharerPoint(sharerOpenIdChainList, appId, point, orderId, orderTitle);
    }

    private String getOpenIdByMemberId(String memberId) {
        String openId = null;
        MemberAccount miniPrgroamAccount = this.memberAccountService.selectMiniProgramAccount(memberId);
        if (miniPrgroamAccount == null) {
            MemberAccount wechatAccount = this.memberAccountService.selectWechatAccount(memberId);
            if (wechatAccount != null) {
                openId = wechatAccount.getUsername();
            }
        } else {
            openId = miniPrgroamAccount.getUsername();
        }
        return openId;
    }
}

