/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.component;

import com.wego168.distribute.component.GiveDistributeCommissionComponent;
import com.wego168.distribute.component.GiveDistributePointComponent;
import com.wego168.distribute.enums.DistributerCommissionOrderTypeEnum;
import com.wego168.distribute.handler.MallOrderDistributeHandler;
import com.wego168.distribute.service.impl.DistributeOpenIdChainService;
import com.wego168.distribute.service.impl.DistributerCommissionService;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.share.domain.ShareOpenIdChain;
import com.wego168.share.service.ShareOpenIdChainService;
import com.wego168.util.StringUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class DefaultMallOrderDistributeHandler
implements MallOrderDistributeHandler {
    @Autowired
    private ShareOpenIdChainService shareOpenIdChainService;
    @Autowired
    private DistributeOpenIdChainService distributeOpenIdChainService;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private DistributerCommissionService distributerCommissionService;
    @Autowired
    private GiveDistributePointComponent giveDistributePointComponent;
    @Autowired
    private GiveDistributeCommissionComponent giveDistributeCommissionComponent;
    private Logger logger = LoggerFactory.getLogger(DefaultMallOrderDistributeHandler.class);

    @Override
    @Async
    public void giveSharerCommission(int sharerCommission, int orderAmount, String orderNo, String orderId, String orderTitle, String orderUrl, String orderBuyer, String appId, String storeId) {
        String orderBuyerOpenId = this.getOpenIdByMemberId(orderBuyer);
        if (StringUtil.isBlank((String)orderBuyerOpenId)) {
            this.logger.error("\u8ba2\u5355\uff1a\u6807\u9898->{}\uff0cid->{}\uff0c\u65e0\u63a8\u5e7f\u4f63\u91d1\u53d1\u653e\uff0c\u56e0\u4e3a\u8d2d\u4e70\u8005\u6ca1\u6709openid", (Object)orderTitle, (Object)orderId);
            return;
        }
        List<ShareOpenIdChain> sharerOpenIdChainList = this.shareOpenIdChainService.listUpperChainsExcludeSystemVirtualChain(orderBuyerOpenId);
        String distributerOpenId = this.distributeOpenIdChainService.getRealUpperOpenId(orderBuyerOpenId);
        String distributerCommissionOrderType = DistributerCommissionOrderTypeEnum.MALL_ORDER.value();
        this.giveDistributeCommissionComponent.giveSharerCommission(distributerOpenId, sharerOpenIdChainList, appId, storeId, sharerCommission, orderAmount, orderNo, orderBuyer, orderBuyerOpenId, orderId, orderTitle, orderUrl, false, distributerCommissionOrderType);
    }

    @Override
    @Async
    public void giveDistributerCommission(int distributerCommission, int orderAmount, String orderId, String orderTitle, String orderUrl, String orderBuyer, String appId) {
        String orderBuyerOpenId = this.getOpenIdByMemberId(orderBuyer);
        if (StringUtil.isBlank((String)orderBuyerOpenId)) {
            this.logger.error("\u8ba2\u5355\uff1a\u6807\u9898->{}\uff0cid->{}\uff0c\u65e0\u9500\u552e\u4f63\u91d1\u53d1\u653e\uff0c\u56e0\u4e3a\u8d2d\u4e70\u8005\u6ca1\u6709openid", (Object)orderTitle, (Object)orderId);
            return;
        }
        String distributerOpenId = this.distributeOpenIdChainService.getRealUpperOpenId(orderBuyerOpenId);
        String distributerCommissionOrderType = DistributerCommissionOrderTypeEnum.MALL_ORDER.value();
        this.giveDistributeCommissionComponent.giveDistributerCommission(distributerOpenId, appId, distributerCommission, orderAmount, orderBuyer, orderBuyerOpenId, orderId, orderTitle, orderUrl, false, distributerCommissionOrderType);
    }

    @Override
    @Async
    public void cancelDistributerCommission(String orderId) {
        this.distributerCommissionService.cancelCommissionByOrderId(orderId, "\u8ba2\u5355\u53d6\u6d88");
    }

    @Override
    public void giveSharerPoint(int sharerPoint, String memberId, String appId, String orderId, String orderTitle) {
        String openId = this.getOpenIdByMemberId(memberId);
        List<ShareOpenIdChain> sharerOpenIdChainList = this.shareOpenIdChainService.listUpperChainsExcludeSystemVirtualChain(openId);
        this.giveDistributePointComponent.giveSharerPoint(sharerOpenIdChainList, appId, sharerPoint, orderId, orderTitle);
    }

    private String getOpenIdByMemberId(String memberId) {
        String openId = null;
        MemberAccount miniPrgroamAccount = this.memberAccountService.selectMiniProgramAccount(memberId);
        if (miniPrgroamAccount == null) {
            MemberAccount wechatAccount = this.memberAccountService.selectWechatAccount(memberId);
            if (wechatAccount != null) {
                openId = wechatAccount.getUsername();
            }
        } else {
            openId = miniPrgroamAccount.getUsername();
        }
        return openId;
    }

    @Override
    @Async
    public void onOrderFinish(String orderId, String appId) {
        this.distributerCommissionService.updateCommissionWhenOrderFinished(orderId, appId);
    }
}

