/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.component;

import com.wego168.base.advice.FileUploadUtil;
import com.wego168.base.domain.FileServer;
import com.wego168.base.service.FileServerService;
import com.wego168.distribute.domain.DistributerQrcode;
import com.wego168.distribute.service.impl.DistributerQrcodeService;
import com.wego168.util.Checker;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import com.wego168.wx.domain.WxApp;
import com.wego168.wx.enums.WxAppServiceTypeEnum;
import com.wego168.wx.service.WxAppService;
import com.wego168.wx.token.SmallProgramUtil;
import java.awt.image.BufferedImage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DistributerQrcodeComponent {
    @Autowired
    private WxAppService wxAppService;
    @Autowired
    private FileServerService fileServerService;
    @Autowired
    private DistributerQrcodeService service;

    public DistributerQrcode createOrGet(String memberId, String appId, String page, String ownerType, String targetId, String targetType, int showStyle, String targetParam) {
        DistributerQrcode qrcode = this.service.selectByTarget(memberId, ownerType, targetType, targetId);
        if (qrcode != null) {
            return qrcode;
        }
        int serviceType = WxAppServiceTypeEnum.MINI_PROGRAM.value();
        WxApp miniProgram = this.wxAppService.selectByAppId(appId, serviceType);
        Checker.checkCondition((miniProgram == null ? 1 : 0) != 0, (String)"\u5c0f\u7a0b\u5e8f\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801");
        String defaultServerId = "1";
        FileServer server = (FileServer)this.fileServerService.selectById((Object)defaultServerId);
        Checker.checkCondition((server == null ? 1 : 0) != 0, (String)"\u56fe\u7247\u670d\u52a1\u5668\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801");
        String miniProgramPath = "";
        if (StringUtil.isNotBlank((String)page)) {
            miniProgramPath = page;
        }
        String scene = SequenceUtil.createUuid();
        BufferedImage bufferedImage = SmallProgramUtil.createMiniProgramQrcode((WxApp)miniProgram, (String)miniProgramPath, (String)scene);
        String errorMessage = "\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u5c0f\u7a0b\u5e8f[" + miniProgram.getName() + "]\u5c1a\u672a\u901a\u8fc7\u5ba1\u6838\uff0c\u6216\u9875\u9762\u8def\u5f84\u4e0d\u5b58\u5728";
        Checker.checkCondition((bufferedImage == null ? 1 : 0) != 0, (String)errorMessage);
        String fileName = String.valueOf(scene) + ".png";
        String cosBucket = "distributer-qrcode/" + appId;
        String url = FileUploadUtil.upload2Cos((BufferedImage)bufferedImage, (String)cosBucket, (String)fileName, (FileServer)server);
        qrcode = this.service.createQrcode(scene, url, memberId, targetId, targetType, ownerType, showStyle, appId, defaultServerId, targetParam);
        this.service.insert((Object)qrcode);
        return qrcode;
    }
}

