/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.component;

import com.wego168.distribute.domain.Distributer;
import com.wego168.distribute.domain.DistributerBecomeCondition;
import com.wego168.distribute.domain.DistributerRegistField;
import com.wego168.distribute.domain.DistributerRegistFieldData;
import com.wego168.distribute.enums.DistributerBecomeConditionEnum;
import com.wego168.distribute.enums.DistributerStatusEnum;
import com.wego168.distribute.model.DistributerRegistData;
import com.wego168.distribute.service.impl.DistributerRegistFieldDataService;
import com.wego168.distribute.service.impl.DistributerRegistFieldService;
import com.wego168.distribute.service.impl.DistributerService;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.util.SessionUtil;
import com.wego168.util.StringUtil;
import com.wego168.web.response.RestResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DistributerRegistComponent {
    @Autowired
    private DistributerService distributerService;
    @Autowired
    private DistributerRegistFieldService distributerRegistFieldService;
    @Autowired
    private DistributerRegistFieldDataService distributerRegistFieldDataService;
    @Autowired
    private MemberAccountService memberAccountService;

    public String ensureOpenId(HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        return this.ensureOpenId(memberId, request);
    }

    public String ensureOpenId(String memberId, HttpServletRequest request) {
        String openId = SessionUtil.getOpenId((HttpServletRequest)request);
        if (StringUtil.isBlank((String)openId)) {
            MemberAccount miniProgramAccount = this.memberAccountService.selectProgramAccount(memberId);
            if (miniProgramAccount != null) {
                openId = miniProgramAccount.getUsername();
            } else {
                MemberAccount wechatAccount = this.memberAccountService.selectWechatAccount(memberId);
                if (wechatAccount != null) {
                    openId = wechatAccount.getUsername();
                }
            }
        }
        return openId;
    }

    public RestResponse registByCondition(Map<String, String> registrationData, Member member, String openId, DistributerBecomeCondition condition) {
        String conditionCode = condition.getCondition();
        if (StringUtil.equals((String)conditionCode, (String)DistributerBecomeConditionEnum.NO_CONDITION.value())) {
            return this.becomeByMember(member, openId);
        }
        if (StringUtil.equals((String)conditionCode, (String)DistributerBecomeConditionEnum.REGIST.value())) {
            boolean needAudit = false;
            return this.regist(registrationData, member, openId, needAudit);
        }
        if (StringUtil.equals((String)conditionCode, (String)DistributerBecomeConditionEnum.REGIST_AND_AUDIT.value())) {
            boolean needAudit = true;
            return this.regist(registrationData, member, openId, needAudit);
        }
        return this.registByExternalCondition(registrationData, member, condition);
    }

    protected RestResponse becomeByMember(Member member, String openId) {
        this.distributerService.transferMemberWithoutAccount(member, openId);
        return RestResponse.success((String)"\u8f6c\u5316\u6210\u529f");
    }

    protected RestResponse regist(Map<String, String> registrationData, Member member, String openId, boolean needAudit) {
        String appId = member.getAppId();
        List<DistributerRegistField> fieldList = this.distributerRegistFieldService.selectList(appId);
        DistributerRegistData registrationDataResponse = this.distributerRegistFieldService.checkRegistrationData(registrationData, fieldList);
        String name = registrationDataResponse.getName();
        String mobile = registrationDataResponse.getMobile();
        Distributer distributer = this.distributerService.transferMemberWithoutAccount(member, openId);
        Distributer param = new Distributer();
        param.setId(distributer.getId());
        if (StringUtil.isNotBlank((String)name)) {
            param.setName(name);
        }
        if (StringUtil.isNotBlank((String)mobile)) {
            param.setMobile(mobile);
        }
        String status = needAudit ? DistributerStatusEnum.WAITING_AUDIT.value() : DistributerStatusEnum.AUDITED.value();
        param.setStatus(status);
        param.setUpdateTime(new Date());
        this.distributerService.updateSelective((Object)param);
        List<DistributerRegistFieldData> dataList = this.distributerRegistFieldDataService.create(fieldList, registrationData, distributer.getId());
        this.distributerRegistFieldDataService.insertBatch(dataList);
        if (needAudit) {
            return RestResponse.success((String)"\u6ce8\u518c\u6210\u529f\uff0c\u6b63\u5728\u7b49\u5f85\u5ba1\u6838");
        }
        return RestResponse.success((String)"\u6ce8\u518c\u6210\u529f");
    }

    protected RestResponse registByExternalCondition(Map<String, String> registrationData, Member member, DistributerBecomeCondition condition) {
        return RestResponse.error(null, (String)"\u6ce8\u518c\u5931\u8d25\uff1a\u672a\u914d\u7f6e\u6ce8\u518c\u6761\u4ef6");
    }
}

