/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.component;

import com.wego168.distribute.domain.DistributerCommission;
import com.wego168.distribute.domain.DistributerCommissionConfig;
import com.wego168.distribute.enums.DistributerCommissionAuditStatusEnum;
import com.wego168.distribute.enums.DistributerCommissionOrderTypeEnum;
import com.wego168.distribute.enums.DistributerCommissionStatusEnum;
import com.wego168.distribute.service.impl.DistributerCommissionConfigService;
import com.wego168.distribute.service.impl.DistributerCommissionService;
import com.wego168.domain.BaseDomain;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.share.domain.DefaultPlatformSharer;
import com.wego168.share.domain.ShareOpenIdChain;
import com.wego168.share.domain.Sharer;
import com.wego168.share.domain.SharerConfig;
import com.wego168.share.domain.SharerLevel;
import com.wego168.share.service.DefaultPlatformSharerService;
import com.wego168.share.service.SharerConfigService;
import com.wego168.share.service.SharerLevelService;
import com.wego168.share.service.SharerService;
import com.wego168.share.task.SharerLevelCalculator;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.Checker;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GiveDistributeCommissionComponent {
    @Autowired
    private SharerService sharerService;
    @Autowired
    private SharerConfigService sharerConfigService;
    @Autowired
    private SharerLevelService sharerLevelService;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private DistributerCommissionService distributerCommissionService;
    @Autowired
    private DistributerCommissionConfigService distributerCommissionConfigService;
    @Autowired
    private DefaultPlatformSharerService defaultPlatformSharerService;
    @Autowired
    private SharerLevelCalculator sharerLevelCalculator;
    private Logger logger = LoggerFactory.getLogger(GiveDistributeCommissionComponent.class);

    public void giveSharerCommission(String distributerOpenId, List<ShareOpenIdChain> sharerOpenIdChainList, String appId, String storeId, int sharerCommission, int orderAmount, String orderNo, String orderBuyer, String orderBuyerOpenId, String orderId, String orderTitle, String orderUrl, boolean needAudit, String distributerCommissionOrderType) {
        if (Checker.listIsEmpty(sharerOpenIdChainList)) {
            this.logger.error("\u8ba2\u5355\uff1a\u6807\u9898->{}\uff0cid->{}\uff0c\u65e0\u63a8\u5e7f\u4f63\u91d1\u53d1\u653e\uff0c\u56e0\u4e3a\u6ca1\u6709\u63a8\u5e7f\u8005", (Object)orderTitle, (Object)orderId);
            DefaultPlatformSharer defaultPlatformSharer = this.defaultPlatformSharerService.selectByAppId(appId);
            if (defaultPlatformSharer != null) {
                sharerOpenIdChainList = new ArrayList<ShareOpenIdChain>(1);
                ShareOpenIdChain defaultSharerOpenIdChain = new ShareOpenIdChain();
                defaultSharerOpenIdChain.setUpperOpenId(defaultPlatformSharer.getSharerOpenId());
                defaultSharerOpenIdChain.setUpperSharerLevel(1);
                sharerOpenIdChainList.add(defaultSharerOpenIdChain);
                this.logger.error("\u627e\u5230\u4e86\u9ed8\u8ba4\u5e73\u53f0\u63a8\u5e7f\u8005");
            }
            if (Checker.listIsEmpty(sharerOpenIdChainList)) {
                return;
            }
        }
        DistributerCommissionConfig commissionConfig = this.distributerCommissionConfigService.select(appId);
        boolean giveDistributerAndSharerCommissionAtSameTime = commissionConfig.getGiveDistributerAndSharerCommissionAtSameTime();
        int frozenHours = this.deduceFrozenHours(distributerCommissionOrderType, commissionConfig);
        String level1MemberId = null;
        String level1OpenId = null;
        HashSet<String> sharerOpenIdSet = new HashSet<String>();
        SharerConfig sharerConfig = this.sharerConfigService.selectByAppId(appId);
        for (ShareOpenIdChain shareOpenIdChain : sharerOpenIdChainList) {
            String sharerOpenId = shareOpenIdChain.getUpperOpenId();
            if (sharerOpenIdSet.contains(sharerOpenId) || StringUtil.equals((String)distributerOpenId, (String)sharerOpenId) && !giveDistributerAndSharerCommissionAtSameTime) continue;
            MemberAccount sharerAccount = this.memberAccountService.selectByUsername(sharerOpenId, appId);
            String sharerId = sharerAccount.getMemberId();
            Sharer sharer = (Sharer)((Object)this.sharerService.selectById(sharerId));
            int level = sharer.getLevel();
            int chainLevel = shareOpenIdChain.getUpperSharerLevel();
            if (chainLevel > sharerConfig.getMaxCommissionLevel()) continue;
            SharerLevel sharerLevel = this.sharerLevelService.selectByLevel(appId, level);
            int sharerCommissionAmount = 0;
            int sharerCommissionRate1 = 100;
            int sharerCommissionRate2 = 100;
            if (chainLevel == 1) {
                if (sharerLevel != null) {
                    sharerCommissionRate1 = sharerLevel.getCommissionRate();
                }
            } else if (sharerLevel != null) {
                sharerCommissionRate2 = sharerLevel.getCommissionRate2();
            }
            DistributerCommission commission = new DistributerCommission();
            BaseDomainUtil.initBaseDomain((BaseDomain)commission, (String)appId);
            commission.setAmount(sharerCommissionAmount);
            if (!needAudit) {
                commission.setAuditFinishTime(new Date());
                commission.setAuditStatus(DistributerCommissionAuditStatusEnum.AUDITED.value());
                commission.setAuditTime(new Date());
            } else {
                commission.setAuditFinishTime(null);
                commission.setAuditStatus(DistributerCommissionAuditStatusEnum.WAITING_AUDIT.value());
                commission.setAuditTime(null);
            }
            commission.setDistributerId(sharerId);
            commission.setDistributerLevel(shareOpenIdChain.getUpperSharerLevel());
            commission.setFromOrderAmount(orderAmount);
            commission.setFromOrderBuyer(orderBuyer);
            commission.setFromOrderBuyerOpenId(orderBuyerOpenId);
            commission.setFromOrderId(orderId);
            commission.setFromOrderNumber(orderNo);
            commission.setFromOrderTitle(orderTitle);
            commission.setFromOrderType(distributerCommissionOrderType);
            commission.setFromOrderUrl(orderUrl);
            commission.setNote(null);
            commission.setNumber(SequenceUtil.createRandomNumberSequence((int)16));
            commission.setRefuseReason(null);
            commission.setRefuseTime(null);
            commission.setStoreId(storeId);
            commission.setTransferDelayHours(frozenHours);
            commission.setType("sharer");
            commission.setStatus(DistributerCommissionStatusEnum.ONGOING.value());
            if (chainLevel == 1) {
                commission.setAmount((int)((double)(sharerCommission * sharerCommissionRate1) * 0.01));
                commission.setLevel1MemberId(sharerId);
                level1MemberId = sharerId;
                commission.setLevel2MemberId(null);
                commission.setLevel1OpenId(sharerOpenId);
                level1OpenId = sharerOpenId;
                commission.setLevel2OpenId(null);
            } else if (chainLevel == 2) {
                if (sharerCommissionRate1 + sharerCommissionRate2 > 100) {
                    commission.setAmount(sharerCommission - (int)((double)(sharerCommission * sharerCommissionRate1) * 0.01));
                } else {
                    commission.setAmount((int)((double)(sharerCommission * sharerCommissionRate2) * 0.01));
                }
                commission.setLevel1MemberId(level1MemberId);
                commission.setLevel2MemberId(sharerId);
                commission.setLevel1OpenId(level1OpenId);
                commission.setLevel2OpenId(sharerOpenId);
            }
            sharerOpenIdSet.add(sharerOpenId);
            this.distributerCommissionService.insert((Object)commission);
            this.logger.error("\u8ba2\u5355\uff1a\u6807\u9898->{}\uff0cid->{}\uff0c\u63a8\u5e7f\u4f63\u91d1\u5df2\u53d1\u653e->{}", new Object[]{orderTitle, orderId, sharerCommissionAmount});
            this.sharerLevelCalculator.calculateSharerLevelByCommission(sharerId, appId);
            this.distributerCommissionService.updateSharerCommissionAmountAsync(sharerId, appId);
        }
    }

    public void giveDistributerCommission(String distributerOpenId, String appId, int distributerCommission, int orderAmount, String orderBuyer, String orderBuyerOpenId, String orderId, String orderTitle, String orderUrl, boolean needAudit, String distributerCommissionOrderType) {
        if (StringUtil.isBlank((String)distributerOpenId)) {
            this.logger.error("\u8ba2\u5355\uff1a\u6807\u9898->{}\uff0cid->{}\uff0c\u65e0\u9500\u552e\u4f63\u91d1\u53d1\u653e\uff0c\u56e0\u4e3a\u6ca1\u6709\u9500\u552e\u5458", (Object)orderTitle, (Object)orderId);
            return;
        }
        DistributerCommissionConfig commissionConfig = this.distributerCommissionConfigService.select(appId);
        int frozenHours = this.deduceFrozenHours(distributerCommissionOrderType, commissionConfig);
        MemberAccount distributerAccount = this.memberAccountService.selectByUsername(distributerOpenId, appId);
        String distributerId = distributerAccount.getMemberId();
        DistributerCommission commission = new DistributerCommission();
        BaseDomainUtil.initBaseDomain((BaseDomain)commission, (String)appId);
        commission.setAmount(distributerCommission);
        if (!needAudit) {
            commission.setAuditFinishTime(new Date());
            commission.setAuditStatus(DistributerCommissionAuditStatusEnum.AUDITED.value());
            commission.setAuditTime(new Date());
        } else {
            commission.setAuditFinishTime(null);
            commission.setAuditStatus(DistributerCommissionAuditStatusEnum.WAITING_AUDIT.value());
            commission.setAuditTime(null);
        }
        commission.setDistributerId(distributerId);
        commission.setDistributerLevel(1);
        commission.setFromOrderAmount(orderAmount);
        commission.setFromOrderBuyer(orderBuyer);
        commission.setFromOrderBuyerOpenId(orderBuyerOpenId);
        commission.setFromOrderId(orderId);
        commission.setFromOrderNumber("-");
        commission.setFromOrderTitle(orderTitle);
        commission.setFromOrderType(distributerCommissionOrderType);
        commission.setFromOrderUrl(orderUrl);
        commission.setNote(null);
        commission.setNumber(SequenceUtil.createRandomNumberSequence((int)16));
        commission.setRefuseReason(null);
        commission.setRefuseTime(null);
        commission.setStoreId(appId);
        commission.setTransferDelayHours(frozenHours);
        commission.setType("distributer");
        commission.setStatus(DistributerCommissionStatusEnum.ONGOING.value());
        this.distributerCommissionService.insert((Object)commission);
        this.logger.error("\u8ba2\u5355\uff1a\u6807\u9898->{}\uff0cid->{}\uff0c\u9500\u552e\u4f63\u91d1\u5df2\u53d1\u653e->{}", new Object[]{orderTitle, orderId, distributerCommission});
    }

    private int deduceFrozenHours(String distributerCommissionOrderType, DistributerCommissionConfig commissionConfig) {
        if (StringUtil.equals((String)distributerCommissionOrderType, (String)DistributerCommissionOrderTypeEnum.ACTIVITY_SIGN.value())) {
            return commissionConfig.getActivityCommissionFrozenHours();
        }
        if (StringUtil.equals((String)distributerCommissionOrderType, (String)DistributerCommissionOrderTypeEnum.COURSE_VIP_PURCHASE.value())) {
            return commissionConfig.getCourseCommissionFrozenHours();
        }
        if (StringUtil.equals((String)distributerCommissionOrderType, (String)DistributerCommissionOrderTypeEnum.MALL_ORDER.value())) {
            return commissionConfig.getOrderCommissionFrozenHours();
        }
        return 360;
    }

    public String getOpenIdByMemberId(String memberId) {
        String openId = null;
        MemberAccount miniPrgroamAccount = this.memberAccountService.selectMiniProgramAccount(memberId);
        if (miniPrgroamAccount == null) {
            MemberAccount wechatAccount = this.memberAccountService.selectWechatAccount(memberId);
            if (wechatAccount != null) {
                openId = wechatAccount.getUsername();
            }
        } else {
            openId = miniPrgroamAccount.getUsername();
        }
        return openId;
    }
}

