/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.component;

import com.wego168.member.domain.MemberAccount;
import com.wego168.member.domain.points.PointsFlow;
import com.wego168.member.enums.PointsBusinessTypeEnum;
import com.wego168.member.enums.PointsTypeEnum;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.points.PointsFlowService;
import com.wego168.share.domain.ShareOpenIdChain;
import com.wego168.share.domain.Sharer;
import com.wego168.share.domain.SharerConfig;
import com.wego168.share.domain.SharerLevel;
import com.wego168.share.service.SharerConfigService;
import com.wego168.share.service.SharerLevelService;
import com.wego168.share.service.SharerService;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GiveDistributePointComponent {
    @Autowired
    private SharerService sharerService;
    @Autowired
    private SharerConfigService sharerConfigService;
    @Autowired
    private SharerLevelService sharerLevelService;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private PointsFlowService pointsFlowService;
    private Logger logger = LoggerFactory.getLogger(GiveDistributePointComponent.class);

    public void giveSharerPoint(List<ShareOpenIdChain> sharerOpenIdChainList, String appId, int point, String orderId, String orderTitle) {
        if (sharerOpenIdChainList == null || sharerOpenIdChainList.size() == 0) {
            this.logger.error("\u8ba2\u5355\uff1a\u6807\u9898->{}\uff0cid->{}\uff0c\u65e0\u63a8\u5e7f\u79ef\u5206\u53d1\u653e\uff0c\u56e0\u4e3a\u6ca1\u6709\u63a8\u5e7f\u8005", (Object)orderTitle, (Object)orderId);
            return;
        }
        HashSet sharerOpenIdSet = new HashSet();
        SharerConfig sharerConfig = this.sharerConfigService.selectByAppId(appId);
        for (ShareOpenIdChain shareOpenIdChain : sharerOpenIdChainList) {
            int chainLevel;
            String sharerOpenId = shareOpenIdChain.getUpperOpenId();
            if (sharerOpenIdSet.contains(sharerOpenId) || (chainLevel = shareOpenIdChain.getUpperSharerLevel().intValue()) > sharerConfig.getMaxCommissionLevel()) continue;
            this.giveSharerPoint(sharerOpenId, appId, point, orderId, orderTitle);
        }
    }

    private void giveSharerPoint(String sharerOpenId, String appId, int point, String orderId, String orderTitle) {
        MemberAccount sharerAccount = this.memberAccountService.selectByUsername(sharerOpenId, appId);
        String sharerId = sharerAccount.getMemberId();
        Sharer sharer = (Sharer)((Object)this.sharerService.selectById(sharerId));
        int level = sharer.getLevel();
        SharerLevel sharerLevel = this.sharerLevelService.selectByLevel(appId, level);
        int sharerPointAmount = 0;
        sharerPointAmount = sharerLevel != null ? (int)((double)(point * sharerLevel.getPointRate()) * 0.01) : (int)((double)point * 0.1);
        if (sharerPointAmount <= 0) {
            this.logger.error("\u63a8\u5e7f\u8005\u7b49\u7ea7{}\u7684\u79ef\u5206\u6bd4\u7387\u4e3a0\uff0c\u6240\u4ee5\u6ca1\u6709\u79ef\u5206\u4ea7\u751f", (Object)level);
            return;
        }
        String pointType = PointsTypeEnum.INCOME.value();
        String detail = "\uff08\u9080\u8bf7\u5956\u52b1\uff09" + orderTitle;
        String businessType = PointsBusinessTypeEnum.INVITE_ACTIVITY_SIGN.value();
        PointsFlow flow = this.pointsFlowService.build(sharerId, sharerPointAmount, detail, pointType, orderId, businessType, appId);
        this.pointsFlowService.produce(new PointsFlow[]{flow});
        this.logger.error("\u7b49\u7ea7[{}]\u5df2\u53d1\u653e[{}]\u79ef\u5206", (Object)level, (Object)sharerPointAmount);
    }
}

