/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.component;

import com.wego168.share.domain.ShareOpenIdChain;
import com.wego168.share.domain.ShareOpenIdLink;
import com.wego168.share.domain.SharerConfig;
import com.wego168.share.enums.SharerChainModeEnum;
import com.wego168.share.service.ShareOpenIdChainService;
import com.wego168.share.service.ShareOpenIdLinkService;
import com.wego168.share.service.SharerConfigService;
import com.wego168.share.service.SharerFriendsService;
import com.wego168.share.task.SharerLevelCalculator;
import com.wego168.util.StringUtil;
import com.wego168.web.response.RestResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SharerBindComponent {
    private static final Logger log = LoggerFactory.getLogger(SharerBindComponent.class);
    @Autowired
    private ShareOpenIdLinkService shareOpenIdLinkService;
    @Autowired
    private SharerConfigService sharerConfigService;
    @Autowired
    private ShareOpenIdChainService shareOpenIdChainService;
    @Autowired
    private SharerFriendsService sharerFansService;
    @Autowired
    private SharerLevelCalculator sharerLevelCalculator;

    public RestResponse bindSharer(String openId, String upperOpenId, String url, String appId) {
        ShareOpenIdLink link = this.shareOpenIdLinkService.create(openId, upperOpenId, url);
        link.setAppId(appId);
        this.shareOpenIdLinkService.insert(link);
        if (StringUtil.equals((String)openId, (String)upperOpenId)) {
            log.error("\u63a8\u5e7f\u8005\u7ed1\u5b9a\u5931\u8d25\uff0c\u5206\u4eab\u8005\u548c\u5f53\u524d\u7528\u6237openid\u76f8\u540c\uff1a{}", (Object)openId);
            return RestResponse.success((Object)"\u7ed1\u5b9a\u63a8\u5e7f\u8005\u5931\u8d25\uff0c\u5206\u4eab\u8005\u548c\u5f53\u524d\u7528\u6237openid\u76f8\u540c", (String)"ok");
        }
        SharerConfig config = this.sharerConfigService.selectByAppId(appId);
        ShareOpenIdChain chain = this.shareOpenIdChainService.getUpperOpenIdChainIncludeSystem2(openId);
        if (chain != null) {
            if (chain.getUpperSharerLevel() == 0) {
                log.error("\u63a8\u5e7f\u8005\u7ed1\u5b9a\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\uff1a{}\u662f\u9876\u7ea7\u63a8\u5e7f\u8005,\u5206\u4eab\u8005\uff1a{}", (Object)openId, (Object)upperOpenId);
                return RestResponse.success((Object)"\u7ed1\u5b9a\u63a8\u5e7f\u8005\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u662f\u9876\u7ea7\u63a8\u5e7f\u8005", (String)"ok");
            }
            String existUpperOpenId = chain.getUpperOpenId();
            if (StringUtil.equals((String)existUpperOpenId, (String)upperOpenId)) {
                return RestResponse.success((Object)"\u4ec0\u4e48\u4e5f\u6ca1\u505a", (String)"ok");
            }
            if (StringUtil.equals((String)SharerChainModeEnum.PERMANENT.value(), (String)config.getChainMode())) {
                log.error("\u63a8\u5e7f\u8005\u7ed1\u5b9a\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\uff1a{}\u5df2\u5b58\u5728\u63a8\u5e7f\u8005\uff1a{},\u5206\u4eab\u8005\uff1a{}", new Object[]{openId, existUpperOpenId, upperOpenId});
                return RestResponse.success((Object)"\u7ed1\u5b9a\u63a8\u5e7f\u8005\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u63a8\u5e7f\u8005", (String)"ok");
            }
            chain.setUpperOpenId(upperOpenId);
            chain.setCreateTime(new Date());
            this.shareOpenIdChainService.updateSelective(chain);
            this.sharerFansService.updateShareFriendsQuantityAsync(upperOpenId, appId);
            this.sharerFansService.updateShareFriendsQuantityAsync(existUpperOpenId, appId);
            return RestResponse.success((Object)"\u5df2\u7ed1\u5b9a\u65b0\u7684\u63a8\u5e7f\u8005", (String)"ok");
        }
        boolean audited = this.shareOpenIdChainService.isAuditedSharerId(upperOpenId, appId);
        if (!audited) {
            String realUpperOpenId = this.shareOpenIdChainService.getRealUpperOpenId(upperOpenId);
            if (StringUtil.isBlank((String)realUpperOpenId)) {
                log.error("\u63a8\u5e7f\u8005\u7ed1\u5b9a\u5931\u8d25\uff0c\u5206\u4eab\u8005\uff1a{}\u4e0d\u662f\u63a8\u5e7f\u8005\uff0c\u4e5f\u4e0d\u5b58\u5728\u4e0a\u7ea7\u63a8\u5e7f\u8005\uff0c\u5f53\u524d\u7528\u6237\uff1a{}", (Object)upperOpenId, (Object)openId);
                return RestResponse.success((Object)"\u7ed1\u5b9a\u63a8\u5e7f\u8005\u5931\u8d25\uff0c\u5206\u4eab\u8005\u4e0d\u662f\u63a8\u5e7f\u8005", (String)"ok");
            }
            log.error("\u63a8\u5e7f\u8005\u7ed1\u5b9a\u5931\u8d25\uff0c\u5206\u4eab\u8005\uff1a{}\u4e0d\u662f\u63a8\u5e7f\u8005\uff0c\u5b58\u5728\u4e0a\u7ea7\u63a8\u5e7f\u8005\uff1a{}\uff0c\u5f53\u524d\u7528\u6237\uff1a{}", new Object[]{upperOpenId, realUpperOpenId, openId});
            upperOpenId = realUpperOpenId;
        }
        List<ShareOpenIdChain> upperChainList = this.shareOpenIdChainService.listUpperChainsExcludeSystemVirtualChain(upperOpenId);
        int chainExpireDays = config.getChainExpireDays();
        int chainInsteadDays = config.getChainInsteadDays();
        ShareOpenIdChain level1Chain = this.shareOpenIdChainService.create(openId, upperOpenId, 0, true, url, chainExpireDays, chainInsteadDays);
        level1Chain.setAppId(appId);
        upperChainList.add(0, level1Chain);
        ArrayList<ShareOpenIdChain> chainList = new ArrayList<ShareOpenIdChain>();
        int maxLevel = 2;
        int index = 0;
        for (ShareOpenIdChain shareOpenIdChain : upperChainList) {
            int level = shareOpenIdChain.getUpperSharerLevel() + 1;
            if (level > maxLevel) break;
            boolean isRoot = index + 1 == upperChainList.size() || index + 1 >= maxLevel;
            ShareOpenIdChain c = this.shareOpenIdChainService.create(openId, shareOpenIdChain.getUpperOpenId(), level, isRoot, url, chainExpireDays, chainInsteadDays);
            c.setAppId(appId);
            chainList.add(c);
            ++index;
        }
        this.shareOpenIdChainService.insertBatch(chainList);
        for (ShareOpenIdChain shareOpenIdChain : chainList) {
            this.sharerFansService.updateShareFriendsQuantityAsync(shareOpenIdChain.getUpperOpenId(), appId);
        }
        this.sharerLevelCalculator.calculateSharerLevelByBinding(upperOpenId, appId);
        return RestResponse.success((Object)"\u7ed1\u5b9a\u63a8\u5e7f\u8005\u6210\u529f", (String)"ok");
    }
}

