/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.controller.admin;

import com.wego168.authority.domain.SysAccount;
import com.wego168.authority.service.LoginService;
import com.wego168.authority.service.SysAccountService;
import com.wego168.distribute.domain.Distributer;
import com.wego168.distribute.enums.DistributerStatusEnum;
import com.wego168.distribute.service.IDistributerService;
import com.wego168.member.domain.Member;
import com.wego168.member.service.IMemberService;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AdminDistributerControllerSupport
extends SimpleController {
    @Autowired
    private LoginService loginService;

    public RestResponse auditDistributer(String id) {
        Checker.checkBlank((String)id, (String)"\u5206\u9500\u8005id");
        this.getDistributerService().audit(id);
        return RestResponse.success((String)"\u5ba1\u6838\u6210\u529f");
    }

    public RestResponse forbidDistributer(String id) {
        Checker.checkBlank((String)id, (String)"\u5206\u9500\u8005id");
        Distributer existDistributer = this.getDistributerService().selectById(id);
        if (existDistributer == null) {
            return RestResponse.error((String)"\u8be5\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        if (StringUtil.equals((String)existDistributer.getStatus(), (String)DistributerStatusEnum.WAITING_AUDIT.value())) {
            return RestResponse.error((String)"\u8be5\u5bf9\u8c61\u8fd8\u672a\u5ba1\u6838\uff0c\u65e0\u9700\u51bb\u7ed3\u3002");
        }
        this.getDistributerService().forbid(id);
        return RestResponse.success((String)"\u51bb\u7ed3\u6210\u529f");
    }

    public RestResponse unForbidDistributer(String id) {
        Checker.checkBlank((String)id, (String)"\u5206\u9500\u8005id");
        Distributer existDistributer = this.getDistributerService().selectById(id);
        if (existDistributer == null) {
            return RestResponse.error((String)"\u8be5\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        this.getDistributerService().unForbid(id);
        return RestResponse.success((String)"\u89e3\u51bb\u6210\u529f");
    }

    public RestResponse transferMember(String memberId, String appId, String username, String password, String distributerRoleId) {
        Checker.checkBlank((String)memberId, (String)"\u4f1a\u5458id");
        Checker.checkBlank((String)username, (String)"\u767b\u5f55\u7528\u6237\u540d");
        Checker.checkBlank((String)password, (String)"\u767b\u5f55\u5bc6\u7801");
        Member member = this.getMemberService().selectById(memberId);
        if (member == null) {
            return RestResponse.error((String)"\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        Distributer existDistributer = this.getDistributerService().selectById(memberId);
        if (existDistributer != null) {
            return RestResponse.error((String)"\u8f6c\u6362\u5931\u8d25\uff1a\u8be5\u4f1a\u5458\u5df2\u6709\u5206\u9500\u8005\u8eab\u4efd");
        }
        SysAccount existSysAccount = this.getSysAccountService().selectByUsername(username);
        if (existSysAccount != null) {
            return RestResponse.error((String)"\u8f6c\u6362\u5931\u8d25\uff1a\u60a8\u8f93\u5165\u7684\u7528\u6237\u540d\u5df2\u88ab\u6ce8\u518c\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        SysAccount sysAccount = this.getSysAccountService().create(appId, member.getName(), username, password);
        this.getDistributerService().transferMember(member, appId, sysAccount, distributerRoleId);
        this.getDistributerService().audit(memberId);
        return RestResponse.success((String)"\u8f6c\u6362\u6210\u529f");
    }

    public SysAccount distributerLogin(String username, String password, int sysAccountType) {
        SysAccount account = this.loginService.login(username, password, Integer.valueOf(sysAccountType));
        return account;
    }

    protected abstract IMemberService getMemberService();

    protected abstract IDistributerService getDistributerService();

    protected abstract SysAccountService getSysAccountService();
}

