/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.controller.admin;

import com.wego168.distribute.model.response.DefaultPlatformSharerResponse;
import com.wego168.exception.WegoException;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.share.domain.DefaultPlatformSharer;
import com.wego168.share.domain.Sharer;
import com.wego168.share.service.DefaultPlatformSharerService;
import com.wego168.share.service.SharerService;
import com.wego168.util.Checker;
import com.wego168.util.SequenceUtil;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
public class DefaultPlatformSharerController
extends SimpleController {
    @Autowired
    private DefaultPlatformSharerService service;
    @Autowired
    private SharerService sharerService;
    @Autowired
    private MemberAccountService memberAccountService;

    @GetMapping(value={"/api/admin/v1/default-platform-sharer/get"})
    public RestResponse get() {
        String appId = super.getAppId();
        DefaultPlatformSharer defaultSharer = this.service.selectByAppId(appId);
        if (defaultSharer == null) {
            return RestResponse.success(null);
        }
        String sharerId = defaultSharer.getSharerId();
        Sharer sharer = (Sharer)((Object)this.sharerService.selectById(sharerId));
        DefaultPlatformSharerResponse response = new DefaultPlatformSharerResponse();
        response.setSharerId(sharerId);
        response.setName(sharer.getName());
        response.setPhone(sharer.getMobile());
        return RestResponse.success((Object)response);
    }

    @PostMapping(value={"/api/admin/v1/default-platform-sharer/update"})
    public RestResponse update(@NotBlankAndLength(message="\u63a8\u5e7f\u8005\u975e\u6cd5") String sharerId) {
        try {
            Sharer sharer = (Sharer)((Object)this.sharerService.selectById(sharerId));
            Checker.checkCondition((sharer == null ? 1 : 0) != 0, (String)"\u8be5\u63a8\u5e7f\u8005\u4e0d\u5b58\u5728");
            MemberAccount miniProgramAccount = this.memberAccountService.selectMiniProgramAccount(sharerId);
            Checker.checkCondition((miniProgramAccount == null ? 1 : 0) != 0, (String)"\u8be5\u63a8\u5e7f\u8005\u672a\u7ed1\u5b9a\u5fae\u4fe1\u5c0f\u7a0b\u5e8f");
            String appId = super.getAppId();
            DefaultPlatformSharer defaultSharer = this.service.selectByAppId(appId);
            if (defaultSharer == null) {
                defaultSharer = new DefaultPlatformSharer();
                defaultSharer.setAppId(appId);
                defaultSharer.setId(SequenceUtil.createUuid());
                defaultSharer.setSharerId(sharerId);
                defaultSharer.setSharerOpenId(miniProgramAccount.getUsername());
                this.service.insert(defaultSharer);
            } else {
                defaultSharer.setSharerId(sharerId);
                defaultSharer.setSharerOpenId(miniProgramAccount.getUsername());
                this.service.updateSelective(defaultSharer);
            }
            return RestResponse.success((String)"\u8bbe\u7f6e\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }
}

