/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.controller.admin;

import com.wego168.distribute.domain.DistributerBecomeCondition;
import com.wego168.distribute.model.response.DistributerBecomeConditionAdminListResponse;
import com.wego168.distribute.service.impl.DistributerBecomeConditionConfigService;
import com.wego168.distribute.service.impl.DistributerBecomeConditionService;
import com.wego168.exception.WegoException;
import com.wego168.util.Checker;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminDistributerBecomeConditionConfigController")
public class DistributerBecomeConditionConfigController
extends SimpleController {
    @Autowired
    private DistributerBecomeConditionConfigService service;
    @Autowired
    private DistributerBecomeConditionService distributerBecomeConditionService;

    @PostMapping(value={"/api/admin/v1/distributer-become-condition-config/refresh"})
    public RestResponse refresh(@RequestParam(value="conditionId") String conditionIdArrayString) {
        try {
            Checker.checkBlank((String)conditionIdArrayString, (String)"\u6761\u4ef6");
            String[] conditionIdArray = conditionIdArrayString.split(",");
            List<DistributerBecomeCondition> list = this.distributerBecomeConditionService.selectListByIdArray(conditionIdArray);
            Checker.checkCondition((conditionIdArray.length != list.size() ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u6761\u4ef6");
            String appId = this.getAppId();
            this.service.refresh(appId, conditionIdArray);
            return RestResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/admin/v1/distributer-become-condition-config/get"})
    public RestResponse get() {
        String appId = this.getAppId();
        return RestResponse.success((Object)new DistributerBecomeConditionAdminListResponse(this.service.selectConfig(appId).get(0)));
    }
}

