/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.controller.admin;

import com.wego168.distribute.domain.DistributerCommissionConfig;
import com.wego168.distribute.enums.TransferWayEnum;
import com.wego168.distribute.service.impl.DistributerCommissionConfigService;
import com.wego168.exception.WegoException;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import com.wego168.wxpay.service.WxpayConfigService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminDistributerCommissionConfigController")
public class DistributerCommissionConfigController
extends SimpleController {
    @Autowired
    private DistributerCommissionConfigService service;
    @Autowired
    private WxpayConfigService wxpayConfigService;

    @GetMapping(value={"/api/admin/v1/distributer-commission-config/get"})
    public RestResponse get() {
        String appId = this.getAppId();
        return RestResponse.success((Object)((Object)this.service.select(appId)));
    }

    @PostMapping(value={"/api/admin/v1/distributer-commission-config/update"})
    public RestResponse update(@RequestParam(required=false, name="activityCommissionRate1") String activityCommissionRate1String, @RequestParam(required=false, name="activityCommissionFrozenHours") String activityCommissionFrozenHoursString, @RequestParam(required=false, name="courseCommissionRate1") String courseCommissionRate1String, @RequestParam(required=false, name="courseCommissionFrozenHours") String courseCommissionFrozenHoursString, @RequestParam(required=false, name="orderCommissionRate1") String orderCommissionRate1String, @RequestParam(required=false, name="orderCommissionFrozenHours") String orderCommissionFrozenHoursString, @RequestParam(required=false, name="minWithdrawAmount") String minWithdrawAmountString, @RequestParam(required=false, name="poundageRate") String poundageRateString, @RequestParam(required=false, name="minPoundage") String minPoundageString, String transferWay) {
        try {
            int minPoundage = Checker.checkStringIsUnsignedInteger((String)minPoundageString, (String)"\u6700\u4f4e\u63d0\u73b0\u624b\u7eed\u8d39");
            int poundageRate = Checker.checkStringIsUnsignedInteger((String)poundageRateString, (String)"\u63d0\u73b0\u624b\u7eed\u8d39\u8d39\u7387");
            int minWithdrawAmount = Checker.checkStringIsUnsignedInteger((String)minWithdrawAmountString, (String)"\u6700\u4f4e\u63d0\u73b0\u91d1\u989d");
            Checker.checkCondition((minPoundage >= minWithdrawAmount ? 1 : 0) != 0, (String)"\u6700\u4f4e\u63d0\u73b0\u624b\u7eed\u8d39\u4e0d\u53ef\u9ad8\u4e8e\u7b49\u4e8e\u6700\u4f4e\u63d0\u73b0\u91d1\u989d");
            if (StringUtil.isBlank((String)transferWay)) {
                transferWay = TransferWayEnum.MANUAL.value();
            }
            Checker.checkInRange((Object)((Object)TransferWayEnum.get(transferWay)), (Object[])TransferWayEnum.values(), (String)"\u9519\u8bef\u7684\u8f6c\u8d26\u65b9\u5f0f");
            if (StringUtil.equals((String)transferWay, (String)TransferWayEnum.AUTO.value())) {
                String appId = this.getAppId();
                boolean joinPayIsConfigured = this.wxpayConfigService.joinPayIsConfigured(appId);
                Checker.checkCondition((!joinPayIsConfigured ? 1 : 0) != 0, (String)"\u6c47\u805a\u652f\u4ed8\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u4f7f\u7528\u81ea\u52a8\u8f6c\u8d26\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            DistributerCommissionConfig param = new DistributerCommissionConfig();
            param.setId(this.getAppId());
            param.setMinPoundage(minPoundage);
            param.setPoundageRate(poundageRate);
            param.setMinWithdrawAmount(minWithdrawAmount);
            param.setTransferWay(transferWay);
            param.setUpdateTime(new Date());
            if (StringUtil.isNotBlank((String)activityCommissionRate1String)) {
                int activityCommissionRate1 = Checker.checkStringIsUnsignedInteger((String)activityCommissionRate1String, (String)"\u6d3b\u52a8\u4f63\u91d1\u6bd4\u7387");
                param.setActivityCommissionRate1(activityCommissionRate1);
            }
            if (StringUtil.isNotBlank((String)activityCommissionFrozenHoursString)) {
                int activityCommissionFrozenHours = Checker.checkStringIsUnsignedInteger((String)activityCommissionFrozenHoursString, (String)"\u6d3b\u52a8\u4f63\u91d1\u51bb\u7ed3\u5929\u6570");
                param.setActivityCommissionFrozenHours(activityCommissionFrozenHours);
            }
            if (StringUtil.isNotBlank((String)courseCommissionRate1String)) {
                int courseCommissionRate1 = Checker.checkStringIsUnsignedInteger((String)courseCommissionRate1String, (String)"\u8bfe\u7a0b\u4f63\u91d1\u6bd4\u7387");
                param.setCourseCommissionRate1(courseCommissionRate1);
            }
            if (StringUtil.isNotBlank((String)courseCommissionFrozenHoursString)) {
                int courseCommissionFrozenHours = Checker.checkStringIsUnsignedInteger((String)courseCommissionFrozenHoursString, (String)"\u8bfe\u7a0b\u4f63\u91d1\u51bb\u7ed3\u5929\u6570");
                param.setCourseCommissionFrozenHours(courseCommissionFrozenHours);
            }
            if (StringUtil.isNotBlank((String)orderCommissionRate1String)) {
                int orderCommissionRate1 = Checker.checkStringIsUnsignedInteger((String)orderCommissionRate1String, (String)"\u8ba2\u5355\u4f63\u91d1\u6bd4\u7387");
                param.setOrderCommissionRate1(orderCommissionRate1);
            }
            if (StringUtil.isNotBlank((String)orderCommissionFrozenHoursString)) {
                int orderCommissionFrozenHours = Checker.checkStringIsUnsignedInteger((String)orderCommissionFrozenHoursString, (String)"\u8ba2\u5355\u4f63\u91d1\u51bb\u7ed3\u5929\u6570");
                param.setOrderCommissionFrozenHours(orderCommissionFrozenHours);
            }
            this.service.updateSelective((Object)param);
            return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }
}

