/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.controller.admin;

import com.simple.mybatis.Page;
import com.wego168.distribute.enums.DistributerCommissionOrderTypeEnum;
import com.wego168.distribute.enums.DistributerCommissionStatusEnum;
import com.wego168.distribute.model.response.DistributerCommissionAdminPageResponse;
import com.wego168.distribute.model.response.DistributerCommissionAdminPageResponseV2;
import com.wego168.distribute.service.impl.DistributerCommissionService;
import com.wego168.util.StringUtil;
import com.wego168.util.excel.ExcelBook;
import com.wego168.util.excel.ExcelSheet;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.text.DecimalFormat;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminDistributerCommissionController")
public class DistributerCommissionController
extends SimpleController {
    @Autowired
    private DistributerCommissionService service;

    @GetMapping(value={"/api/admin/v1/distributer-commission/page"})
    public RestResponse selectPage(String name, String appellation, String mobile, String type, String status, String fromOrderTitle, HttpServletRequest request) {
        String appId = this.getAppId();
        Page page = this.buildPage(request);
        if (StringUtil.isBlank((String)type)) {
            type = "sharer";
        }
        List<DistributerCommissionAdminPageResponse> list = this.service.selectPageForAdmin(name, appellation, mobile, type, status, fromOrderTitle, appId, page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1.1/distributer-commission/page"})
    public RestResponse selectPage2(String appellation, String name, String mobile, String type, String status, String fromOrderTitle, String fromOrderNumber, HttpServletRequest request) {
        String appId = this.getAppId();
        Page page = this.buildPage(request);
        if (StringUtil.isBlank((String)type)) {
            type = "sharer";
        }
        List<DistributerCommissionAdminPageResponseV2> list = this.service.selectPageForAdminV2(appellation, name, mobile, fromOrderNumber, type, status, fromOrderTitle, appId, page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1.1/distributer-commission/export"})
    public void export2(String appellation, String name, String mobile, String type, String status, String fromOrderTitle, String fromOrderNumber, HttpServletRequest request, HttpServletResponse response) {
        String appId = this.getAppId();
        Page page = this.buildPage(request);
        page.setPageSize(10000);
        if (StringUtil.isBlank((String)type)) {
            type = "sharer";
        }
        List<DistributerCommissionAdminPageResponseV2> list = this.service.selectPageForAdminV2(appellation, name, mobile, fromOrderNumber, type, status, fromOrderTitle, appId, page);
        ExcelBook excelBook = ExcelBook.builder();
        ExcelSheet sheet = excelBook.createExcelSheet("\u63a8\u5e7f\u8ba2\u5355");
        sheet.setDataList(list);
        DecimalFormat formatter = new DecimalFormat("#######0.00");
        sheet.addCell("\u4ea4\u6613\u65f6\u95f4", 12, "createTime");
        sheet.addCell("\u8d2d\u4e70\u4eba\u4fe1\u606f", 24, i -> String.valueOf(i.getBuyerAppellation()) + i.getBuyerMobile());
        sheet.addCell("\u63a8\u5e7f\u5458\u4fe1\u606f", 24, i -> String.valueOf(i.getName()) + i.getLevel() + "\u7ea7\u63a8\u5e7f\u5458");
        sheet.addCell("\u63a8\u5e7f\u5458\u624b\u673a", 12, "mobile");
        sheet.addCell("\u8ba2\u5355\u7c7b\u578b", 10, i -> {
            String fromOrderType = i.getFromOrderType();
            DistributerCommissionOrderTypeEnum e = DistributerCommissionOrderTypeEnum.get(fromOrderType);
            return e == null ? fromOrderType : e.description();
        });
        sheet.addCell("\u5546\u54c1\u540d\u79f0", 30, "fromOrderTitle");
        sheet.addCell("\u5956\u52b1\u91d1\u989d", 10, i -> formatter.format((double)i.getAmount().intValue() * 0.01));
        sheet.addCell("\u5546\u6237", 20, "store");
        sheet.addCell("\u72b6\u6001", 10, i -> {
            String thisStatus = i.getStatus();
            DistributerCommissionStatusEnum e = DistributerCommissionStatusEnum.get(thisStatus);
            return e == null ? thisStatus : e.description();
        });
        excelBook.export("\u63a8\u5e7f\u8ba2\u5355.xls", response);
    }
}

