/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.controller.admin;

import com.wego168.distribute.domain.Distributer;
import com.wego168.distribute.domain.DistributerAccount;
import com.wego168.distribute.service.IDistributerAccountService;
import com.wego168.distribute.service.IDistributerService;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.IMemberAccountService;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;

public abstract class DistributerControllerSupport
extends SimpleController {
    public RestResponse registDistributer(String name, String mobile, String appId, String openId) {
        Checker.checkBlank((String)name, (String)"\u59d3\u540d");
        Checker.checkMobilePhoneNumber((String)mobile);
        Distributer existDistributer = this.getDistributerService().selectByMobile(mobile, appId);
        if (existDistributer != null) {
            return RestResponse.error((String)"\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        DistributerAccount existDistributerMobileAccount = this.getDistributerAccountService().selectByUsername(mobile, appId);
        if (existDistributerMobileAccount != null) {
            return RestResponse.error((String)"\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        MemberAccount mobileAccount = this.getMemberAccountService().selectByUsername(mobile);
        MemberAccount wechatAccount = this.getMemberAccountService().selectByUsername(openId);
        if (mobileAccount != null && wechatAccount != null && !StringUtil.equals((String)mobileAccount.getMemberId(), (String)wechatAccount.getMemberId())) {
            return RestResponse.error((String)"\u6ce8\u518c\u5931\u8d25\uff1a\u5fae\u4fe1\u8d26\u53f7\u548c\u624b\u673a\u53f7\u4e0d\u5339\u914d");
        }
        String distributerId = null;
        if (mobileAccount != null) {
            distributerId = mobileAccount.getMemberId();
        }
        if (wechatAccount != null) {
            distributerId = wechatAccount.getMemberId();
        }
        if (StringUtil.isNotBlank((String)distributerId) && (existDistributer = this.getDistributerService().selectById(distributerId)) != null) {
            return RestResponse.error((String)"\u60a8\u5df2\u7ecf\u6ce8\u518c\u4e86\u4e1a\u52a1\u5458\uff0c\u8bf7\u52ff\u91cd\u590d\u6ce8\u518c");
        }
        this.getDistributerService().registByMobile(wechatAccount, mobileAccount, mobile, name, openId, appId);
        return RestResponse.success((String)"\u606d\u559c\u60a8\u6ce8\u518c\u6210\u529f\uff0c\u7cfb\u7edf\u6b63\u5728\u5feb\u9a6c\u52a0\u97ad\u5ba1\u6838\uff0c\u5ba1\u6838\u540e\u5373\u53ef\u4f7f\u7528");
    }

    protected abstract IMemberAccountService getMemberAccountService();

    protected abstract IDistributerService getDistributerService();

    protected abstract IDistributerAccountService getDistributerAccountService();
}

