/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.controller.admin;

import com.wego168.base.advice.FileUploadUtil;
import com.wego168.base.domain.FileServer;
import com.wego168.base.service.FileServerService;
import com.wego168.distribute.domain.DistributerMaterial;
import com.wego168.distribute.service.impl.DistributerMaterialService;
import com.wego168.exception.WegoException;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.util.Checker;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import com.wego168.wx.domain.WxApp;
import com.wego168.wx.enums.WxAppServiceTypeEnum;
import com.wego168.wx.service.WxAppService;
import com.wego168.wx.token.SmallProgramUtil;
import java.awt.image.BufferedImage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminDistributerMaterialController")
public class DistributerMaterialController
extends SimpleController {
    @Autowired
    private WxAppService wxAppService;
    @Autowired
    private FileServerService fileServerService;
    @Autowired
    private SimpleRedisTemplate redisTemplate;
    @Autowired
    private DistributerMaterialService service;

    @GetMapping(value={"/api/admin/v1/distributer/material/get-regist-qrcode"})
    public RestResponse getRegistQrcode(String page, Boolean refresh) {
        int serviceType;
        WxApp miniProgram;
        refresh = refresh == null ? false : refresh;
        String appId = this.getAppId();
        String qrcodeUrl = this.redisTemplate.getString("distributer-regist-qrcode-" + appId);
        if (StringUtil.isNotBlank((String)qrcodeUrl) && !refresh.booleanValue()) {
            return RestResponse.success((Object)qrcodeUrl, (String)"\u83b7\u53d6\u6210\u529f");
        }
        if (StringUtil.isBlank((String)page)) {
            page = "pagesPromotion/distributer/index/index";
        }
        Checker.checkCondition(((miniProgram = this.wxAppService.selectByAppId(appId, serviceType = WxAppServiceTypeEnum.MINI_PROGRAM.value())) == null ? 1 : 0) != 0, (String)"\u5c0f\u7a0b\u5e8f\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801");
        String defaultServerId = "1";
        FileServer server = (FileServer)this.fileServerService.selectById((Object)defaultServerId);
        Checker.checkCondition((server == null ? 1 : 0) != 0, (String)"\u56fe\u7247\u670d\u52a1\u5668\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801");
        String scene = SequenceUtil.createUuid();
        BufferedImage bufferedImage = SmallProgramUtil.createMiniProgramQrcode((WxApp)miniProgram, (String)page, (String)scene);
        String errorMessage = "\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u5c0f\u7a0b\u5e8f[" + miniProgram.getName() + "]\u5c1a\u672a\u901a\u8fc7\u5ba1\u6838\uff0c\u6216\u9875\u9762\u8def\u5f84\u4e0d\u5b58\u5728";
        Checker.checkCondition((bufferedImage == null ? 1 : 0) != 0, (String)errorMessage);
        String fileName = String.valueOf(scene) + ".png";
        String cosBucket = "distributer-material/regist" + appId;
        String url = FileUploadUtil.upload2Cos((BufferedImage)bufferedImage, (String)cosBucket, (String)fileName, (FileServer)server);
        this.redisTemplate.setString("distributer-regist-qrcode-" + appId, String.valueOf(server.getHost()) + url);
        return RestResponse.success((Object)(String.valueOf(server.getHost()) + url), (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/distributer/material/{code}/update"})
    public RestResponse updateMaterial(String title, String content, @PathVariable String code) {
        try {
            Checker.checkBlankAndLength((String)title, (String)"\u6807\u9898", (int)128);
            Checker.checkBlank((String)content, (String)"\u5185\u5bb9");
            String appId = this.getAppId();
            DistributerMaterial material = this.service.selectByCode(code, appId);
            if (material == null) {
                this.service.insert(code, content, title, appId);
            } else {
                this.service.update(content, title, material.getId());
            }
            return RestResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/admin/v1/distributer/material/{code}/get"})
    public RestResponse getMaterial(@PathVariable String code) {
        String appId = this.getAppId();
        return RestResponse.success((Object)((Object)this.service.selectByCode(code, appId)), (String)"ok");
    }
}

