/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.controller.admin;

import com.wego168.base.domain.FileServer;
import com.wego168.base.domain.Storable;
import com.wego168.base.service.FileServerService;
import com.wego168.base.service.StorableService;
import com.wego168.distribute.domain.DistributerPosterBackground;
import com.wego168.distribute.service.impl.DistributerPosterBackgroundService;
import com.wego168.exception.WegoException;
import com.wego168.util.Checker;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminDistributerPosterBackgroundController")
public class DistributerPosterBackgroundController
extends SimpleController {
    @Autowired
    private DistributerPosterBackgroundService service;
    @Autowired
    private FileServerService fileServerService;
    @Autowired
    private StorableService storableService;

    @GetMapping(value={"/api/admin/v1/distributer-popster-background/{code}/get"})
    public RestResponse get(@PathVariable String code) {
        String appId = this.getAppId();
        DistributerPosterBackground background = this.service.selectByCode(code, appId);
        if (Objects.nonNull((Object)background)) {
            this.storableService.assembleHost((Storable)background);
        }
        return RestResponse.success((Object)((Object)background));
    }

    @PostMapping(value={"/api/admin/v1/distributer-popster-background/{code}/update"})
    public RestResponse update(String url, @PathVariable String code) {
        try {
            Checker.checkBlankAndLength((String)url, (String)"\u5e95\u56fe\u94fe\u63a5", (int)256);
            FileServer server = this.fileServerService.ensure();
            String appId = this.getAppId();
            String serverId = server.getId();
            DistributerPosterBackground background = this.service.selectByCode(code, appId);
            if (background != null) {
                DistributerPosterBackground param = new DistributerPosterBackground();
                param.setId(background.getId());
                param.setUpdateTime(new Date());
                param.setUrl(url);
                this.service.updateSelective((Object)param);
            } else {
                this.service.insert(code, url, serverId, appId);
            }
            return RestResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }
}

